/*
 * Copyright 1999, Alexander Feldman <alex@varna.net>
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of Alexander Feldman nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY ALEXANDER FELDMAN AND CONTRIBUTORS ``AS IS''
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL ALEXANDER FELDMAN OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef __ERRORS_HPP__
#define __ERRORS_HPP__

#include "globals.hpp"

#define SCL_MEMORYALLOCATION_ERROR			"Memory allocation error..."
#define SCL_DIVISIONBYZERO_ERROR			"Division by zero..."
#define SCL_BASE64DECODING_ERROR			"Base - 64 decoding error..."
#define SCL_OPEN_ERROR						"Open file error..."
#define SCL_WRITE_ERROR						"Write file error..."
#define SCL_READ_ERROR						"Read file error..."
#define SCL_KEYFILE_ERROR					"Invalid key file..."
#define SCL_PARSE_ERROR						"Error parsing ASN1 token..."
#define SCL_UNEXPECTEDTYPE_ERROR			"Unexpected ASN1 type read..."
#define SCL_UNEXPECTEDLENGTH_ERROR			"Unexpected ASN1 length read..."
#define SCL_BAD_RSA_MODULUSSIZE				"Bad RSA modulus size..."
#define SCL_BAD_RSA_OPERATION				"Bad RSA operation..."
#define SCL_OPEN_RAND_DEV_ERROR				"Error opening /dev/random device..."

#define RSA_OK							0x0000
#define RSA_PNOTPRIME					0x0001
#define RSA_QNOTPRIME					0x0002
#define RSA_BADN						0x0004
#define RSA_BADPUB						0x0008
#define RSA_BADSEC						0x0010
#define RSA_BADCOEFF					0x0020
#define RSA_BADDP						0x0040
#define RSA_BADDQ						0x0080

extern char *ppszRSACheckResults[];

#endif // __ERRORS_HPP__
