/*
 * Copyright 1999, Alexander Feldman <alex@varna.net>
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of Alexander Feldman nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY ALEXANDER FELDMAN AND CONTRIBUTORS ``AS IS''
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL ALEXANDER FELDMAN OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <sys/time.h>

#include "config.h"
#include "salt.hpp"
#include "getdef.hpp"
#include "rad64.hpp"

#if HAVE_LRAND48
#define SALT_RAND lrand48()
#elif HAVE_RANDOM
#define SALT_RAND random()
#else
#define SALT_RAND rand()
#endif

char *crypt_make_salt()
{
	static char szResult[40];

#if HAVE_SRAND48
	srand48((unsigned int)time(0) * getpid());
#elif HAVE_SRANDOM
	srandom((unsigned int)time(0) * getpid());
#else
	srand((unsigned int)time(0) * getpid());
#endif

	if (getdef_bool("MD5_CRYPT_ENAB")) {
		strcpy(szResult, "$1$");
		memcpy(szResult + 3, _l64a(SALT_RAND), 4);
		memcpy(szResult + 7, _l64a(SALT_RAND), 4);
		szResult[11] = '$';
		szResult[12] = '\0';
	} else {
		memcpy(szResult, _l64a(SALT_RAND), 4);
		memcpy(szResult + 4, _l64a(SALT_RAND), 4);
		szResult[8] = '\0';
	}

	return szResult;
}
