/*
 * Copyright 1999, Alexander Feldman <alex@varna.net>
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of Alexander Feldman nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY ALEXANDER FELDMAN AND CONTRIBUTORS ``AS IS''
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL ALEXANDER FELDMAN OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#include <ctype.h>
#include <stdio.h>
#include <syslog.h>
#include <stdlib.h>
#include <string.h>

#include "getdef.hpp"

#ifndef LOGINDEFS
	#define LOGINDEFS "/etc/login.defs"
#endif

int getdef_bool(const char *pszWhat)
{
	char *pszString = getdef_str(pszWhat);

	if (NULL == pszString)
		return 0;

	return (0 == strcasecmp(pszString, "yes"));
}

int getdef_num(const char *pszWhat, int iDefault)
{
	char *pszString = getdef_str(pszWhat);
	
	if (NULL == pszString)
		return iDefault;

	return (int)strtol(pszString, (char **)NULL, 0);
}

long getdef_long(const char *pszWhat, long lDefault)
{
	char *pszString = getdef_str(pszWhat);
	
	if (NULL == pszString)
		return lDefault;

	return strtol(pszString, (char **)NULL, 0);
}

char *getdef_str(const char *pszWhat)
{
	FILE *fpIn;
	static char szBuf[1024];
	char *pszName;
	char *pszItem;
	register int i;

	if (NULL == (fpIn = fopen(LOGINDEFS, "r"))) {
		syslog(LOG_USER | LOG_INFO, "passwdd: cannot open login definitions %s", LOGINDEFS);
		return NULL;
	}

	while (NULL != fgets(szBuf, sizeof(szBuf), fpIn)) {
		for (i = strlen(szBuf) - 1; i >= 0; --i)
			if (!isspace(szBuf[i]))
				break;
		szBuf[++i] = '\0';

		pszName = szBuf + strspn(szBuf, " \t");
		if (*pszName == '\0' || *pszName == '#')
			continue;

		pszItem = pszName + strcspn(pszName, " \t");
		if (*pszItem == '\0')
			continue;

		*pszItem++ = '\0';
		pszItem = pszItem + strspn(pszItem, " \"\t");
		*(pszItem + strcspn(pszItem, "\"")) = '\0';
		if (0 == strcmp(pszWhat, pszName)) {
			fclose(fpIn);
			return pszItem;
		}
	}
	fclose(fpIn);
	
	return NULL;
}
