#!/usr/bin/perl -w
require 5.002;
use Socket;
use CGI qw(:standard);
use PasswddIO;

$config_dir = "/usr/local/etc/";
$http_dir = "/usr/local/apache/htdocs/passwdd/";

$config_file = $config_dir . "passwdc.conf";
$results_file = $http_dir . "useradd_results.html";

$login = param("login");
$target = param("target");
$password = param("password");
$full_name = param("full_name");
$room_number = param("room_number");
$work_phone = param("work_phone");
$home_phone = param("home_phone");
$shell = param("shell");
$directory = param("directory");
$user_id = param("user_id");
$group_id = param("group_id");
$other = param("other");
$gecos = $full_name . ',' . $room_number . ',' . $work_phone . ',' . $home_phone . ',' . $other;

$port = 1099;
@targets = ("localhost");				# Default value

$final_string = "";

print header();

$user_id = -1 if ($user_id eq "");
$group_id = -1 if ($group_id eq "");

if ($login eq "") {
	$final_string = "The login field is NOT optional.\n";
	display_result($final_string);
	exit;
}

if ($password eq "") {
	$final_string = "The password field is NOT optional.\n";
	display_result($final_string);
	exit;
}

if ($target eq "") {
	$final_string = "The target field is NOT optional.\n";
	display_result($final_string);
	exit;
}

# Parse config file.
$section = "";
if (open(CONF, "< $config_file")) {
	while (<CONF>) {
		chomp;
		s/^\s*|\s*$//g;					# Remove leading and trailing spaces
										# and tabs.
		next if ($_ eq "");				# Skip empty lines.
		next if (/^[\#\%]/);			# Skip comments
		if (/^\[(.*)\]$/) {				# This is a section name because the
										# first character is '[' and the last
										# is ']'.
			$section = $_;
			next;
		}
		@entry = split(/\s*=\s*/); 
# Skip keys only or keys with more than one values.
		next if (defined($entry[2]) || !defined($entry[1]));
# Here begins program specific section.
		$key_directory = $entry[1] if ((lc($section) eq "[security]") && (lc($entry[0]) eq "key_directory"));
		$port = int($entry[1]) if ((lc($section) eq "[global]") && (lc($entry[0]) eq "port"));
		@targets = split('\s*[,;]\s*', $entry[1]) if ((lc($section) eq "[global]") && (lc($entry[0]) eq "targets"));
	}
	close(CONF);
}

foreach $remote (@targets) {
	$iaddr = inet_aton($remote);
	$paddr = sockaddr_in($port, $iaddr);
	$proto = getprotobyname('tcp');

	$final_string = $final_string . "Adding " . $target . " on ". $remote . "\n";
	unless (socket(SOCK, PF_INET, SOCK_STREAM, $proto)) {
		$final_string = $final_string . "Invalid socket call: $!\n";
		push(@failed, $remote);
		next;
	}
	unless (connect(SOCK, $paddr)) {
		$final_string = $final_string . "Invalid connect call: $!\n";
		close(SOCK);
		push(@failed, $remote);
		next;
	}
	$welcome = ReadChar(fileno(SOCK));
	if (!defined($welcome) || '+' ne $welcome) {
		$final_string = $final_string . "Invalid response from server.\n";
		close(SOCK);
		push(@failed, $remote);
		next;
	}
	$encrypted = ReadInteger(fileno(SOCK));
	if (!defined($encrypted) || $encrypted) {
		$key = $key_directory . "/" . $remote;
		$i = RecvRemoteKey(fileno(SOCK), $key);
		$final_string .= "Error allocating memory.\n" if (1 == $i);
		$final_string .= "Read public key error.\n" if (2 == $i);
		$final_string .= "Read public key error.\n" if (3 == $i);
		$final_string .= "Public key mismatch! Please remove manually the file '$key' if this is not an attack.\n" if (4 == $i);
		$final_string .= "Write public key error.\n" if (5 == $i);
		if (0 != $i) {
			WriteChar(fileno(SOCK), '*');
			push(@failed, $remote);
			next;
		}
		WriteChar(fileno(SOCK), '+');
	}
	WriteString(fileno(SOCK), $login);
	WritePassword(fileno(SOCK), $password);
	$go_ahead = ReadChar(fileno(SOCK));
	if (defined($go_ahead) && '!' eq $go_ahead) {
		WriteChar(fileno(SOCK), 'a');
		WriteString(fileno(SOCK), $target);
		WriteString(fileno(SOCK), $gecos);
		WriteString(fileno(SOCK), $directory);
		WriteString(fileno(SOCK), $shell);
		WriteInteger(fileno(SOCK), $user_id);
		WriteInteger(fileno(SOCK), $group_id);
		$result = ReadChar(fileno(SOCK));
		if (defined($result) && '+' eq $result) {
			$final_string = $final_string . "User successfully added.\n";
			if (defined(OLDSOCK)) {
				WriteString(fileno(OLDSOCK), "");
				close(OLDSOCK);
			}
			open(OLDSOCK, ">&SOCK");
			next;			
		} elsif ('-' eq $result) {
			$final_string = $final_string . "There is already such user on this host.\n";
		} elsif ('*' eq $result) {
			$final_string = $final_string . "User is not added. Server returned error.\n";
		} elsif ('~' eq $result) {
			$final_string = $final_string . "Access denied.\n";
		} elsif (':' eq $result) {
			$final_string = $final_string . "Bad shell.\n";
		} elsif (';' eq $result) {
			$final_string = $final_string . "Error creating direcotry.\n";
		} else {
			$final_string = $final_string . "Invalid response from server.\n";
		}
		close(SOCK);
		push(@failed, $remote);
		next;
	}
	if ('^' eq $go_ahead) {
		$final_string = $final_string . "Invalid login.\n";
		close(SOCK);
		push(@failed, $remote);
		next;
	} 
	$final_string = $final_string . "Invalid response from server.\n";
	close(SOCK);
	push(@failed, $remote);
}

foreach $server (@failed) {
	WriteString(fileno(OLDSOCK), $server);
}
WriteString(fileno(OLDSOCK), "");
close(OLDSOCK);

display_result($final_string);

sub display_result
{
	if (open(RESULTS, "< $results_file")) {
		while (<RESULTS>) {
			if (/<!-- Insert result here -->/) {
				$_[0] =~ s/\n/<BR>\n/g;
				printf($_[0]);
			} else {
				printf($_);
			}
		}
		close(RESULTS);
	}	
}