#!/usr/bin/perl -w
require 5.002;
use Socket;
use CGI qw(:standard);
use PasswddIO;

$config_dir = "/usr/local/etc/";
$http_dir = "/usr/local/apache/htdocs/passwdd/";

$config_file = $config_dir . "passwdc.conf";
$results_file = $http_dir . "passwdc_results.html";
$login_defs = $config_dir . "login.defs";

$login = param("login");
$target = param("target");
$old_password = param("old");
$new_password = param("new");
$new_password_confirm = param("verify");

$min_length = 5;
$max_length = 8;
$port = 1099;
@targets = ("localhost");				# Default value

$final_string = "";

print header();

# Parse login defs file
if (open(LOGINDEFS, "< $login_defs")) {
	while (<LOGINDEFS>) {
		chomp;
		s/^\s*|\s*$//g;					# Remove leading and trailing spaces
										# and tabs.
		next if ($_ eq "");				# Skip empty lines.
		next if (/^\#/);				# Skip comments
		@entry = split; 
# Skip keys only or keys with more than one values.
		next if (defined($entry[2]) || !defined($entry[1]));
# Here begins program specific section.
		$min_length = int($entry[1]) if (lc($entry[0]) eq "pass_min_len");
		$max_length = int($entry[1]) if (lc($entry[0]) eq "pass_max_len");
	}
	close(LOGINDEFS);
}

if ($login eq "") {
	$final_string = "The login field is NOT optional.\n";
	display_result($final_string);
	exit;
}

if ($old_password eq "") {
	$final_string = "The old password field is NOT optional.\n";
	display_result($final_string);
	exit;
}

if ($new_password ne $new_password_confirm) {
	$final_string = "The new password and its confirmation don't match. Try again.\n";
	display_result($final_string);
	exit;
}

if ((length($new_password) < $min_length) ||
    (length($new_password) > $max_length)) {
	$final_string = "The new password doesn't meet the length criteria. Try again.";
	display_result($final_string);
	exit;
}

if ($target eq "") {
	$target = $login;
}

# Parse config file.
$section = "";
if (open(CONF, "< $config_file")) {
	while (<CONF>) {
		chomp;
		s/^\s*|\s*$//g;					# Remove leading and trailing spaces
												# and tabs.
		next if ($_ eq "");				# Skip empty lines.
		next if (/^[\#\%]/);				#Skip comments
		if (/^\[(.*)\]$/) {				# This is a section name because the
												# first character is '[' and the last
												# is ']'.
			$section = $_;
			next;
		}
		@entry = split(/\s*=\s*/); 
# Skip keys only or keys with more than one values.
		next if (defined($entry[2]) || !defined($entry[1]));
# Here begins program specific section.
		$key_directory = $entry[1] if ((lc($section) eq "[security]") && (lc($entry[0]) eq "key_directory"));
		$port = int($entry[1]) if ((lc($section) eq "[global]") && (lc($entry[0]) eq "port"));
		@targets = split('\s*[,;]\s*', $entry[1]) if ((lc($section) eq "[global]") && (lc($entry[0]) eq "targets"));
	}
	close(CONF);
}

foreach $remote (@targets) {
	$iaddr = inet_aton($remote);
	$paddr = sockaddr_in($port, $iaddr);
	$proto = getprotobyname('tcp');

	$final_string = $final_string . "Changing password of " . $target . " on ". $remote . "\n";
	unless (socket(SOCK, PF_INET, SOCK_STREAM, $proto)) {
		$final_string = $final_string . "Invalid socket call: $!\n";
		push(@failed, $remote);
		next;
	}
	unless (connect(SOCK, $paddr)) {
		$final_string = $final_string . "Invalid connect call: $!\n";
		close(SOCK);
		push(@failed, $remote);
		next;
	}
	$welcome = ReadChar(fileno(SOCK));
	if (!defined($welcome) || '+' ne $welcome) {
		$final_string = $final_string . "Invalid response from server.\n";
		close(SOCK);
		push(@failed, $remote);
		next;
	}
	$encrypted = ReadInteger(fileno(SOCK));
	if (!defined($encrypted) || $encrypted) {
		$key = $key_directory . "/" . $remote;
		$i = RecvRemoteKey(fileno(SOCK), $key);
		$final_string .= "Error allocating memory.\n" if (1 == $i);
		$final_string .= "Read public key error.\n" if (2 == $i);
		$final_string .= "Read public key error.\n" if (3 == $i);
		$final_string .= "Public key mismatch! Please remove manually the file '$key' if this is not an attack.\n" if (4 == $i);
		$final_string .= "Write public key error.\n" if (5 == $i);
		if (0 != $i) {
			WriteChar(fileno(SOCK), '*');
			push(@failed, $remote);
			next;
		}
		WriteChar(fileno(SOCK), '+');
	}
	WriteString(fileno(SOCK), $login);
	WritePassword(fileno(SOCK), $old_password);
	$go_ahead = ReadChar(fileno(SOCK));
	if (defined($go_ahead) && '!' eq $go_ahead) {
		WriteChar(fileno(SOCK), 'r');
		WriteString(fileno(SOCK), $target);
		WritePassword(fileno(SOCK), $new_password);
		$result = ReadChar(fileno(SOCK));
		if (defined($result) && '+' eq $result) {
			$final_string = $final_string . "Group password successfully changed.\n";
			if (defined(OLDSOCK)) {
				WriteString(fileno(OLDSOCK), "");
				close(OLDSOCK);
			}
			open(OLDSOCK, ">&SOCK");
			next;
		} elsif ('-' eq $result) {
			$final_string = $final_string . "Invalid group specified.\n";
		} elsif ('$' eq $result) {
			$final_string = $final_string . "Weak password: %s" . read_string(SOCK) . "\n";
		} elsif ('*' eq $result) {
			$final_string = $final_string . "Password still unchanged. Server returned error.\n";
		} elsif ('~' eq $result) {
			$final_string = $final_string . "Access denied.\n";
		} else {
			$final_string = $final_string . "Invalid response from server.\n";
		}
		close(SOCK);
		push(@failed, $remote);
		next;
	}
	if ('^' eq $go_ahead) {
		$final_string = $final_string . "Invalid login.\n";
		close(SOCK);
		push(@failed, $remote);
		next;
	} 
	$final_string = $final_string . "Invalid response from server.\n";
	close(SOCK);
	push(@failed, $remote);
}

foreach $server (@failed) {
	WriteString(fileno(OLDSOCK), $server);
}
WriteString(fileno(OLDSOCK), "");
close(OLDSOCK);

display_result($final_string);

sub display_result
{
	if (open(RESULTS, "< $results_file")) {
		while (<RESULTS>) {
			if (/<!-- Insert result here -->/) {
				$_[0] =~ s/\n/<BR>\n/g;
				printf($_[0]);
			} else {
				printf($_);
			}
		}
		close(RESULTS);
	}	
}
