#include "mpi.h"
#include <string.h>
#include <fstream.h>
#include <ctype.h>

int permute(char* guess,char* passwd);
void printout(char* result);
void alter(char* guess,int i);

extern "C" {
char* crypt(char* s1,char* s2);
}

const int no_perms = 3; // Number of permutations to try on dictionary
                        // words - see function "alter" for more details

int main(int argc,char* argv[])
{
  int i,myid,numprocs,tag,flag;
  char* b = new char[80];
  char* c = new char[80];
  char* uname = new char[80];
  char* password = new char[80];
  char* testcase = new char[80];
  char* result = new char[80];
  char* request = new char[80];
  
  MPI_Comm world;
  MPI_Status status;

  MPI_Init(&argc,&argv);
  world = MPI_COMM_WORLD;
  MPI_Comm_size(world,&numprocs);
  MPI_Comm_rank(world,&myid);
  flag = 0;
  tag = 17;
  if (myid==0) {
    // I am the master node
    ifstream s(argv[1]);
    while (s.getline(b,80)) {
      c = strstr(b,":");
      for(i=1; i<=13; ++i) {
        password[i-1] = c[i];
      }
      uname = strtok(b,":");
      strcat(uname,":");
      strcpy(testcase,uname);
      strcat(testcase,password);
      MPI_Recv(request,80,MPI_CHAR,MPI_ANY_SOURCE,tag,world,&status);
      if (request[0] == '0') {
        // Nothing found, send another password
        MPI_Send(testcase,80,MPI_CHAR,status.MPI_SOURCE,
        tag,world);
      }
      else {
        // Print out the result to disk and send
        // another password to crack
        i = 1;
        while(request[i] != '\0') {
          result[i-1] = request[i];
          i++;
        }
        cout << result << endl;
        MPI_Send(testcase,80,MPI_CHAR,status.MPI_SOURCE,
        tag,world);
      }
      MPI_Bcast(&flag,1,MPI_INT,0,world);  
    }   
    s.close();
    flag = 1;
    MPI_Bcast(&flag,1,MPI_INT,0,world);
  }
  else {
    // I am a slave node
    int flag2,j;
    char* guess = new char[80];
    char* passwd = new char[80];
    strcpy(request,"0");
    MPI_Send(request,80,MPI_CHAR,0,tag,world);
    while(flag==0) {
      MPI_Bcast(&flag,1,MPI_INT,0,world);
      MPI_Recv(testcase,80,MPI_CHAR,0,tag,world,&status);
      // Let's get cracking...
      i = 0;
      while(testcase[i] != ':') {
        uname[i] = testcase[i];
        i++;
      }
      i++;
      j = 0;
      while(testcase[i] != '\0') {
        passwd[j] = testcase[i];
        i++;
        j++;
      }
      strcpy(guess,uname);
      flag2 = permute(guess,passwd);
      if (flag2==0) {
        ifstream s2(argv[2]);
        while(s2.getline(b,80) && flag2 == 0) {
          // Read in a word and check it
          strcpy(guess,b);
          flag2 = permute(guess,passwd);
        }
        s2.close();
        if (flag2 != 0) {
          // Send the good news
          strcpy(request,"1");
          strcat(uname,":");
          strcat(request,uname);
          strcat(request,guess);
          MPI_Send(request,80,MPI_CHAR,0,tag,world);
        }
        else {
          // Tant pis, look for another password
          strcpy(request,"0");
          MPI_Send(request,80,MPI_CHAR,0,tag,world);
        }
      }
      else {
        // We got a match with the username!
        strcpy(request,"1");
        strcat(uname,":");
        strcat(request,uname);
        strcat(request,guess);
        MPI_Send(request,80,MPI_CHAR,0,tag,world);
      }
      if (flag==0) MPI_Bcast(&flag,1,MPI_INT,0,world);
    }
  }
  MPI_Finalize();
}

int crypto(char* test,char* guess,char* salt,char* passwd)
{
  int output = 0;
  test = crypt(guess,salt);
  if (strcmp(test,passwd) == 0) output = 1;
  return output;
}

int permute(char* guess,char* passwd)
{
  // In this function we test the guess word and
  // various permutations of it along with all 
  // possible variations in the salt in an effort
  // to generate an encrypted password matching
  // the one we possess, passwd.
  // If we succeed, we return a one, else the 
  // calling program receives a zero.
  int k,output,flag = 0;
  char* saltcube = new char[3];
  char* test = new char[14];
  saltcube[0] = passwd[0];
  saltcube[1] = passwd[1];
  saltcube[2] = '\0';
  for(k=0; k<no_perms; ++k) {
    alter(guess,k);
    output = crypto(test,guess,saltcube,passwd);
    if (output == 1) break;
  }
  delete[] saltcube;
  delete[] test;
  return output;
}

void alter(char* guess,int number) 
{
  // Some relatively trivial permutations - if you want to
  // seriously hack away at passwords, you would probably 
  // need to add some other obvious tricks people try to use
  // to outwit potential intruders
  switch(number) {
    case 0:
      break;
    case 1:
      guess[0] = toupper(guess[0]);
      break;
    case 2:
      guess[0] = tolower(guess[0]);
      guess[1] = toupper(guess[1]);
      break;
    case 3:
      guess[1] = tolower(guess[1]);
      int n = strlen(guess);
      for(int i=0; i<n; ++i) {
        guess[i] = toupper(guess[i]);
      }
      break;
  }
}


