/*
 ** Compile: gcc -o test-promisc -Wall test-promisc.c
 ** Syntax: test-promisc [ device ]
 **
 ** Tests a specified device to check if a sniffer is watching it.
 ** Basiclly, if it finds that the specified device is accepting ALL of
 ** the packets that get routed through it then someone is tcpdumping
 ** or sniffing the socket (i.e. what a sniffer does).
 **
 ** +- NsO (blind@motherbrain.com) Trevor Linton
 */

#include <errno.h>
#include <linux/if.h>
#include <stdio.h>
#include <sys/socket.h>
#include <sys/ioctl.h>
#define size(p) (sizeof(p))

int dev_flags=0,
    device_flags=0,
    set_look_all=0;

int
main(int argc, char **argv) {
 struct ifreq ifreq, *ifr;
 struct ifconf ifc;
 char buf[BUFSIZ], *cp, *cplim;

 if(argc <= 1) {
	set_look_all++;
	fprintf(stdout, "Scanning all the devices for sniffers.\n");
 }

 /*
  ** Create socket to all the network devices.
  */

 if((dev_flags = socket(PF_INET, SOCK_DGRAM, 0)) < 0) {
	fprintf(stderr, "An error occured establiashing while establishing a socket\n");
	perror("socket");
	exit(1);
 }

 ifc.ifc_len = sizeof(buf);
 ifc.ifc_buf = buf;

 /*
  ** Grab configuration information from the socket
  */

 if(ioctl(dev_flags, SIOCGIFCONF, (char *)&ifc) < 0) {
	perror("SIOCGIFCONF");
	exit(1);
 }

 /*
  ** Bundle list then go through each device test to see if this
  ** is are device we're using; if so then evaluate it pull it's
  ** flags and evaluate it.
  */

 ifr = ifc.ifc_req;
 cplim=buf+ifc.ifc_len;
 for(cp = buf; cp < cplim;
		cp += sizeof (ifr->ifr_name) + size(ifr->ifr_addr)) {
		ifr = (struct ifreq *)cp;

		if(argv[1])
			if(strcmp(ifr->ifr_name, argv[1]) && !set_look_all)
				continue;

		ifreq = *ifr;
		if(ioctl(dev_flags, SIOCGIFFLAGS, (char *)&ifreq) < 0) {
			fprintf(stderr, "SIOCGIFFLAGS: %s (get interface flags): %s\n", ifr->ifr_name,strerror(errno));
			continue;
		}

		device_flags=0; device_flags = ifreq.ifr_flags;
		fprintf(stdout, "%s: ", ifreq.ifr_name);

		if((device_flags & IFF_PROMISC) != 0)
			fprintf(stdout, "Promiscuous: Sniffer detected.");
		else
			fprintf(stdout, "Not-Promiscous: No Sniffers detected.");

		fprintf(stdout, "\n");

		/*
		 ** Do not repeat list once we've found what we're looking
		 ** for 
		 */
		if(!set_look_all)
			exit(0);
		else
			continue;

 }
 if(!set_look_all)
	 fprintf(stdout, "%s: Unknown device.\n", argv[1]);
 return 1;
}
