// $Id: promisc.c,v null 1997/03/09 10:35:58 trevorl Exp $
// promisc.c: test devices for sniffers and device moniters.
//
// Copyright (C) 1997 Trevor F. Linton (blind@xmission.com)
//
// Created for Linux based loosely upon linux ioctl controls.
// ioctl() is used to detect different flags set on devices used 
// on your system.
//
// gcc -o sys_test promisc.c
//

#include <errno.h>
#if defined (__linux__)
#include <linux/if.h>
#elif defined (sun)
/**We Hope?**/
#include <net/if.h>
#endif
#include <stdio.h>
#include <sys/socket.h>
#include <sys/ioctl.h>
#define size(p) (sizeof(p))

/* #define LIBS */ // If you wish to use this in a library..

int dev_flags=0,
    device_flags=0,
    set_look_all=0;

int
main(int argc, char **argv) {
 struct ifreq ifreq, *ifr;
 struct ifconf ifc;
 char buf[BUFSIZ], *cp, *cplim;

 if(argc <= 1)
	set_look_all++;


 if((dev_flags = socket(PF_INET, SOCK_DGRAM, 0)) < 0) {
	fprintf(stderr, "An error occured establiashing while establishing a socket\n");
	perror("socket");
	exit(1);
 }

 ifc.ifc_len = sizeof(buf);
 ifc.ifc_buf = buf;

 if(ioctl(dev_flags, SIOCGIFCONF, (char *)&ifc) < 0) {
	perror("SIOCGIFCONF");
	exit(1);
 }
 ifr = ifc.ifc_req;
 cplim=buf+ifc.ifc_len;
 for(cp = buf; cp < cplim;
		cp += sizeof (ifr->ifr_name) + size(ifr->ifr_addr))
 {
		ifr = (struct ifreq *)cp;

		if(argv[1])
			if(strcmp(ifr->ifr_name, argv[1]) && !set_look_all)
				continue;

		ifreq = *ifr;
		if(ioctl(dev_flags, SIOCGIFFLAGS, (char *)&ifreq) < 0)
		{
			fprintf(stderr, "SIOCGIFFLAGS: %s (get interface flags): %s\n", ifr->ifr_name,strerror(errno));
			continue;
		}

		device_flags=0; device_flags = ifreq.ifr_flags;
		fprintf(stdout, "%s: ", ifreq.ifr_name);

		if((device_flags & IFF_PROMISC) != 0)
			fprintf(stdout, "Promiscuous: Sniffer detected.\n");
		else
			fprintf(stdout, "Not-Promiscous: No Sniffers detected.\n");

		if(!set_look_all)
			exit(0); // We're finished..
		else
			continue; // Go onto next device..

 }
 if(!set_look_all)
	 fprintf(stdout, "%s: Unknown device.\n", argv[1]); 
					// Device not found..
}
