/*
 *  linux/utmp.c
 *
 *  Version:    @(#)utmp.c    1.11  05/10/97
 *
 *  Copyright (C) 1996, 1997  Trevor Linton
 *  May be freely distributed with Light bar.
 */

#include <sys/types.h>
#ifdef SVR4
#include <utmpx.h>
#else
#include <utmp.h>
#endif
#include <fcntl.h>
#include <string.h>
#include <memory.h>
#define	bzero(a,n)	memset(a, 0, n)
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <malloc.h>

#ifndef	UTMP_FILE
#define	UTMP_FILE	"/etc/utmp"
#endif

extern	int	use_dmn;
extern	void	utmp_dmn ();
extern	struct	utmp	utent;

extern	struct	utmp	*getutent();
extern	struct	utmp	*getutline();
extern	void	setutent();
extern	void	endutent();
extern	time_t	time();
extern	char	*ttyname();
extern	long	lseek();

#define NO_UTENT \
	"No utmp entry. Please exec \"login\" from the lowest level \"sh\""
#define	NO_TTY \
	"Unable to determine your tty name."

/*
 * checkutmp - see if utmp file is correct for this process
 *
 *	System V is very picky about the contents of the utmp file
 *	and requires that a slot for the current process exist.
 *	The utmp file is scanned for an entry with the same process
 *	ID.  If no entry exists the process exits with a message.
 *
 *	The "picky" flag is for network and other logins that may
 *	use special flags.  It allows the pid checks to be overridden.
 *	This means that getty should never invoke login with any
 *	command line flags.
 */

void
checkutmp (picky)
int	picky;
{
	char	*line;
	struct	utmp	*ut, *getutline();
	int	pid = getpid ();

	setutent ();

	if (picky) {
		while ((ut = getutent ()))
			if (ut->ut_pid == pid)
				break;

		if (ut)
			utent = *ut;

		endutent ();

		if (! ut) {
 			(void) puts (NO_UTENT);
			exit (1);
		}
		/*
		 * If there is no ut_line value in this record, fill
		 * it in by getting the TTY name and stuffing it in
		 * the structure.  The UNIX/PC is broken in this regard
		 * and needs help ...
		 */

		if (utent.ut_line[0] == '\0')
		{
			if (! (line = ttyname (0))) {
				(void) puts (NO_TTY);
				exit (1);
			}
			if (strncmp (line, "/dev/", 5) == 0)
				line += 5;
			(void) strncpy (utent.ut_line, line,
					(int) sizeof utent.ut_line);
		}
	} else {
		if (! (line = ttyname (0))) {
			puts (NO_TTY);
			exit (1);
		}
		if (strncmp (line, "/dev/", 5) == 0)
			line += 5;

 		(void) strncpy (utent.ut_line, line,
  						(int) sizeof utent.ut_line);
		if ((ut = getutline (&utent)))
 			(void) strncpy (utent.ut_id, ut->ut_id,
 					(int) sizeof ut->ut_id);

		(void) strcpy (utent.ut_user, "LOGIN");
		utent.ut_pid = getpid ();
		utent.ut_type = LOGIN_PROCESS;
		(void) time (&utent.ut_time);
	}

	/*
	 * Hand-craft a new utmp entry.
	 */

	bzero (&utent, sizeof utent);
	if (! (line = ttyname (0))) {
		puts (NO_TTY);
		exit (1);
	}
	if (strncmp (line, "/dev/", 5) == 0)
		line += 5;

	(void) strncpy (utent.ut_line, line, sizeof utent.ut_line);
	(void) time (&utent.ut_time);
}

/*
 * setutmp - put a USER_PROCESS entry in the utmp file
 *
 *	setutmp changes the type of the current utmp entry to
 *	USER_PROCESS.  the wtmp file will be updated as well.
 */

void
setutmp (name, line)
char	*name;
char	*line;
{
//	struct	utmp	backup;
	struct	utmp	utmp;
	int	fd;
	int	found = 0;

	if (! (fd = open (UTMP_FILE, O_RDWR)))
		return;

 	while (! found && read (fd, &utmp, sizeof utmp) == sizeof utmp) {
 		if (! strncmp (line, utmp.ut_line, (int) sizeof utmp.ut_line))
			found++;
	}
	if (! found) {

		/*
		 * This is a brand-new entry.  Clear it out and fill it in
		 * later.
		 */

  		(void) bzero (&utmp, sizeof utmp);
 		(void) strncpy (utmp.ut_line, line, (int) sizeof utmp.ut_line);
	}

	/*
	 * Fill in the parts of the UTMP entry.  BSD has just the name,
	 * while System V has the name, PID and a type.
	 */

 	(void) strncpy (utmp.ut_user, name, (int) sizeof utent.ut_user);
	utmp.ut_type = USER_PROCESS;
	utmp.ut_pid = getpid ();

	/*
	 * Put in the current time (common to everyone)
	 */

	(void) time (&utmp.ut_time);

	/*
	 * Update the host name field for systems with networking support
	 */
#ifndef sun
	(void) strncpy (utmp.ut_host, utent.ut_host, (int) sizeof utmp.ut_host);
#endif
	/*
	 * Locate the correct position in the UTMP file for this
	 * entry.
	 */

	if (found)	/* Back up a splot */
		lseek (fd, (long) - sizeof utmp, 1);
	else		/* Otherwise, go to the end of the file */
		lseek (fd, (long) 0, 2);

	/*
	 * Scribble out the new entry and close the file.  We're done
	 * with UTMP, next we do WTMP (which is real easy, put it on
	 * the end of the file.
	 */

//	memcpy (&backup, &utmp, sizeof(backup));

//	if(use_dmn)
//		(void) utmp_dmn(&backup);

	(void) write (fd, &utmp, sizeof utmp);
	(void) close (fd);

	if ((fd = open (WTMP_FILE, O_WRONLY|O_APPEND)) >= 0) {
		(void) write (fd, &utmp, sizeof utmp);
		(void) close (fd);
	}
 	utent = utmp;
}
