/*
 *  linux/tty.c
 *
 *  Version:    @(#)tty.c    1.11  05/10/97
 *
 *  Copyright (C) 1996, 1997  Trevor Linton
 *  May be freely distributed with Light bar.
 */

#include <stdio.h>
#include <string.h>
#include <memory.h>
#include <unistd.h>

extern	void	addenv ();
char	*type;

int
_ttytype (line)
char	*line;
{
	FILE	*fp;
	char	buf[BUFSIZ];
	char	termvar[BUFSIZ];
	char	typefile[32];
	char	*cp;
	char	*port;
	char	*getenv ();

	strcmp(typefile, "/etc/ttys");

	if (getenv ("TERM")) {
		fprintf(stdout, "getenv(\"TERM\") return error\n");
		return 0;
	}
	if (access (typefile, 0))
		return 0;

	if (! (fp = fopen (typefile, "r"))) {
		perror (typefile);
		return 0;
	}
	while (fgets (buf, BUFSIZ, fp)) {
		if (buf[0] == '#')
			continue;

		if ((cp = strchr (buf, '\n')))
			*cp = '\0';

		if ((type = strtok (buf, " \t"))
				&& (port = strtok ((char *) 0, " \t"))) {
			if (strcmp (line, port) == 0)
				break;
		}
	}
	if (! feof (fp) && ! ferror (fp)) {
		strcat (strcpy (termvar, "TERM="), type);
		addenv (termvar);
	}
	fclose (fp);
	fprintf(stdout, "termvar: %s\n", termvar);

return 0;
}
