/*
 *  linux/shell.c
 *
 *  Version:    @(#)shell.c	1.11  05/24/97
 *
 *  Copyright (C) 1996, 1997  Trevor Linton
 *  May be freely distributed with Light bar.
 */

#ifndef sun
#include <paths.h>
#endif
#include <stdio.h>
#include <errno.h>
#include <syslog.h>
#include <stdlib.h>
#include <string.h>
#include <malloc.h>
#include <memory.h>
#include <unistd.h>
#include "config.h"
#include "lb_def.h"
#ifdef SYSLOGD
#include <syslog.h>
#endif
extern	char	*newenvp[];

extern	char	*host;
extern	char	*out_name;
extern	char	*out_tty;

#if defined (sun)
extern int setenv(const char *, const char *, int);
#endif

int
safexe (file, type)
	char	*file;
{
	/* Create alternative process */
		setenv("HOME", "/tmp", 1);
		setenv("LOGNAME", "nobody", 1);		/*
		setenv("USER", "nobody", 1);		 * Try and control
		setenv("SHELL", "/bin/login", 1);	 * Things like 
		unsetenv("LD_PRELOAD");			 * environment
		unsetenv("LD_LIBRARY_PATH");		 */

		if(type == 2)
		{
		if(setegid(-1) == -1) {
			if(setegid(-2) == -1) {
				fprintf(stderr, "Fatal: Couldn't set temporary user and group id's.\n");
				fflush(stderr);
				return -1;
			}

		}

		if(seteuid(-1) == -1) {
			if(seteuid(-2) == -1) {
				fprintf(stderr, "Fatal: Couldn't set temporary user and group id's.\n");
			}
		}
		}

		system(file);

		if(type == 2)
		{
		if(setegid(0) == -1) {
			fprintf(stderr, "Fatal: Couldn't return root privilages.\n");
			exit(0);	// Kill process
		}

		if(seteuid(0) == -1) {
			fprintf(stderr, "Fatal: Couldn't return root privilages.\n");
			exit(0);
		}
		}

return 0; /*NOTREACHED*/
}

void	shell (file, arg, safe)
char	*file;
char	*arg;
int	safe;
{
	char	arg0[BUFSIZ];
	FILE	*shell;
	char	*path;
	int	err;


	/* If safe = 1 then set the uid/guid to -1 and go ahead */
	/* If safe = 0 then do not (probably for shell exec) and go ahead */

#if defined(SYSLOGD) && !defined(RUN_SU)
#ifdef LOG_DAEMON
	openlog("login", LOG_PID, LOG_DAEMON);
#else
	openlog("login", LOG_PID);
#endif
#endif

	if(file == (char *) 0)
		exit (1);

	/*
	 * The argv[0]'th entry is usually the path name, but
	 * for various reasons the invoker may want to override
	 * that.  So, we determine the 0'th entry only if they
	 * don't want to tell us what it is themselves.
	 */

	if (arg == (char *) 0) {
		if ((path = strrchr (file, '/')))
			path++;
		else
			path = file;

		(void) strcpy (arg0 + 1, path);
		arg0[0] = '-';
		arg = arg0;
	}

	/* Try directly executing the binary shell */

	execle (file, arg, (char *) 0, newenvp);
	err = errno;



	/* Add support for script's its alright to have a script
	   as your shell. */
	if (err == ENOEXEC) {
		if ((shell = fopen (file, "r"))) {
			if (getc (shell) == '#' && getc (shell) == '!') {
				fclose (shell);
				execle ("/bin/sh", "sh",
					file, (char *) 0, newenvp);
				err = errno;
			} else {
				fclose (shell);
			}
		}
	}

	/* If after BOTH those we STILL can't execute the shell
	 * panic and quit..
	 */

	/* UNREACHED if safe = 1 */

#if defined(SYSLOGD) && !defined(RUN_SU)
	syslog(__LOG_ERR, "Error executing shell '%s'.\n", file);
	closelog ();
#endif
	sprintf (arg0, "Error executing shell: %s.", file);
	errno = err;
	perror (arg0);

	fprintf(stdout, "Executing default shell, /bin/sh.\n");

	/*	exit (err); Thing of the past
	 * Instead of getting a error and quitting just execute
	 * /bin/sh and print a error to the user and to syslogd. 
	 */

	execle(_PATH_BSHELL, arg, (char *) 0, newenvp);
}

