/*
 *  linux/shell.c
 *
 *  Version:    @(#)shell.c	1.11  05/24/97
 *
 *  Copyright (C) 1996, 1997  Trevor Linton
 *  May be freely distributed with Light bar.
 */

#ifndef sun
#include <paths.h>
#endif
#include <stdio.h>
#include <errno.h>
#include <syslog.h>
#include <stdlib.h>
#include <string.h>
#include <malloc.h>
#include <memory.h>
#include <unistd.h>
#include "config.h"
#include "lb_def.h"
#ifdef SYSLOGD
#include <syslog.h>
#endif
extern	char	*newenvp[];

extern	char	*host;
extern	char	*out_name;
extern	char	*out_tty;

#if defined (sun)
extern int setenv(const char *, const char *, int);
#endif

int
safexe (file, type)
	char	*file;
{
	/* Create alternative process */
		setenv("HOME", "/tmp", 1);
		setenv("LOGNAME", "nobody", 1);		/*
		setenv("USER", "nobody", 1);		 * Try and control
		setenv("SHELL", "/bin/login", 1);	 * Things like 
		unsetenv("LD_PRELOAD");			 * environment
		unsetenv("LD_LIBRARY_PATH");		 */

		if(type == 2)
		{
		if(setegid(-1) == -1) {
			if(setegid(-2) == -1) {
				fprintf(stderr, "Fatal: Couldn't set temporary user and group id's.\n");
				fflush(stderr);
				return -1;
			}

		}

		if(seteuid(-1) == -1) {
			if(seteuid(-2) == -1) {
				fprintf(stderr, "Fatal: Couldn't set temporary user and group id's.\n");
			}
		}
		}

		system(file);

		if(type == 2)
		{
		if(setegid(0) == -1) {
			fprintf(stderr, "Fatal: Couldn't return root privilages.\n");
			exit(0);	// Kill process
		}

		if(seteuid(0) == -1) {
			fprintf(stderr, "Fatal: Couldn't return root privilages.\n");
			exit(0);
		}
		}

return 0; /*NOTREACHED*/
}
