/*
 **
 ** linux/main.c v1.11
 **
 ** Read 'copyright' for more information on the distribution  license
 ** of lightbar.  
 **
 ** (c) 1997, All rights reserved.  Trevor F. Linton
 ** This is the main entry for the program.  This does sanity checks for
 ** login  scans some settings then throws things into init() the real
 ** function of lightbar.
 **
 */

#include <stdio.h>
#include <unistd.h>
#ifdef __linux__
#include <linux/version.h>
#include <linux/config.h>
#endif
#ifdef SVR4
#include <utmpx.h>
#else
#include <utmp.h>
#endif
#define DB_FILE	LB_CFG

#include "config.h"
#include "lb_def.h"


extern	int	init();
extern	char	*getentry();
struct status lb_stat;

/*
 ** writepid(program id); 
 ** Write the program id to the run directory.
 */

int
writepid(int pid) {
  FILE *pidfile;
  char buffer[BUFSIZ];

  if((pidfile = fopen(LB_PID, "w"))) {
	sprintf(buffer, "%d\n", pid);
	fputs(buffer, pidfile);
	fflush(pidfile);
  }
  fclose(pidfile);
  return 0;
}

/*
 ** help(Program name);
 ** prints out the current arguements allowed for lightbar.
 */

void
help(argv) 
char	**argv;
{
	fprintf(stderr, "usage: %s [ -fhpuv ] [ username ... ]\n", argv[0]);
	fprintf(stderr, "	-h	       This is to specify the hostname to use\n");
	fprintf(stderr, "	-u	       This is to specify the ident of the user\n");
	fprintf(stderr, "	-p	       Preserve the previous users environment.\n");
	fprintf(stderr, "	-f username    Pre-authenticated login\n");
	fprintf(stderr, "	-v	       Version information.\n");
	exit(0);
return; /*NOTREACHED*/
}

/*
 ** sanity_check(void);
 ** Check for bad settings that might compromise the system integrity
 ** exit on bad return 1 on good.
 */

void	 
sanity_check() {
 { 
   FILE *lb;

   if(!strcmp(getentry("SystemType"), "shadow"))
   {
     lb_stat.shadow = 1;
     lb_stat.normal = -1;
   } else {
     lb_stat.shadow = -1;
     lb_stat.normal = 1;
   }

   if(!(lb = fopen(LB_CFG, "r"))) {
	fprintf(stderr, "Warning: No configuration file exists: %s: File not found.\n", LB_CFG);
	fprintf(stderr, "Initalizing backup login routine; Please contact the system administration.\n");
	lb_stat.lb_conf=-1;
   } else
	lb_stat.lb_conf=1;

   fclose(lb);

   if((lb = fopen(getentry("Issue"), "r")))
	lb_stat.issue = -1;
   else
	lb_stat.issue = 1;

   fclose(lb);
 }

 return;
}


/*
 ** main(arguement amount, arguements, environment table);
 ** write's the program id checks for errors then goes into 
 ** the real main function.
 */

int
main(argc, argv, envp)
int	argc; 
char	**argv;
char	**envp;
{
  writepid(getpid());

/*
 ** make sure nothing happens to the program, check it's params.
 ** before continuing.  After that initalize the login and go ahead.
 */

  sanity_check();
  init(argc, argv, envp);

  return 0; /*NOTREACHED*/
}
