/*
 *  linux/mail.c
 *
 *  Version:	@(#)mail.c	1.11	05/08/97
 *
 *  Copyright (C) 1996, 1997  Trevor Linton
 *  May be freely distributed with Light bar.
 */

#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>

#include "config.h"
#include <pwd.h>


int preauth_flag;
struct	passwd	pwent;

int
mailcheck() {
	struct	stat	statbuf;
	char	mailbox[1024];

#if !defined(SENDMAIL) && !defined(QMAIL) && !defined(MAILBOX)
fprintf(stderr, "warning: Mail check not completed because no mail definition!\n");
	return 2;
#endif

#ifdef SENDMAIL
	sprintf(mailbox, "/var/spool/mail/%s", pwent.pw_name);
#endif
#ifdef MAILBOX
		sprintf(mailbox, "%s", MAILBOX);
#endif
#ifdef QMAIL
		sprintf(mailbox, "%s/Mailbox", pwent.pw_dir); 
#endif

	if(stat (mailbox, &statbuf) == -1 || statbuf.st_size == 0)
		fprintf(stdout, "No Mail.\n");
	else if (statbuf.st_atime > statbuf.st_mtime)
		fprintf(stdout, "You have mail.\n");
	else
		fprintf(stdout, "You have new mail.\n");
return 0;
}
