// $Id: macro.c,v 1.12 1997/06/09 9:33:15 trevorl Exp $
// macro.c: This handles what needed printing of files with macros.
//
// Trevor F. Linton, lightbar macro handling.
// Copyright (C) 1995, 1996, 1997 Trevor F. Linton
//
// These functions handle macros that you post into the issue/motd
// files.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by The Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in hope that it will be useful,
// but WITHOUT ANY WARRENTY; without even the implied warrenty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have recieved a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA, 02111-1307,
// USA.
//
// Trevor F. Linton  <blind@xmission.com>
// 720 east 5110 south
// Murray, UT 84107
//
// Use 'lightbar -v' once compiled for more information and or read
// LICENSE for the GNU GPL license lightbar is distributed under.
//

#if defined (__linux__)
#include <linux/config.h>
#include <linux/version.h>
#endif
#include <malloc.h>
#include <time.h>
#include <utmp.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <sys/utsname.h>

#include "lb_def.h"

struct	utmp	utent;
extern	int	safexe();
extern	char	*getentry ();
#ifdef sun
extern int gethostname (char *, int);
extern int getdomainname (char *, int);
#endif

int default_red[] = {0x00,0xaa,0x00,0xaa,0x00,0xaa,0x00,0xaa,0x55,0xff,0x55,0xff,0x55,0xff,0x55,0xff};
int default_grn[] = {0x00,0x00,0xaa,0x55,0x00,0x00,0xaa,0xaa,0x55,0x55,0xff,0xff,0x55,0x55,0xff,0xff};
int default_blu[] = {0x00,0x00,0x00,0x00,0xaa,0xaa,0xaa,0xaa,0x55,0x55,0x55,0x55,0xff,0xff,0xff,0xff};

unsigned int steps=64;
int fadetime = 0;

void
fadein() {
	unsigned long restsize;
	unsigned int i;
	unsigned char j, stepsize, red, green, blue;
	
	stepsize=256/steps;
	restsize=1000 * fadetime/steps;
	for (i=0; i<255; i+=stepsize) {
		fprintf(stdout, "\e[A\n");
		for (j=0; j<=15; j++) {
			red=default_red[j]*i/256;
			green=default_grn[j]*i/256;
			blue=default_blu[j]*i/256;
			fprintf(stdout,"\e]P%1X%02X%02X%02X", j,red,green,blue);
		}
		usleep(restsize);
	}
	fprintf(stdout,"\e]R");
}

void
fadeout() {
	unsigned long restsize;
	int i;
	unsigned char j, stepsize, red, green, blue;

	steps = 64;
	stepsize=256/steps;
	restsize=1000 * fadetime/steps;
	for(i=256; i>=0; i-=stepsize) {
		fprintf(stdout, "\e[A\n");
		for(j=0;j<=15;j++) {
			red = default_red[j]*i/256;
			green = default_grn[j]*i/256;
			blue = default_blu[j]*i/256;
			fprintf(stdout, "\e]P%1X%02X%02X%02X",j,red,green,blue);
		}
		usleep(restsize);
	}
}


void
evalmacro(name, tty, ident)
char	*name;
char	*tty;
char	*ident;
{
	time_t	tt = time(NULL);
	char	exp[BUFSIZ], tmp_buf[BUFSIZ];
	int	z;
	struct	utsname	uts;

		uname(&uts);

		if(!strcmp(name, "UTS_SYSNAME")) {
			fprintf(stdout, "%s", uts.sysname);
			return;
		} else if(!strcmp(name, "FADEIN")) {
			fadein();
			return;
		} else if(!strcmp(name, "FADEOUT")) {
			fadeout();
			return;
		} else if(!strcmp(name, "UTS_NODENAME")) {
			fprintf(stdout, "%s", uts.nodename);
			return;
		} else if(!strcmp(name,  "UTS_RELEASE")) {
			fprintf(stdout, "%s", uts.release);
			return;
		} else if(!strcmp(name, "UTS_VERSION")) {
			fprintf(stdout, "%s", uts.version);
			return;
		} else if(!strcmp(name, "UTS_MACHINE")) {
			fprintf (stdout, "%s", uts.machine);
			return;
		} else if (!strcmp(name, "UTS_DOMAINNAME")) {
			fprintf (stdout, "%s", uts.domainname);
			return;
		} else if(strcmp(name, "RELEASE") == 0) {
			fprintf(stdout, "%s", RELEASE);
			return;
		} else if(!strncmp(name, "EXEC", 4)) {
			safexe(&name[5], 0);
			return;
		} else if(strcmp(name, "SUBRELEASE") == 0) {
			fprintf(stdout, "%s", SUBRELEASE);
			return;
		} else if(strcmp(name, "TIME") == 0) {
			strcpy(exp, ctime(&tt));
			exp[strlen(exp) - 1] = 0;
			fprintf(stdout, "%s", exp);
			return;
		} else if(strcmp(name, "TERM") == 0) {
			fprintf(stdout, "%s",  getenv("TERM"));
			return;
		} else if(strcmp(name, "CLEAR") == 0){
			printf("\e[0m\e[2J\e[1;1H");
			return;
		} else if(strcmp(name, "TTY") == 0) {
			fprintf(stdout, "%s", tty);
			return;
		} else if(strcmp(name, "OS_VER") == 0) {
#ifndef sun
			fprintf(stdout, "%s", UTS_RELEASE);
#else
			fprintf(stdout, "unknown");
#endif
			return;
		} else if(strcmp(name, "OS") == 0) {
			/* Since this is only for linux.. uhm.. Linux ? */
#ifdef __linux__
			fprintf(stdout, "Linux");
#elif sun
			fprintf(stdout, "SunOS");
#else
			fprintf(stdout, "BSD");
#endif
			return;
		} else if(strcmp(name, "IDENT") == 0) {
			fprintf(stdout, "%s", ident);
			return;
		} else if(strcmp(name, "RUSER") == 0) {
			for(z=0;ident[z] != '@';z++)
				putchar(ident[z]);
			return;
		} else if(strcmp(name, "LHOST") == 0) {
			gethostname(tmp_buf, sizeof(tmp_buf));
			fprintf(stdout, "%s", tmp_buf);
			return;			
		} else if(strcmp(name, "LDOMAIN") == 0) {
			getdomainname(tmp_buf, sizeof(tmp_buf));
			fprintf(stdout, "%s", tmp_buf);
			return;
		} else if(!strncmp(name, "SLEEP", 5)) {
			sleep(atoi(&name[6]));
			return;
		}

	/**
	 ** If the program has made is this far then the macro
	 ** doesn't exist, let the person print it out.
	 **/
}

void
print_file(argv, ident, file)
char	*argv;
char	*ident;
char	*file;
{
FILE	*issue;
char	buf[BUFSIZ], macro[BUFSIZ];
int	i=0, d=0, issue_file=0;

if(strcmp(file, getentry("Issue")) == 0)
	issue_file++;

if((issue = fopen(file, "r"))) {

   while(fgets(buf, sizeof(buf), issue)) {
	for(i=0;i<strlen(buf); i++) {
		if(buf[i] == '@' && buf[i + 1] == '(') {
			i+=2;

			memset(macro, 0, sizeof(macro));
			while(buf[i] != ')') {
				macro[d] = buf[i];
				d++;
				i++;
			}
			evalmacro(macro, argv, ident);
			memset(macro, 0, sizeof(macro));
			d=0;
			continue;
		}
		putc(buf[i], stdout);
	}
   }

	fflush(stdout);
}
}
	
