/*
 *  linux/login.c
 *
 *  Version:	@(#)login.c	1.11  05/09/97
 *
 *  Copyright (C) 1996, 1997  Trevor Linton
 *  May be freely distributed with Light bar.
 *
 * Comments: This code for some reason is EXTREMELY touchy
 * i don't know what it is but even comment codes seem to 
 * mess things up i've actually had part of the syslog appear
 * in my fscking string!  I have no clue what the hell it is
 * weither it's bad code or bad compiler but it's annoying me.
 * so stay clear of the baduser part function it's the most touchy.
 * All works, thanks :)
 *
 */
#include <fcntl.h>
#ifdef __linux__
#include <linux/config.h>
#include <linux/version.h>
#endif
#include <stdio.h>
#include <signal.h>
#include <stdlib.h>
#include <string.h>
#include <sys/ioctl.h>
#include <sys/utsname.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <time.h>
#if defined(__linux__) || defined(SVR4)
#	include	<termios.h>
#else
#	include <termio.h>
#endif
#include <unistd.h>
#include <malloc.h>
#ifndef SET_SHAD
#include <shadow.h>
#endif
#include "lb_def.h"
#include "config.h"

#ifdef SYSLOGD
#include <syslog.h>
#endif
extern	int	hangup_dmn();
extern	int	_timeout;
extern	int	use_dmn;
extern	struct	status	lb_stat;
extern	int	safexe();
extern	char	*getentry();
extern	void	plot();
extern	void	endpwent();
extern	void	endgrent();
extern	void	seterminal();
//extern	struct	blog	btmp;

SIGNAL_TYPE
timedout()
{
	struct termio ti;

	fprintf(stderr, "\nLogin timed out after %d seconds\n", _timeout);
	fflush(stderr); // Make sure the message gets relayed before exit

	/* Reset echo before leaving abruptly. */
	(void) ioctl(0, TCGETA, &ti);
	ti.c_lflag |= ECHO;
	(void) ioctl(0, TCSETA, &ti);

	if(use_dmn)
		hangup_dmn();

	exit(0);
}


SIGNAL_TYPE
achk (sig)
int	sig;
{
	/*
	 * Ahhhh crap.. An error caused us to quit. report the error into
	 * the syslog close the logs up, close up the password files
	 * and get the hell outta here...
	 */

#ifdef SYSLOGD
	syslog(__LOG_ERR, SEGFLT);
	closelog();
#endif
	endpwent();
	endgrent();

#ifndef SET_SHAD
	if(lb_stat.shadow) {
	endspent();
	endsgent();
	}
#endif

	if(use_dmn)
		hangup_dmn();

	exit (0);
}

void
spasswd(name)
	char	*name;
{
	plot(getentry("YPass"), getentry("XPass"));
}

void
version()
{
struct utsname utsbuf;
fprintf(stdout, "LightBar %s-%s, Copyright (C) 1997, Trevor F. Linton <blind@motherbrain.com>\n", RELEASE, SUBRELEASE);
fprintf(stdout, "LightBar comes with ABSOLUTELY NO WARRENTY\n");
fprintf(stdout, "LightBar is free software distributed under the GPL License\n\n");

if (!uname(&utsbuf))
	fprintf(stdout, "System Info: %s %s %s %s\n\n", utsbuf.sysname, utsbuf.nodename, utsbuf.release, utsbuf.version);

fprintf(stdout, "LightBar compiled definitions:\n");
	if(lb_stat.shadow)
	fprintf(stdout, "Compiled support for 'SHADOW' package.\n");
	else
	fprintf(stdout, "Compiled support for 'NORMAL' package.\n");


#ifdef QMAIL
	fprintf(stdout, "Compiled support for 'QMAIL' Mailbox.\n");
#endif
#ifdef SENDMAIL
	fprintf(stdout, "Compiled support for 'SENDMAIL' Mailbox.\n");
#endif
#ifdef MAILBOX
	fprintf(stdout, "Compiled support for '%s' Mailbox.\n", MAILBOX);
#endif

exit(0);
return; /*NOTREACHED*/
}

char *
get_name() {
	struct	termios ttyb, ttysav;
	char *cp;
	int c, count;
	FILE *tty;
	static char pbuf[128];

	count=0;

	if ((tty = fdopen(open(TTY, O_RDWR), "r")) == NULL)
		tty=stdin;
	else
		setbuf(tty, (char *)NULL);

	ioctl(fileno(tty), TCGETS, &ttyb);
	ioctl(fileno(tty), TCGETS, &ttysav);
	ttyb.c_lflag &= ~(ECHO|ISIG);
	ioctl(fileno(tty), TCSETS, &ttyb);

	cp=pbuf;
	seterminal(0);

	for (;;) {
		c=getchar();

		if (c == '\r' || c == '\n' || c == EOF)
			break;

		if((cp<&pbuf[120])) {
			if ((c != '') & (c != ''))
			{
				if(count<atoi(getentry("LoginLength")))
				{
					putchar(c);
					fflush(stdout);


					count++;
					*cp++ = c;
				}
			} else if (count>0) {
				count--;cp--;
				fputs("\b \b\0", stdout);
				fflush(stdout);
			}
		} else
			break;
	}

	*cp = '\0';
	fprintf(stdout, "\r\n");
	fflush(stdout);
	ioctl(fileno(tty), TCSETS, &ttysav);

	if(tty != stdin)
		fclose(tty);

	return(pbuf);
	seterminal(1);
}

void
plot (y, x) 
char	*y;
char	*x;
{

if(strcmp(x, "0") == 0 || strcmp(x, "") == 0 || x[0] == '\0')
				return;

if(!lb_stat.lb_conf || strcmp(x, "noval") == 0)
				return;

printf("\e[%s;%sH", y, x);
}

void
failed_login(name, hostname, tty, username)
	char	*name;
	char	*hostname;
	char	*tty;
	char	*username;
{
	plot(getentry("YReturn"), getentry("XReturn"));

	if(!lb_stat.lb_conf || strcmp(getentry("ReturnMessage"), "noval"))
		fprintf(stdout, "%s\n", getentry("ReturnMessage"));
	else
		fprintf(stdout, "Login incorrect.\n");

	plot(getentry("Y"), getentry("X"));

	if(!lb_stat.lb_conf || strcmp(getentry("ReturnLogin"), "noval"))
		fprintf(stdout, "%s", getentry("ReturnLogin"));

	plot(getentry("YPass"), getentry("XPass"));

	if(!lb_stat.lb_conf || !strcmp(getentry("ReturnPasswd"), "noval"))
				;
	else
		fprintf(stdout, "%s", getentry("ReturnPasswd"));
}


void
obtain_login()
{
	int	v;
	char	tmp_buf[1024], hostname[BUFSIZ], prompt[1024];
	char	prompt_buf[1024], tmp[BUFSIZ];

	memset(prompt, 0, sizeof(prompt));
	memset(prompt_buf, 0, sizeof(prompt_buf));
	memset(tmp, 0, sizeof(tmp));
	memset(tmp_buf, 0, sizeof(tmp_buf));

	memset(hostname, 0, sizeof(hostname));

	plot(getentry("Y"), getentry("X"));

	/* Get basic prompt from file */

	gethostname(hostname, sizeof(hostname));
	strcpy(prompt, getentry("LoginPrompt"));

	if(strcmp(prompt, "noval") == 0 || !lb_stat.lb_conf)
			strcpy(prompt, "login: ");

	for(v=0;v<strlen(prompt);v++) {
		if(prompt[v] == '%' && prompt[v + 1] == 'h') {
			if(prompt_buf[0] == '\0')
				strcpy(prompt_buf, hostname);
			else
				strcat(prompt_buf, hostname);
			v++;
			continue;
		}
		tmp[0] = prompt[v];
		if(tmp[0] != '\0')
			strcat(prompt_buf, tmp);
	}
	memset(prompt, 0, sizeof(prompt));
	fprintf(stdout, "%s", prompt_buf);
	fflush(stdout);
	memset(prompt_buf, 0, sizeof(prompt_buf));
}
