/*
 *  linux/log.c
 *
 *  Version:	@(#)log.c	1.11	05/08/97
 *
 *  Copyright (C) 1996, 1997  Trevor Linton
 *  May be freely distributed with Light bar.
 */
#include <errno.h>
#include <sys/types.h>
#ifdef SVR4
#include <utmpx.h>
#else
#include <utmp.h>
#endif
#include <pwd.h>
#include <fcntl.h>
#include <time.h>
#include <string.h>
#include <memory.h>
#include <unistd.h>
#include <stdio.h>
#include <stdlib.h>
	
/* For the network settings */
#include <netdb.h>
#include <netinet/in.h>
#include <sys/socket.h>
#include <arpa/inet.h>
#include "lb_def.h"
#ifdef SYSLOGD
#include <syslog.h>
#endif

#define LASTFILE "/var/adm/lastlog"

extern	char	*getentry();
int	sockfd; /* Global socket */

extern	struct	utmp	utent;
extern	struct	passwd	pwent;
extern	struct	lastlog	lastlog;
extern	char	**environ;


long	lseek ();
time_t	time ();

void	log ()
{
	int	fd;
	off_t	offset;
	struct	lastlog	newlog;

	if ((fd = open (LASTFILE, O_RDWR)) == -1)
		return;

	offset = pwent.pw_uid * sizeof lastlog;

	if (lseek (fd, offset, 0) != offset) {
		(void) close (fd);
		return;
	}


	if (read (fd, (char *) &lastlog, sizeof lastlog) != sizeof lastlog)
		memset ((char *) &lastlog, sizeof lastlog, 0);
	newlog = lastlog;

	(void) time (&newlog.ll_time);
	(void) strncpy (newlog.ll_line, utent.ut_line, sizeof newlog.ll_line);
#ifndef sun
	(void) strncpy (newlog.ll_host, utent.ut_host, sizeof newlog.ll_host);
#else
	(void) strcpy(newlog.ll_host, "unknown");
#endif
	(void) lseek (fd, offset, 0);
	(void) write (fd, (char *) &newlog, sizeof newlog);
	(void) close (fd);
}
