// $Id: init.c,v 1.12 1997/06/09 9:33:15 trevorl Exp $
// init.c: the backbone for lightbar's main function.
//
// Trevor F. Linton, lightbar init.
// Copyright (C) 1995, 1996, 1997 Trevor F. Linton
// 
// This function takes through the main functions of
// lightbar and checks necessary problems such as limits checking 
// password checking and does main things launching subroutines and
// functions that do the dirty work. :-)
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by The Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in hope that it will be useful,
// but WITHOUT ANY WARRENTY; without even the implied warrenty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have recieved a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA, 02111-1307,
// USA.
//
// Trevor F. Linton  <blind@xmission.com>
// 720 east 5110 south
// Murray, UT 84107
//
// Use 'lightbar -v' once compiled for more information and or read
// LICENSE for the GNU GPL license lightbar is distributed under.
//

#ifndef lint
char copyright[] =
"@(#) Copyright (c) 1996, 1997, Trevor Linton.  All rights reserved.\n";
#endif

#include <ctype.h>
#include <curses.h>
#include <errno.h>
#include <fcntl.h>
#ifdef __linux__
#include <linux/config.h>
#include <linux/if.h>
#include <linux/version.h>
#endif
#include <grp.h>
#include <malloc.h>
#include <netdb.h>
#if !defined ( sun )
#include <paths.h>
#endif
#include <pwd.h>
#ifndef SET_SHAD
#include <shadow.h> 
#endif
#include <signal.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#ifdef SYSLOGD
#	include	<syslog.h>
#endif
#include <sys/ioctl.h>
#include <sys/resource.h>
#include <sys/socket.h>
#include <sys/stat.h>
#include <sys/time.h>
#include <sys/types.h>
#include <sys/utsname.h>
#if defined(SVR4) || defined(__linux__)
#	include <termios.h>
#else
#	include <termio.h>
#endif
#include <time.h>
#include <unistd.h>

/* Support for KERBEROS tickets */
#ifdef KERBEROS
#include <kerberos/krb.h>
#include <sys/termios.h>
char	realm[REALM_SZ];
int	kerror = KSUCCESS, notickets = 1;
#endif
#include <utmp.h>

#include "config.h"
#include "lb_def.h"

#if defined(SVR4) || defined(SUN4) || defined(__linux__)
#	define	STTY(fd,termio)  tcsetattr (fd, TCSANOW, termio)
#	define	GTTY(fd,termio)  tcgetattr (fd, termio)
#	define	TERMIO	struct	termios
#else
#ifndef BSD
#	define	STTY(fd,termio)  ioctl(fd, TCSETA, termio)
#	define	GTTY(fd,termio)  ioctl(fd, TCGETA, termio)
#	define  TERMIO	struct	termio
#else
#	define	STTY(fd,termio)  stty(fd, termio)
#	define  GTTY(fd,termio)  gtty(fd, termio)
#endif
#endif
TERMIO termio;

#define size(p) (sizeof(p))

#ifndef __linux__
	int	_timeout=300;
#else
	int	_timeout=60;
#endif

/* Set and control signals with functions */
SIGNAL_TYPE	achk(int sig);
SIGNAL_TYPE	timedout();

/* Global definitions */
int	out_gid, cflg=0;
int	mflg=0, pflg, uflg, hflg, maxenv = MAXENV, newenvc = 0, preauth_flag;
int	allow_severity = SEVERITY;
char	*newenvp[MAXENV]; /* Setup string array for the new environment. */
char	host[BUFSIZ];
#if defined ( __linux__ )
const	char	*linux_banner = "\nLinux " UTS_RELEASE ""; /* default issue.net print */
#endif
extern	struct	status	lb_stat;

/* Structures and members */
	struct	btmp	btmp;
#ifdef ENB_LAST
	struct	lastlog	lastlog;
#endif
	struct	passwd	pwent;
	struct	utmp	utent;

// vast amount of functions init needs for its completion.
extern	char	*getentry ();
extern	char	*getenv ();
extern	char	*get_name ();
extern	char	*optarg;
extern	int	checkage ();
extern	int	connect_dmn ();
extern	int	hangup_dmn ();
extern	int	hushed ();
extern	int	getentry_num ();
extern	int	mailcheck ();
extern	int	print_file ();
extern	int	putbtline ();
extern	int	pw_auth ();
extern	int	safexe ();
extern	int	send_packet ();
#ifdef sun
extern  int	setpriority (int, id_t, int);
extern	int	gethostname (char *, int);
extern 	void	bzero(void *, size_t);
extern	char	*crypt (char *, char *);
#endif
extern	int	syslog_dmn ();
extern	void	addenv ();
extern	void	checkutmp ();
extern	void	failcheck ();
extern	void	failed_login ();
extern	void	help ();
extern	void	log ();
extern	void	obtain_login ();
extern	void	version ();
extern	void	setup ();
extern	void	setutmp ();
extern	void	shell ();
extern	void	spasswd ();
extern	struct	passwd	*getpwnam ();
extern	struct	group	*getgrnam ();

int use_dmn=0;

/* Point;print;wait;exit */
void
perr(argv, time)
	char *argv;
	int time;
{
	struct termio ti;

	fprintf(stderr, "%s\n", argv);
	fflush(stderr);

	(void) ioctl(0, TCGETA, &ti);
	ti.c_lflag |= ECHO;
	(void) ioctl(0, TCSETA, &ti);
	
	if(use_dmn)
		hangup_dmn();

	sleep(time);
	exit(0);
}

void
check_promisc()
{
#ifndef sun
	if(strcmp(getentry("CheckForSniffers"), "yes"))
			return;
	{
	   /** Devices list is in ProMiscDevice **/
	   struct ifreq ifreq, *ifr;
	   struct ifconf ifc;
	   char buf[BUFSIZ], *cpb, *cplim;
	   int s=0, dev_flags=0;

	   if((s = socket(PF_INET, SOCK_DGRAM, 0)) < 0) {
	//     syslog(__LOG_ERR, "Checking for sniffers failed creating
	//     socket: %s\n", strerror(errno));
	     return; /** Don't disallow a connection because socket's fscked **/
	   }

	   ifc.ifc_len = sizeof(buf);
	   ifc.ifc_buf = buf;

	   if(ioctl(s, SIOCGIFCONF, (char *)&ifc) < 0) {
	    // syslog(__LOG_ERR, "Checking for sniffers failed examining
	    // devices.
	     return;
	   }

	   ifr = ifc.ifc_req;
	   cplim=buf+ifc.ifc_len;
	   for(cpb = buf; cpb < cplim;
			cpb += sizeof (ifr->ifr_name) + size(ifr->ifr_addr)) {
			ifr = (struct ifreq *)cpb;

			/*
			 ** If the device listed in ifr->ifr_name is in
			 ** the source getentry("ProMiscDevice") then 
			 ** go ahead; else continue.
			 **/

			ifreq = *ifr;
			if(ioctl(s, SIOCGIFFLAGS, (char *)&ifreq) < 0) {
				continue; /** couldn't get flags; skip to
					      next device **/
			}

			dev_flags=0;dev_flags=ifreq.ifr_flags;
			if((dev_flags & IFF_PROMISC) != 0) {
				perr("\nA sniffer has been detected monitering this line. Please try again later.\n",1);
			} else
				continue;
	   }
	}
#else
/** eep.. sunos doesn't like ioctl flags.. sighhh... **/
return;
#endif
}

/*
 * Setlimits, basiclly takes a user and sets limits on his account
 * according to the configuration file /etc/limits.
 */

char	line[BUFSIZ], *groupname, globaluser[BUFSIZ], grp2[BUFSIZ];
char	blunt[BUFSIZ];
FILE	*limit_db,*fp_next;
int	line_num, found, group, user, found_lim=0, global_gid=0, mx_l=0;
struct	rlimit rlim;

int
setlim(type)
	int	type;
{
	struct	utmp	_utmp;
	struct	passwd	*_pass;
	struct	group	*grp;
	char	limit[BUFSIZ];
	int v=0, lim=0, grp_man=0;

	for(;;) {
		fgets(line, sizeof(line), limit_db);
		line_num++;
		found=0;

		if(line[0] == '}' || line[1] == '}')
			break;
		
		if(line[0] == '\n' || line[0] == '\0')
			continue;
	
		for(v=0;line[v] == ' ' || line[v] == '\t';v++)
				;
		if(v)
			  strcpy(limit, &line[v]);
		else
			  strcpy(limit, line);

		limit[strlen(limit) -1 ]='\0';

		if(type == 1) {
			if(!strncmp(limit, "badlogin", 8)) {
				safexe(&limit[9], 2);
				found++;
				return 0;
			}
		} else {
#ifndef sun
		if(!strncmp(limit, "process", 7)) {
			rlim.rlim_cur=atoi(&limit[8]);
			rlim.rlim_max=atoi(&limit[8]);
			setrlimit(RLIMIT_NPROC, &rlim);
			found++;
		}
#endif
		if(!strncmp(limit, "maxlogins", 9)) {

			(void)setutent();

			if (!(fp_next = fopen(_PATH_UTMP, "r"))) {
				fprintf(stderr, "Warning: cannot read %s.\n", _PATH_UTMP);
				return -1;
			}

			/* Scan for multiple logins etc */

			if(group) {
				while(fread((char *)&_utmp, sizeof(_utmp), 1, fp_next) == 1) {
					if (!_utmp.ut_name[0] ||
					    !strncmp(_utmp.ut_name,"root", sizeof(_utmp.ut_name)))
						continue;

				if(limit[10] == ':') {
					if(!strcmp(_utmp.ut_name, blunt))
						mx_l++;

					if(mx_l > atoi(&limit[11]))
						perr("\nYou have too many sessions currently logged in.\n", 1);

				} else {

//					if(!strcmp(_utmp.ut_name,"LOGIN"))
//						continue;

					_pass=getpwnam(_utmp.ut_name);
					if(!(grp=getgrgid(_pass->pw_gid)))
						continue;

					if(!strcmp(grp->gr_name, grp2))
						grp_man++;

					if(grp_man > atoi(&limit[10]))
						perr("\nSorry, to many logged in users.  Try logging in again later.\n", 1);

				}
				}
			}
		
			if(user) {
				while(fread((char *)&_utmp, sizeof(_utmp),1, fp_next) == 1) {
					if(!_utmp.ut_name[0] ||
					   !strncmp(_utmp.ut_name, "root",sizeof(_utmp.ut_name)))
						continue;

					if(!strcmp(_utmp.ut_name,globaluser))
						grp_man++;

					if(grp_man > atoi(&limit[10]))
						perr("\nYou have too many sessions currently logged in.\n", 2);
				}
			}
		   fclose(fp_next);
		   found++;
		}

		if(!strncmp(limit, "badlogin", 8))
			found++;

		if(!strncmp(limit, "cpu", 3)) {
#ifdef DEBUG
		fprintf(stderr, "Running cpu limit.\n");
#endif
			memset(&rlim, 0, sizeof(rlim));
			lim=atoi(&limit[4]);
			if(!lim) break;
			lim*=60;
			rlim.rlim_cur=lim;
			rlim.rlim_max=lim;
			setrlimit(RLIMIT_CPU, &rlim);
			found++;
		}

		if(!strncmp(limit, "files", 5)) {
#ifdef DEBUG
		fprintf(stderr, "Running files limit.\n");
#endif
			rlim.rlim_cur=atoi(&limit[6]);
			rlim.rlim_max=atoi(&limit[6]);
			setrlimit(RLIMIT_NOFILE, &rlim);
			found++;
		}

		if(!strncmp(limit, "ram", 3)) {
#ifdef DEBUG
		fprintf(stderr, "Running ram limit\n");
#endif
			memset(&rlim, 0, sizeof(rlim));
			lim=atoi(&limit[4]);
			if(!lim) break;
			lim*=1024*1024;
			rlim.rlim_cur=lim;
			rlim.rlim_max=lim;
			setrlimit(RLIMIT_DATA, &rlim);			
			found++;
		}

		if(!strncmp(limit, "nice", 4)) {
#ifdef DEBUG
		fprintf(stderr, "Running nice limit\n");
#endif
			lim=atoi(&limit[5]);
			nice(lim);
			found++;
		}

		if(!found) {
			fprintf(stderr, "Error in %s: (line %d) mallformed line, contact system admin.\n", LM_CFG, line_num);
			return -1;
		}
		}

		lim=0;
		memset(limit, 0, sizeof(limit));
	}
return 0;
}

int
setlimit(username, guid, type)
	char	*username;
	int	guid;
	int	type;
{
  struct group	*grp;	/* Structures for limits and group id's. */
  struct group  *getgrgid ();
  int v;
  char	dummy[BUFSIZ];


 strcpy(globaluser, username);
 memset(dummy, 0, sizeof(dummy));
 memset(line, 0, sizeof(line));
 found_lim=line_num=0;

#ifndef LM_CFG
#	define LM_CFG "/etc/limits"
#endif

 if((limit_db = fopen(LM_CFG, "r"))) {
  while(fgets(line, sizeof(line), limit_db)) {
   /* Begin IF */
  line_num++;

start:
   found_lim=0;

   if(line[0] == '\n' || line[0] == '\0' || line[0] == ';')
	continue;

   /* Trim spaces */

   if( line[0] == '\t' || line[0] == ' ' ) {
     strcpy(dummy, line);

     for(v=0;dummy[v] == ' '|| dummy[v] == '\t' ; v++);
	;

     strcpy(line, &dummy[v]);
     v=0;
   }

  if(!strncmp(line, "group", 5)) {
	group++;
	found_lim++;
  }

  if(!strncmp(line, "user", 4)) {
	user++;
	found_lim++;
  }

  if(user || group) {
	if(group) {
	   groupname=strtok(line, " ");
	   groupname=strtok(NULL, " ");
	   strcpy(grp2, groupname);

		grp=getgrgid(guid);
	
	  if(!strcmp(grp->gr_name, groupname)) {

		if(type == 1) {
			if(setlim(1) == -1)
				return -1;
				return 0;
		} else
			if(setlim(0) == -1)
				return -1;

		group=0;
	  } else {
		group=0;
		for(;fgets(line, sizeof(line), limit_db);) {
			line_num++;

			if(line[0] == '}' || line[1] == '}') {
				fgets(line, sizeof(line), limit_db);
				line_num++;
				goto start;
			}
		}
	  }
	}

	if(user) {
	  if (!strncmp(&line[5], username, strlen(username))) {

		if(type == 1) {
			if(setlim(1) == -1)
				return -1;
		return 0;
		} else
			if(setlim(0) == -1)
				return -1;
		user=0;
	 } else {
		user=0;
		for(;fgets(line, sizeof(line), limit_db);) {
			if(line[0] == '}' || line[1] == '}') {
				fgets(line, sizeof(line), limit_db);
				line_num++;
				goto start;
			}
		}
	  }
	}
   }

	if(!found_lim) {
		fprintf(stderr, "Error in %s: (line %d) mallformed line, contact system admin.\n", LM_CFG, line_num);
		return -1;
		fclose(limit_db);
	}

   fclose(limit_db);
   /* End IF */
  } /* While, end of */
 } /* Open file, end of */
return 0;
}


/*
 * Set terminal modes, and do noecho'ing getpass and such without! 
 * ncurses. functions; _getpass(); and seterminal();
 */
void seterminal(int mode)
{
	/* Code from libc, and a good friend. (roler@efnet) ;P */
	static struct termios foo, boo;

	switch(mode) {
		case 0: /* Init the terminal */
			tcgetattr(fileno(stdin), &foo);
			memcpy(&boo, &foo, sizeof(struct termios));
			foo.c_lflag &= ~ICANON;
			tcsetattr(fileno(stdin), TCSANOW, &foo);
			break;
		default: /* Un-init the terminal */
			tcsetattr(fileno(stdin), TCSANOW, &boo);
	}
}


/*
 * Alternative to libc function getpass(char *prompt); _getpass(prompt) does the same
 * prints out a prompt gets the return, but this will read the entry from lb.conf and
 * print out 'PassChar' as the alternative character instead of just "nothing" i.e. no
 * echo's. -- This will also be included in the future function, Please mind this does
 * all the tty handling "raw" 
 */

char *
_getpass(prompt)
  char *prompt;
{
  struct termios ttyb, ttysav;
  char *cp;
  char passwd_char[BUFSIZ];
  int c, count, v;
  FILE *tty;
  static char pbuf[128];

  /* a good alternative to your getpass() function in libc. */

  /* Quickie init. */
  fprintf(stdout, "%s", prompt);
  memset(passwd_char, 0, sizeof(passwd_char));
  strcpy(passwd_char, getentry("PasswdChar"));

  if(!lb_stat.lb_conf)
	strcpy(passwd_char, "");

  count = 0;

  if ((tty = fdopen(open(TTY, O_RDWR), "r")) == NULL)
	tty=stdin;
  else
	setbuf(tty, (char *)NULL);

  ioctl(fileno(tty), TCGETS, &ttyb);
  ioctl(fileno(tty), TCGETS, &ttysav);
  ttyb.c_lflag &= ~(ECHO|ISIG);
  ioctl(fileno(tty), TCSETS, &ttyb);

  cp=pbuf;
  seterminal(0);

  for (;;) {
	c=getchar();

		/* Break on return */
	if (c == '\r' || c == '\n' || c == EOF)
		break;

	if((cp<&pbuf[120])) {

	   if ((c != '') & (c != ''))
	   {
		if(count<atoi(getentry("PasswdLength")))
		  {
			if(passwd_char[0] != '\0')
			  {
				fprintf(stdout, "%s", passwd_char);
				fflush(stdout);
			  }

			count++;
			*cp++ = c;
		  }
	   } else if (count>0)
	     {
			count--;cp--;
			if(passwd_char[0] != '\0') {
			for(v=0;strlen(passwd_char) > v;v++)
				fputs("\b \b\0", stdout);
			}
	     }
	}
	else 
	break;
  }

  *cp = '\0';
  fprintf(stdout, "\r\n");
  fflush(stdout);

  ioctl(fileno(tty), TCSETS, &ttysav);

  if (tty != stdin)
	fclose(tty);

  return(pbuf);
  seterminal(1);

}

/*
 * init(),  initialization function. 
 *
 * This pretty much is the backbone of lightbar.  all further functions
 * are executed off of this one, at the end of this function shell(); is
 * executed, this will also take careof lightbar's arguments;
 *	-p	Preserve the environment for the next login.
 * 	-u	Specify a user@host identifcation.  This unlike -h option
 *		is not root only because it's only used for logging parts
 *		and @(MACROS) this is basiclly for other programs information
 *		where the program is only executed on a user coming in on
 *		in.telnetd, it couldn't do any harm if a user executed this
 *		option at a command line.
 *
 *	-h	Stores the users hostname into the utmp logs for network
 *		logins, this is so you can identify where a user is coming
 *		from in the lastlogs and utmp.  This is root only, this is
 *		so users cannot forge fake utmp logs or last logs. 
 *
 *	-f	ignore all of the "high tech crap" like issue.net prompts
 *		x,y positioning etc, and just get the password check it
 *		with the name then either login, or exit if incorrect.
 *
 *	-r	Unimplimented @(#BSD 4.4) old rlogind
 *
 * LightBar will process 5 possible (not all together mind you) options,
 * -u [ user@host ], -h [ hostname ],  [ username ], -- [ username ]
 * -p [ username ].
 *
 * Examples;
 * login -- blind		Start a new session for the user 'blind'
 *				and create a new environment.  This is
 *				what 'agetty' will execute to create a new
 *				environment. 
 *
 * login -p blind		Start a new session and preserve environ.
 * login -u foo@foobar.com	Start a new session, use foo@foobar.com as
 *				the network identification for logs and such.
 * login -h foobar.com		Start a new session, use foobar.com for the
 *				utmp logs (root only).
 *
 * login -p -u foo@foobar.com -h foobar.com	This is what in.telnetd daemon
 *						will usually execute on a
 *				network login. Specifies to preserve the
 *				environment, and specifies where the user
 *				is coming from.
 */

int	ansi_emu=0;
int	reload_v, cnt, failed, preauthed, only_once=0;
#ifndef SET_SHAD
	struct	spwd	*spwd;
#endif
char	*pp;

int
init(argc, argv, envp)
	int	argc;
	char	**argv;
	char	**envp;
{
	extern	int optind;
	char	*cp, *salt, *sp, ttyn[BUFSIZ];
	char	error_buf[BUFSIZ];
	char	name_buf[BUFSIZ], tmp[BUFSIZ];
	char	pass[32], tty[sizeof utent.ut_line + 8 ];
	char	term[32], name[BUFSIZ];
	char	buf[128], pass_prompt[BUFSIZ];
	char	passwd[BUFSIZ], ident[BUFSIZ];
	char	buf2[BUFSIZ], ruser[BUFSIZ];
	char	mshell[BUFSIZ], loft[BUFSIZ], loft2[BUFSIZ];
	char	*pnt, *pnt0, time_exp[BUFSIZ];
	int	ioctlval, flag,z,i,v;
	int	fail_init=0;
	FILE	*tmpfile;
	struct	passwd	*pwd;
	register	char	*p;
	register	char	*p2;
#ifndef SET_SHAD
	struct	spwd	*getspnam ();
#endif
	struct utsname uts;
	time_t	tt=time(NULL); /** Time login began **/
	ioctlval=0;

	uname(&uts); // Get are systems information

	// Yay Yay, lotza defines still, but that's most of all
	// you have for the init.c very little externs or anything
	// defined via .h files :-) .. it's not as much as you think.
	// Let the fun begin.. ....

	/*
	 * Setup signal handlers for seg faults control+C's control+Z's
	 * and alarms (timeouts)
	 */
	(void)signal (SIGINT, SIG_IGN);
	(void)signal (SIGQUIT, SIG_IGN);
	(void)signal (SIGTERM, SIG_IGN);
	(void)signal (SIGSEGV, achk);
	(void)signal (SIGALRM, timedout);
	(void)setpriority(PRIO_PROCESS, 0, 0);	
#ifdef HAVE_QUOTA
	quota(Q_SETUID, 0, 0, 0);
#endif
#ifdef SYSLOGD
#ifdef LOG_DAEMON
	openlog("login", LOG_PID, LOG_DAEMON);
#else
	openlog("login", LOG_PID);
#endif
#endif
	pflg = hflg = uflg = 0;

	checkutmp(argc == 1 || argv[1][0] != '-');
	STRFCPY(tty, utent.ut_line);

#if defined(__linux__) && !defined(TIMEZNE)
	setenv("TZ", "MET-1DST", 0);
#endif

	// Check the arguements figure out what we need to complete
	// on this session.
	if(strcmp(argv[1], "--") == 0)
		if(! argv[2])
			;
	else {
		addenv("TERM=linux");
		strcpy(name, argv[2]);
		cflg++;
		preauthed++;
		goto start;
	}

	while ((flag = getopt(argc, argv, "pvh:u:f:")) != -1) {
		switch(flag) {
		case 'p':
			pflg++;
			break;

		case 'v':
			version();
			break;

		case 'h':
			if(getuid()) /** Allow Root only **/
			 (void) perr("login: -h is for super-user only.", 0);

			hflg++;
			STRFCPY(host, optarg);
#ifndef sun
			STRFCPY(utent.ut_host, optarg);
#endif
			break;

		case 'u':
			uflg++;
			strcpy(ident, optarg);
			for(z=0;ident[z] != '@';z++)
			      ;
			strncpy(ruser, ident, z);
			z=0;
			break;

		case 'f':
			strcpy(name, optarg);
			preauthed++;
			break;

		default:
			help(argv);
		}
	}
	argc -= optind;
	argv += optind;

	if(*argv) {
		strcpy(name, *argv);
		preauthed++;
	}

	if(connect_dmn())
	     use_dmn=1;

start:

#ifdef TERM_PREP
	/** Put the terminal into cooked mode. **/
#ifndef __linux__
	/** Block modes for non-linux systems. **/
	ioctlval=0;
#ifndef sun
	(void)ioctl(0, TIOCLSET, *ioctlval);
#endif
	(void)ioctl(0, TIOCNXCL, 0);
	(void)fcntl(0, F_SETFL, ioctlval);
#ifndef sun
	(void)ioctl(0, TIOCGETP, &sgttyb);
	sgttyb.sg_erase = CERASE;
	sgttyb.sg_kill = CKILL;
	(void)ioctl(0, TIOCSLTC, &ltc);
	(void)ioctl(0, TIOCSETC, &tc);
	(void)ioctl(0, TIOCSETP, &sgttyb);
	ioctlval=0;
	(void)ioctl(0, FIOSNBIO, &ioctlval);
#endif /**sun**/
#endif

	GTTY (0, &termio);
#ifndef BSD
	termio.c_lflag |= ISIG|ICANON|ECHO|ECHOE;
	termio.c_iflag |= ICRNL;
#if defined (ECHOKE) && defined(ECHOCTL)
	termio.c_lflag |= ECHOKE|ECHOCTL;
#endif
#if defined (ECHOPRT) && defined (NOFLSH) && defined(TOSTOP)
	termio.c_lflag &= ~(ECHOPRT|NOFLSH|TOSTOP);
#endif
#ifdef	ONLCR
	termio.c_oflag |= ONLCR;
#endif

#ifdef SUN4
	termio.c_cc[VEOF] = '\04';
	termio.c_cflag &= ~CSIZE;
	termio.c_cflag |= (PARENB|CS7);
	termio.c_lflag |= (ISIG|ICANON|ECHO|IEXTEN);
	termio.c_iflag |= (BRKINT|IGNPAG|ISTRIP|IMAXBEL|ICRNL|IXON);
	termio.c_iflag &= ~IXANY;
	termio.c_oflag |= (XTABS|OPOST|ONLCR);
#endif
	/* termio.c_cc[VERASE] = '\b'; backspace is screwy */
	termio.c_cc[VKILL] = '\025';
#endif
	STTY (0, &termio);
	setpgrp();

	/*
	 ** Hang up terminal, reset attributes, return fresh :)
	 ** Provided by Michael Glad (glad@daimi.dk) Modified slightly
	 */

	{
	  struct termios tt, ttt;

		tcgetattr(0, &tt);
		ttt = tt;
		ttt.c_cflag &= ~HUPCL;

		if(tty[1] == 't' || tty[1] != '/')
			sprintf(ttyn, "/dev/%s", tty);

		if((chown(ttyn, 0, 0) == 0) && (chmod(ttyn, 0622) == 0))
			tcsetattr(0,TCSAFLUSH,&ttt);

#if defined (HANGUP_TERM)
			signal(SIGHUP, SIG_IGN);
			vhangup();
			signal(SIGHUP, SIG_DFL);
#endif
		if(preauthed)
			setsid();

/*
 ** Provided by Linus Torvalds; This although causes seg faults for
 ** the program when it tries to reopen the tty on a XTERM type program
 */

#if defined(HANGUP_TERM)

		{
			int in;
			int fd = open (ttyn, O_RDWR);
			for (in = 0; in < fd ; in++ )
			  close(in);
			for (in = 0; in < 3 ; in++ )
			  dup2(fd, in);
			if (fd >= 3)
			  close(fd);
		}

		tcsetattr(0,TCSAFLUSH, &tt);
	}
#endif
#endif
	/** Start doing the system passwords **/

	if(!strcmp(getentry("SystemPasswd"), "") || !lb_stat.lb_conf || cflg)
		goto issue_V;

	sp = _getpass(getentry("SystemPrompt"));
	p2 = crypt(sp, getentry("SystemPasswd"));

	if(strcmp(p2, getentry("SystemPasswd"))) {
		sleep(2);
		if(use_dmn)
			hangup_dmn();
		exit(0);
	}

issue_V:
	if(lb_stat.issue == -1 && !preauthed)
		print_file(tty, ident, getentry("Issue"));
	else if(!preauthed) {
		fprintf(stdout, "\n");
#if defined (__linux__)
		fprintf(stdout, "Linux %s (%s) (%s)\n\n\n", uts.release,
					uts.nodename, tty);
#elif defined (sun)
		fprintf(stdout, "SunOS (%s)\n\n\n", uts.nodename);
#else
	/** shrug.. hell i dunno? .. BSD? **/
		fprintf(stdout, "   FreeBSD (%s) (%s)\n\n", uts.nodename, tty);
#endif
	}
	{
		if(!only_once) {
			/* Start alarm */
			if(lb_stat.lb_conf)
				_timeout = atoi(getentry("Timeout"));
	
			alarm ((unsigned int)_timeout);
			only_once++;
		}
	}
reload:
	setpriority(PRIO_PROCESS, 0, 0);
	if(preauthed)
		goto start_cmp;


	/* This is where the login: begins. */
	memset(name, 0, sizeof(name));
	memset(name_buf, 0, sizeof(name_buf));
	(void)obtain_login();

	/* Get 32 characters and store it into name_buf */	
	strcpy(name_buf, get_name());

	if(strlen(name_buf) > 32) {
		fprintf(stderr, "login name much too long.\n");
		goto reload;
		if(use_dmn)
			hangup_dmn();
		exit(0);
	}

	/*
	 * Clean up name_buf from things like spaces and garabage
	 * along with null characters or anything that might cause
	 * problems and return it into the char, name.
	 */

	for(cp = name_buf;*cp == ' ' || *cp == '\t';cp++)
		;
	for(i = 0;i < BUFSIZ - 1 && isgraph(*cp);name[i++] = *cp++)
		;
	if (*cp)
		cp++;

	name[i]=0;
start_cmp:
	if(name[0] == '\0') {
		if(cnt != 25)
				cnt++;
		else {
			fprintf(stderr, "too many bare linefeeds.\n");
			if(use_dmn)
				hangup_dmn();
			exit(0);
	}
	goto reload;
	}{
		/* This is alias checking. */
		pnt = strtok(name, "@");

		/*
		 * pnt = name,  &name[strlen(pnt) + 1] = alias
		 * go through LoginAlias once you find a matching
		 * alias set the shell, set the flag strcpy the name
		 * of the user back into name. 
		 */

		if(!lb_stat.lb_conf)
			goto en;

		strcpy(loft, getentry("LoginAlias"));
		strcpy(loft2, loft);  // Make a copy for future use.

		if(loft[0] == '\0')
			goto en;

		pnt0=strtok(loft, ":");
			goto recept;

		for(;;) {
			pnt0=strtok(NULL, ":");
recept:
			if(pnt0[0] == '\0')
				break;

			if(!strcmp(&name[strlen(pnt) + 1], "shell"))
				goto en;

			if(!strcmp(pnt0, &name[strlen(pnt) + 1])) {
				mflg++;
				pnt0=strtok(NULL, ",");

				strcpy(mshell, pnt0);
				break;
			}
			pnt0=strtok(NULL, ",");
			if(!strcmp(&loft2[strlen(loft2) - strlen(pnt0)], pnt0))
				goto en;
		}
en:			
	}
	strcpy(blunt, name);

	/* 
	 * Guest logins,  This is so people can login as guest without
	 * need for the entry in /etc/passwd, This will set the uid's
	 * to ones specified in GuestUid/Gid, only if AllowGuest is
	 * set to "yes". 
	 */

	if(!strcmp(getentry("AllowGuest"), "yes")) {
	  if(!strcmp(name, "newuser") || !strcmp(name, "guest")) {
#ifdef SYSLOGD
		if(!strcmp(host, "")) {
			memset(error_buf, 0, sizeof(error_buf));
			sprintf(error_buf, "guest login from console on %s\n", tty);
			if(use_dmn)	
				syslog_dmn(error_buf);
			syslog(__LOG_ERR, error_buf);

		} else {
			memset(error_buf, 0, sizeof(error_buf));
			sprintf(error_buf, "guest login from %s@%s on %s\n", ruser, host, tty);
			if(use_dmn)
				syslog_dmn(error_buf);
			syslog(__LOG_ERR, error_buf);
		}
#endif
		if(!strcmp(getentry("GuestUid"), "-1")) {
			setuid(-1);
			goto gid;
		}

		if(setuid (atoi(getentry("GuestUid")))) {
#ifdef SYSLOGD
			memset(error_buf, 0, sizeof(error_buf));
			sprintf(error_buf, "setuid(%d) failed: Bad user id!\n", atoi(getentry("GuestUid")));
			if(use_dmn)
			    syslog_dmn(error_buf);
			syslog(__LOG_ERR, error_buf);
#endif
			perr("Bad user id! Contact system administrator.\n",  1);
		}
gid:
		if(!strcmp(getentry("GuestGid"), "-1")) {
			setgid(-1);
			goto after;
		}

		if(setgid(atoi(getentry("GuestGid")))) {
#ifdef SYSLOGD
			memset(error_buf, 0, sizeof(error_buf));
			sprintf(error_buf, "setgid(%d) failed: Bad group id!\n", atoi(getentry("GuestGid")));
			if(use_dmn)
			   syslog_dmn(error_buf);
			syslog(__LOG_ERR, error_buf);
#endif
			perr("Bad group id!  Contact system administrator.\n",1);
		}

after:
		if(chdir("/tmp") == -1)
			;

		/* Don't chown terminal, Don't add utmp etc. */
		alarm((unsigned int)0);
		signal(SIGALRM, SIG_DFL); // Kill the alarm.
		shell(getentry("GuestProgram"), (char *) 0);
		exit(0); /*NOTREACHED*/
	  }
	} /* Else if no guest login defined. */

	/* Check securetty if root login */
	if(strcmp(name, "root") == 0) {
	  if((tmpfile = fopen("/etc/securetty", "r"))) {
		while(fgets(buf2, BUFSIZ, tmpfile)) {
			buf2[strlen(buf2) - 1] = '\0';

			if(strcmp(buf2, tty) == 0)
				goto passwd;
		}
		fclose(tmpfile);
#ifdef SYSLOGD
		memset(error_buf, 0, sizeof(error_buf));
		sprintf(error_buf, "attempted login as root from '%s' on '%s'\n", ident, tty);
		if(use_dmn)
			syslog_dmn(error_buf);
		syslog(__LOG_ERR, error_buf);
#endif
		puts("root access is denied on this terminal.");

		if(preauthed)
			exit(0);
	  }
	}
passwd:
	/*
	 * Do necessary proceedures before doing password
	 * authentication.
	 */

	if(hflg) /** Only on network connections please.. **/
	  check_promisc(); // Check for a sniffer before getting the passwd

	/* Don't prep on -f or -r */
	// if(!preauthed)
	spasswd(name);



	/* BEGIN SHADOW/CRYPT/NORMAL */

		memset(pass_prompt, 0, sizeof(pass_prompt));
		memset(passwd, 0, sizeof(passwd));

		strcpy(pass_prompt, getentry("PasswdPrompt"));

		if(!lb_stat.lb_conf || !strcmp(pass_prompt, "noval"))
			strcpy(pass_prompt, "Password: ");

		for(v=0;v<strlen(pass_prompt);v++) {
		   if(pass_prompt[v] == '%' && pass_prompt[v + 1] == 'u') {

			if(passwd[0] == '\0')
				strcpy(passwd, name);
			else
				strcat(passwd, name);
	
			v++;
			continue;
		   }

		  passwd[strlen(passwd)] = pass_prompt[v]; 
		}

	memset(pass_prompt, 0, sizeof(pass_prompt));

	if (( pwd = getpwnam(name))) {
		salt = pwd->pw_passwd;
#ifndef SET_SHAD
		if(lb_stat.shadow == 1) {
		  spwd = getspnam(name);
		  salt = spwd->sp_pwdp;
		  pwent = *pwd;
		}
#endif
	} else {
		salt = "xx";

#ifndef SET_SHAD
		if(lb_stat.shadow == 1) {
		  pwent.pw_name = name;
		  pwent.pw_passwd = "!";
		  pwent.pw_shell = "/bin/sh";

		  preauth_flag = 0;
		  failed = 0;
		}
#endif
		pp = _getpass(passwd); /* Work around the crypt bug */
		goto failed_login;
	}

	if(!strcmp(getentry("PermitEmptyPasswords"), "yes")) {
		if(strcmp(salt, "xx")) {
		if(lb_stat.normal == 1) {
			strcpy(tmp, pwd->pw_passwd);
		}

#ifndef SET_SHAD
		if (lb_stat.shadow == 1) {
			/* Shadow type logins */
			strcpy(tmp, spwd->sp_pwdp);
		}
#endif
			if(tmp[0] == '\0')
				goto validate;
		}
	}

	/* Don't use libc's getpass function. */
	setpriority(PRIO_PROCESS, 0, -4);

	pp = _getpass(passwd);
	p = crypt(pp, salt);

#if defined(KERBEROS)
	if(pwd && !krb_get_lrealm(realm, 1)) {
		(void)setreuid(geteuid(),pwd->pw_uid);
		kerror = krb_get_pw_in_tkt(pwd->pw_name, "", realm,
			"krbtgt", realm, DEFAULT_TKT_LIFE, pp);
		(void)setuid(0);
		if (kerror == INTK_OK) {
			memset(pp, 0, strlen(pp));
			notickets = 0; /* user got ticket */
			break;
		}
	}
#endif

#ifndef SET_SHAD
	if(lb_stat.shadow == 1) {
	if(pwd)
		if((spwd = getspnam(name)))
			pwent.pw_passwd = spwd->sp_pwdp;
	}
#endif
	setpriority(PRIO_PROCESS, 0, 0);
	memset(passwd, 0, sizeof(passwd));

#ifndef SET_SHAD
	if(lb_stat.shadow == 1) {
	if(pwd && !strcmp(p, pwent.pw_passwd))
		failed = 1;
	}
#endif
	if(lb_stat.normal == 1) {
	 if(pwd && !strcmp(p, pwd->pw_passwd))
		failed = 1;
	}

	if(!strcmp(getentry("PermitEmptyPasswords"), "no")) {
#ifndef SET_SHAD
		if(lb_stat.shadow == 1)
		strcpy(tmp, pwent.pw_passwd);
#endif
		if(lb_stat.normal == 1)
		strcpy(tmp, pwd->pw_passwd);

		if(tmp[0] == '\0')
		failed =0;
	}

	if(failed)
		goto validate;

	/*
	 * Else if not flagged fall into a failed login. (safety) if
	 * in case 'if' jumps
	 */

failed_login:

	/*
	 * All failed logins end up here
	 * Report the failed login to syslog
	 */
#ifdef SYSLOGD

	if((pwd = getpwnam(name)) && lb_stat.lb_conf)
		if(setlimit(name, pwd->pw_gid, 1) == -1)
				;

	/*
	 * Program will seg. fault if, if(!pwd->pw_uid) is preformed
	 * on a bad username so will skip it and goto regular auth.
	 */

	if(!(pwd = getpwnam(name)))
		goto user_report;

	if(!pwd->pw_uid) {
		if(strcmp(host, "") != 0) {
			memset(error_buf, 0, sizeof(error_buf));
			sprintf(error_buf, "root login failure on %s from %s@%s\n", tty, ruser, host);
			if(use_dmn)
			    syslog_dmn(error_buf);
			syslog(__LOG_ERR, error_buf);
		} else {
			memset(error_buf, 0, sizeof(error_buf));
			sprintf(error_buf, "root login failure on %s\n", tty);
			if(use_dmn)
			    syslog_dmn(error_buf);
			syslog(__LOG_ERR, error_buf);
		}
	} else {
user_report:
		strncpy(buf, name, UT_NAMESIZE);

		if(strcmp(host, "") != 0) {
			memset(error_buf, 0, sizeof(error_buf));
			sprintf(error_buf, "login failure for %s on %s from %s@%s\n", buf, tty, ruser, host);
			if(use_dmn)
			   syslog_dmn(error_buf);
			syslog(__LOG_ERR, error_buf);
		} else {
			memset(error_buf, 0, sizeof(error_buf));
			sprintf(error_buf, "login failure for %s on %s\n", buf, tty);
			if(use_dmn)
			   syslog_dmn(error_buf);
			syslog(__LOG_ERR, error_buf);
		}
		memset(buf, 0, sizeof(buf));
	}
#endif
#ifdef BTMP
	// Setup btmp
	btmp.bt_pid = getpid();
	strcpy(btmp.bt_line, tty);
	strcpy(btmp.bt_user, name);

	strcpy(time_exp, ctime(&tt));
	time_exp[strlen(time_exp) -1] = 0;

	strcpy(btmp.bt_time, time_exp);

	if(hflg) {
		strcpy(btmp.bt_rhost, host);
		strcpy(btmp.bt_ruser, ruser);
	}

	putbtline(&btmp); /* &btmp */
#endif
	if(lb_stat.lb_conf)
		sleep(atoi(getentry("FailDelay")) + reload_v );
	else
		sleep(1+reload_v);

	if(!preauthed)
		failed_login(name);
	else {
		failed_login(name);
		if(use_dmn)
			hangup_dmn();
		exit(0); // Ughh shoot me
	}

	bzero(name, sizeof(name));
	bzero(pass, sizeof(pass));

	reload_v++;
	if(reload_v == 10) {
		if(use_dmn)
			hangup_dmn();
		exit(0);
	}

	if(!strcmp(getentry("ReloadIssue"), "yes"))
		goto issue_V;
	else
		goto reload;

	exit(0); /*NOTREACHED*/

validate:

#if !defined(__linux__)
#ifdef KERBEROS
	if(notickets)
		(void)fprintf(stderr, "Warning: no Kerberos tickets issued\n");
#endif
	checkage(&pwd);
#endif

	/*
	 * All valid logins end up here one way or another.
	 * Kill the timeout alarm from going off and exiting you out ;P
	 */

	alarm((unsigned int)0);

	/*
	 * This quota code is a little ugly and untested. I may or may
	 * not use this.  Fear this code :|
	 */

#ifdef HAVE_QUOTA
	if(quota(Q_SETUID, pwd->pw_uid, 0, 0) < 0 && errno != EINVAL) {
		switch(errno) {
		  case EUSERS:
			fprintf(stderr,
			"Too many users logged on already.\nTry again later.\n");
			break;
		  case EPROCLIM:
			fprintf(stderr, 
			"You have too many process running.\n");
			break;
		  default:
			perror("quota (Q_SETUID)");
		}
		perr("exiting\n", 1);
	}
#endif
	pwent = *pwd;
	endpwent();	/* Close the password files, there no longer needed */

#ifndef SET_SHAD
	if(lb_stat.shadow == 1)
	endspent();
#endif

	/* report the success to syslog for user tracking purposes. */
	out_gid = pwent.pw_gid;
#ifdef SYSLOGD
	if(!pwent.pw_uid) {
		if(strcmp(host, "")) {
			memset(error_buf, 0, sizeof(error_buf));
			sprintf(error_buf, "root login success on %s from %s@%s\n", tty, ruser, host);
			if(use_dmn)
			   syslog_dmn(error_buf);
			syslog(__LOG_ERR, error_buf);
		} else {
			memset(error_buf, 0, sizeof(error_buf));
			sprintf(error_buf, "root login success on %s\n", tty);
			if(use_dmn)
			   syslog_dmn(error_buf);
			syslog(__LOG_ERR, error_buf);
		}
	} else {
		if(strcmp(host, "")) {
			memset(error_buf, 0, sizeof(error_buf));
			sprintf(error_buf, "login success for %s on %s from %s@%s\n", name, tty, ruser, host);
			if(use_dmn)
			   syslog_dmn(error_buf);
			syslog(__LOG_ERR, error_buf);
		} else {
			memset(error_buf, 0, sizeof(error_buf));
			sprintf(error_buf, "login success for %s on %s\n", name,tty);
			if(use_dmn)
			   syslog_dmn(error_buf);
			syslog(__LOG_ERR, error_buf);
		}
	}
#endif

	if(strcmp(getentry("PrintAfterLogin"), "") != 0)
		fprintf(stdout, "%s", getentry("PrintAfterLogin"));

	for(cnt=0;cnt < atoi(getentry("NewLine"));cnt++)
		fprintf(stdout, "\n");

	/* Initalize groups for the user specified */
	initgroups(name, pwent.pw_gid);

	if((tmpfile = fopen(_PATH_NOLOGIN, "r"))) {
		if(!strcmp(name, "root"))
			goto null_end;

		while((z = getc(tmpfile)) != EOF)
			putc(z, stdout);

		fflush(stdout);
		fclose(tmpfile);
#ifdef SYSLOGD
		memset(error_buf, 0, sizeof(error_buf));
		sprintf(error_buf, "login attempt while nologin is in place by '%s'\n", name);
		if(use_dmn)
		   syslog_dmn(error_buf);
		syslog(__LOG_ERR, error_buf);
#endif
		if(use_dmn)
		   hangup_dmn();
		exit(0);
	}

	sprintf(buf, "%s/.nologin", pwent.pw_dir);

	if((tmpfile = fopen(buf, "r"))) {
		if(!strcmp(name, "root"))
			goto null_end;

		fprintf(stderr, "Sorry, your login has been denied.\n");

		while((z = getc(tmpfile)) != EOF)
			putc(z, stdout);

		fflush(stdout);
		fclose(tmpfile);
#ifdef SYSLOGD
		memset(error_buf, 0, sizeof(error_buf));
		sprintf(error_buf, "login denied for %s on %s because of nologin in place.\n", name, tty);
		if(use_dmn)
		   syslog_dmn(error_buf);
		syslog(__LOG_ERR, error_buf);
#endif
		if(use_dmn)
			hangup_dmn();
		exit(0);
	}
null_end:
	/* Setup utmp entries for the logged in user */
	setutmp(name, tty);

#ifdef ENB_LAST
	log ();
#endif

	if(!strcmp(getentry("GlobalQuietMode"), "no")) {
		if(! hushed(pwent.pw_dir)) {

		/* Print out headers */

#ifdef ENB_LAST
			printf("Last login: %.19s on %s", ctime(&lastlog.ll_time), lastlog.ll_line);

			if(lastlog.ll_host[0])
				printf(" from %.16s", lastlog.ll_host);

			printf("\n");
#endif
			print_file(tty, ident, getentry("Motd")); /* Motd */
#ifdef ENB_LAST
			if(!strcmp(getentry("EnableBtmp"), "yes"))
				failcheck(name, lastlog.ll_time);

				/* Check for failed logins */
#endif
			mailcheck(); /* Check for new/old/current mail. */
		}
	}

	/*
	 * Chown tty for the user, if /dev/ doesn't exist on the
	 * front then tag it!
	 */

	if(utent.ut_line[0] != '/')
		(void) strcat(strcpy(tty, "/dev/"), utent.ut_line);
	else
		(void) strcpy (tty, utent.ut_line);

	if(chown (tty, pwent.pw_uid, 5) || chmod (tty, 0620)) {
#ifdef SYSLOGD
	        syslog(__LOG_ERR, NO_TTY, tty, name);
#endif
	
		(void) sprintf(buf, "Unable to change tty %s. Possibly read-only filesystem", tty);
		perror(buf);
		(void) fprintf(stderr, "Attempting to initalize backup routine. System may fail or freeze.\n");
			fail_init++;
//		exit(0);
	}

	/* Set uid/guids. */
	if(setgid (pwent.pw_gid) == -1) {
#ifdef SYSLOGD
		memset(error_buf, 0, sizeof(error_buf));
		sprintf(error_buf, BADGUID, name, pwent.pw_gid);
		if(use_dmn)
		   syslog_dmn(error_buf);
		syslog(__LOG_ERR, BADGUID, name, pwent.pw_gid);
#endif
		perr("Bad group id!", 0);
	}

#ifdef HAVE_QUOTA
	quota(Q_DOWARN, pwd->pw_uid, (dev_t)-1, 0);
#endif

	if(setuid (pwent.pw_uid)) {
#ifdef SYSLOGD
	     memset(error_buf, 0, sizeof(error_buf));
	     sprintf(error_buf, BADUID, name);
	     if(use_dmn)
		syslog_dmn(error_buf);
	     syslog(__LOG_ERR, BADUID, name);
#endif
	     perr("Bad user id!", 0);
	}
	
	if(chdir (pwent.pw_dir) == -1) {
#ifdef SYSLOGD
	    memset(error_buf, 0, sizeof(error_buf));
	    sprintf(error_buf, NO_HOME, name);
	    if(use_dmn)
		syslog_dmn(error_buf);
	    syslog(__LOG_ERR, NO_HOME, name);
#endif
	    fprintf(stderr, "Warning: Unable to chdir to '%s'.\nInitializing alternative home directory.\n", pwent.pw_dir);

	    if(chdir("/tmp") == -1)
			;
	}

	/* Add environment only on -p and -f */
	if(pflg || preauthed)
		while(*envp)
			addenv(*envp++);

	strncpy(term, getenv("TERM"), strlen(getenv("TERM")));
	if(term[0] == '\0' || strcmp(term, "dumb") == 0 )
		addenv("TERM=vt100");

	(void) strcat (strcpy (buf, "HOME="), pwent.pw_dir);
		addenv(buf);

	if(pwent.pw_shell == (char *) 0 || ! *pwent.pw_shell)
		sprintf(pwent.pw_shell, "/bin/sh");

	(void) strcat (strcpy (buf, "SHELL="), pwent.pw_shell);
		addenv(buf);

	(void) strcat (strcpy (buf, "USER="), name);
		addenv(buf);

	/* Add paths */
	if(pwent.pw_uid)
		sprintf(buf, "PATH=%s:.", _PATH_DEFPATH);
	else if(!pwent.pw_uid)	/* Sometimes -1 is used */
		sprintf(buf, "PATH=%s:.", _PATH_DEFPATH_ROOT);
	addenv(buf);

	(void) strcat (strcpy (buf, "LOGNAME="), name);
		addenv(buf);

	if(tty[sizeof("tty")-1] == 'S') {
		memset(error_buf, 0, sizeof(error_buf));
		sprintf(error_buf, "dailup at '%s' by '%s'.\n", tty, pwent.pw_name);
		if(use_dmn)
		   syslog_dmn(error_buf);
		syslog(__LOG_ERR, "dialup at '%s' by '%s'.\n", tty, pwent.pw_name);
	}

#if !defined(SENDMAIL) && !defined(QMAIL) && !defined(MAILBOX)
	fprintf(stderr, "warning: No Mailbox is defined! Contact your system administrator\n");
#endif
#ifdef SENDMAIL
	sprintf(buf, "MAIL=/var/spool/mail/%s", name);
#endif
#ifdef QMAIL
	sprintf(buf, "MAIL=%s/Mailbox", pwent.pw_dir);
#endif
#ifdef MAILBOX
	sprintf(buf, "MAIL=%s", MAILBOX);
#endif
	addenv(buf);
		
	/* Close group files */
	endgrent();
#ifndef SET_SHAD
	if(lb_stat.shadow == 1)
	endsgent();
#endif
#ifdef SYSLOGD
	closelog ();
#endif

	/* Put signals back to normal */
	signal (SIGINT, SIG_DFL);
	signal (SIGTERM, SIG_DFL);
	signal (SIGQUIT, SIG_DFL);
	signal (SIGALRM, SIG_DFL);
	signal (SIGSEGV, SIG_DFL);

	/*
	 * If no alternative shell is specified in the aliasing then just
	 * use whatever is set in passwd field pw_shell.
	 */

	if(!mflg)
		strcpy(mshell, pwent.pw_shell);


	/*
	 * Tell the remote daemon goodbye and clean up the connection.
	 */

	if(use_dmn)
		hangup_dmn();


	/*
	 * Go ahead and set limits on the user
	 */

	global_gid = pwent.pw_gid;
	if(getuid() && geteuid() && getgid() && getegid() && !fail_init)
		setlimit(name, pwent.pw_gid, 0);

	/* Execute the shell with the current environment */
	shell(mshell, (char *) 0);

	return -1; /*NOTREACHED*/
} /*EOF*/
