/*
 * lightBAR 1.11 beta
 *
 * This is under the GNU/BSD license.  Please read 'copyright' for
 * more information
 *
 * This adds support for logging daemon for lightbar.  Connects
 * through sockets sends/recieves connections.
 *
 */

#include <errno.h>
#include <malloc.h>
#include <netdb.h>
#include <netinet/in.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/socket.h>
#include <sys/types.h>
#include <sys/wait.h>
#include <syslog.h>
#include <time.h>
#include <unistd.h>
#include <utmp.h>
#include "lb_def.h"

#define MAXDATASIZE	120

extern	char	*getentry();
int sockfd;

/*
 * Tag a \n onto the end of the line if none exists. then just go ahead
 * with the code and use send() to send the packet off.
 */

int
send_packet(msg)
	char	*msg;
{
	char	snd_msg[MAXDATASIZE];

	if(!strcmp(getentry("WriteRemote"), ""))
			return -1;

	if(msg[0] == '\0') {
	   if(send(sockfd, "\n", 1, 0) == -1) {
	       syslog(__LOG_ERR, "error sending packets!\n");
#ifdef DEBUG
	       fprintf(stderr, "error sending packet \"%s\":\n", msg);
#endif
	       perror("send");
	       return -1;
	   }
	   return 1;
	}


	/*
	 * Examine the outgoing message... Tag correct characters to the
	 * end then send the packet.
	 */

	memset(snd_msg, 0, sizeof(snd_msg));
	strcpy(snd_msg, msg);
	if(msg[strlen(msg)] != '\n')
		strcat(snd_msg, "\n");


	if(send(sockfd, snd_msg, strlen(snd_msg), 0) == -1) {
	    syslog(__LOG_ERR, "error sending packets!\n");
#ifdef DEBUG
	    fprintf(stderr, "error sending packet \"%s\":\n", snd_msg);
#endif
	    perror("send");
	    return -1;
	}
#ifdef DEBUG
	fprintf(stderr, "sending packet \"%s\"\n", snd_msg);
#endif
	return 1;
}

/*
 * Send syslog daemon initalization characters tag on a syslog
 * type info 'time host in.lbd[program id]: message'
 */

int
syslog_dmn(sys_msg)
	char	*sys_msg;
{
	time_t	tt=time(NULL);
	char	send_sys[MAXDATASIZE];
	char	vtime[BUFSIZ], vdomain[BUFSIZ];

	if(!strcmp(getentry("WriteRemote"), ""))
		return -1;

	strcpy(vtime, ctime(&tt));
	gethostname(vdomain, BUFSIZ);
	send_packet("&error");
	sprintf(send_sys, "%s %s login[%d]: %s", vtime, vdomain, getpid(), sys_msg);
	send_packet(send_sys);
	send_packet("&error");

	return 1;
}

/*
 * Write to a remote utmp.
 */

void
utmp_dmn(ulog)
	struct	utmp	*ulog;
{
	if(!strcmp(getentry("WriteRemote"), ""))
		return;

	fprintf(stderr, "ulog.ut_line \"%s\"\n", ulog->ut_line);
	send_packet("&utmp"); /* begin utmp */
	write(sockfd, &ulog, sizeof ulog);
	send(sockfd, "\n$\n", 3, 0); /* Send blank string */
	send_packet("&utmp"); /* end utmp */

	return;
}

/*
 * Establish/hangup connection return -1 on ERROR or 1 on OK.
 * Create global socket integer/file descriptor.
 */

int
hangup_dmn(void)
{
	if(!strcmp(getentry("WriteRemote"), ""))
		return -1;

	send_packet("bye");

	if((close(sockfd)) == -1) {
	    syslog(__LOG_ERR, "Error hanging up connection.\n");
	    return -1;
	}

	return 1;
}

int
connect_dmn(void)
{
	char	buf[MAXDATASIZE];
	struct	sockaddr_in	connt_addr;
	struct	hostent	*he;
	int numbytes=0;

	if(!strcmp(getentry("WriteRemote"), ""))
		return -1; /* We don't want to use daemon */

	if ((he = gethostbyname(getentry("WriteRemote"))) == NULL) {
	    syslog(__LOG_ERR, "\"%s\" gethostbyname() failed.\n", getentry("WriteRemote"));
	    return -1;
	}

	if ((sockfd = socket(AF_INET, SOCK_STREAM, 0)) == -1) {
	    syslog(__LOG_ERR, "socket() failed\n");
	    return -1;
	}

	connt_addr.sin_family = AF_INET;
	connt_addr.sin_port = htons(299);
	connt_addr.sin_addr = *((struct in_addr *)he->h_addr);
	bzero(&(connt_addr.sin_zero), 8);

#ifdef DEBUG
	fprintf(stderr, "awaiting connection for logging server.. ");
#endif
	if (connect(sockfd, (struct sockaddr *)&connt_addr, \
					sizeof(struct sockaddr)) == -1) {
	    syslog(__LOG_ERR, "could not connect to host %s on port 299.\n", *((struct in_addr *)he->h_addr)); 
	    return -1;
	}
#ifdef DEBUG
	fprintf(stderr, "Connected.\n");
#endif

	if ((numbytes=recv(sockfd, buf, MAXDATASIZE, 0)) == -1) {
	    syslog(__LOG_ERR, "could not recieve from socket.\n");
	    return -1;
	}

	buf[numbytes] = 0;

	if(strncmp(buf, "OK", 2)) {
	    syslog(__LOG_ERR, "connection was denied from remote host: bad password.\n");
	    return -1;
	}

	/* 
	 * Send the password
	 */
#ifdef DEBUG
	fprintf(stderr, "Sending password.. ");
#endif

	if((send_packet(getentry("PasswdRemote"))) == -1)
		return -1;

#ifdef DEBUG
	fprintf(stderr, "Done.\n");
#endif

	memset(buf, 0, sizeof(buf));
	numbytes=0;
	
	if((numbytes=recv(sockfd, buf, MAXDATASIZE, 0)) == -1) {
	    syslog(__LOG_ERR, "could not recieve from socket.\n");
	    return -1;
	}
#ifdef DEBUG
	fprintf(stderr, "Sending initalization strings and logging information.. ");
#endif

	buf[numbytes]=0;

	if(strncmp(buf, "OK", 2)) {
	    syslog(__LOG_ERR, "connection was denied from remote host: bad password.\n");
	    return -1;
	}
#ifdef DEBUG
	fprintf(stderr, "Done.\n");
#endif
	/* Everything is set.. */
	return 1;
}
