/* btmp - included with the lightbar package.
 * programmed by Trevor Linton
 */
#include <sys/stat.h>
#include <sys/types.h>
#include <fcntl.h>
#include <stdio.h>
#include <string.h>
#include <unistd.h>
#include <stdlib.h>
#include <malloc.h>
#include "config.h"
#include "lb_def.h"

void
main(int argc, char **argv) {
FILE *fp;
char buf[BUFSIZ];
char final[BUFSIZ];
char filename[BUFSIZ], hostname[BUFSIZ], tty[BUFSIZ];
char user[BUFSIZ], realhost[BUFSIZ], realval[BUFSIZ];
int flag, size=0;
int uflg=0, tflg=0, hflg=0;
struct	btmp	blog;

strcpy(filename, BTMP);

while ((flag = getopt(argc, argv, "f:n:h:u:t:")) != -1) {
	switch(flag) {
		case 'f':
			strcpy(filename, optarg);
			break;

		case 'h':
			hflg++;
			strcpy(hostname, optarg);
			break;

		case 'u':
			uflg++;
			strcpy(user, optarg);
			break;

		case 't':
			tflg++;
			strcpy(tty, optarg);
			break;

		default:
			fprintf(stderr, "usage: badlog [-tfuh] [options ...]\n");
			exit(0);
			break;
	}
}

if(tflg && (hflg||uflg)) {
	fprintf(stderr, "Cannot combine options.\n");
	exit(0);
}

if((fp = fopen(BTMP, "rb"))) {

fprintf(stderr, "user\tline\tuser@hostname\t\ttime of login            - process\n");
  while(fread((char *)&blog, sizeof(blog), 1, fp) == 1) {

	if(uflg) {
	  if(!strcmp(blog.bt_user, user))
		goto stat;
		continue;
	} 

	if(hflg) {
		if(!strcmp(hostname, "console"))
			if(!strcmp(blog.bt_rhost, ""))
				goto stat;

		sprintf(buf, "%s@%s", blog.bt_ruser, blog.bt_rhost);
		if(!strcmp(buf, hostname))
			goto stat; 

		memset(final, 0, sizeof(final));
		continue;
	}

	if(tflg) {
		if(!strcmp(blog.bt_line, tty))
 			goto stat;		

		memset(final, 0, sizeof(final));
		continue;
	}

stat:
	size=0;
	sprintf(realval, "%s@%s", blog.bt_ruser, blog.bt_rhost);

	if(size > 23)
		strncpy(realhost, realval, 23);
	else
		strcpy(realhost, realval);

	size=strlen(blog.bt_ruser) + strlen(blog.bt_rhost) + 1;

	if(!strcmp(blog.bt_rhost, "console") || !strcmp(blog.bt_rhost, "")) 
		fprintf(stdout, "%s\t%s\tconsole\t\t\t%s - %d\n", blog.bt_user, blog.bt_line, blog.bt_time, blog.bt_pid);
	else
		fprintf(stdout, "%s\t%s\t%s%s%s - %d\n", blog.bt_user, blog.bt_line, realhost,  size > 14 ? "\t":"\t\t", blog.bt_time, blog.bt_pid);


  }

  fflush(stdout);
  fclose(fp);

} else {
 fprintf(stderr, "Error: Could not open file '%s'\n", BTMP);
 exit(0);
}

return; /*NOTREACHED*/
}
