#!/bin/sh
################################################################################
#									       #
#	lightBAR Platform-Independent Software Installation                    #
#	Copyright (c) 1997 by Trevor F. Linton (blind@motherbrain.com)         #
#									       #
#	File name:	install.sh					       #
#									       #
#	Version:	1.12.1230					       #
#									       #
#	Description:	This script installs LightBAR software on a 	       #
#			workstation and creates or updates the login	       #
#			software.					       #
#									       #
#	Usage:		To execute the script, type:			       #
#									       #
#				./install.sh [ -v ]			       #
#									       #
#	Author(s):	Trevor F. Linton (blind@motherbrain.com)	       #
#									       #
#	Notes:		This script is automaticlly called upon the	       #
#			Execution of 'make install'.			       #
#									       #
################################################################################
# BEGIN 604

RELEASE="1.12"
DATE="09/23/97"
RELEASE_STRINGS="util-linux lightbar compatible login program for SunOS and POSIX Linux.
Copyright (C) 1995, 1996, 1997 Trevor F. Linton

This program is free software; you can redistribute it and/or
modfiy it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in hope that it will be useful, but
WITHOUT ANY WARRENTY; without even the implimented warrenty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU General Public License for more details.

blind@xmission.com, Trevor F. Linton, Author and Programmer."


DCINSTALL_DIR="/sbin"
DNINSTALL_DIR="/usr/sbin"
UCINSTALL_DIR="/bin"
UNINSTALL_DIR="/usr/bin"
CFINSTALL_DIR="/etc"

LOGFILE="install.log-$$"
CDIR="$PWD" 

INSTALL_PRG="install -m755"

if [ ! $UID = "0" ]; then
  tput clear
  echo
  echo "This program MUST be ran as root to have full access to the"
  echo "Installation locations.  Please run this script AS ROOT!"
  echo "Press control+C to stop the installation now or in 10 seconds"
  echo "the installation will begin."
  echo
  sleep 10
fi

echo ""
echo "=================================================================="
echo ""
echo "        LightBAR Platform-Independent Software Installation"
echo "                  Release $RELEASE created $DATE"
echo "          Copyright (c) 1997 Created by Trevor F. Linton."
echo ""
echo "=================================================================="
echo ""
echo ""

#
# Check for the god damned -n option unrelavent in SunOS echo command.
#
if test "`/bin/echo 'blah\c'`" = "blah\c"
then
	EFLAG="-n"
	ENDER=""
else
	EFLAG=""
	ENDER="\c"
fi
ECHO="/bin/echo ${EFLAG}"

${ECHO} "Location for daemon console software [/sbin]: ${ENDER}"
read TARGET

	if test -z "${TARGET}"
	then
		TARGET="${DCINSTALL_DIR}"
	fi
	flag=0;
	if test ! -d ${TARGET}
	then
		${ECHO} "${TARGET}: No such directory.  Do you wish to create it? (y/n)[y] ${ENDER}"
		read check
		if test "${check}" = "n" -o "${check}" = "N"
		then
			flag=1
		else
			mkdir -p ${TARGET}
			if test $? -ne 0
			then
				echo "Error: Cannot create directory ${TARGET}"
				exit 2
			fi
		fi
	fi
		

${ECHO} "Location for daemon network software [/usr/sbin]: ${ENDER}"
read TARGET2

	if test -z "${TARGET2}"
	then
		TARGET2=${DNINSTALL_DIR}
	fi

${ECHO} "Location for lightBAR software [/usr/bin]: ${ENDER}"
read TARGET3

	if test -z "${TARGET3}"
	then
		TARGET3=${UCINSTALL_DIR}
	fi


${ECHO} "Location for lightBAR configuration [/etc]: ${ENDER}"
read TARGET4

	if test -z "${TARGET4}"
	then
		TARGET4=${CFINSTALL_DIR}
	fi
${ECHO} "Do you wish to continue with the installation (y/n)[y]: ${ENDER}"
read check
if test "${check}" = "n" -o "${check}" = "N"
then
	exit 2
fi

#
# Begin the installation.
#
echo ""
${ECHO} "Backing up old files...${ENDER}"
	
# Create FILELIST
FILELIST="${TARGET}/agetty ${TARGET2}/in.telnetd ${TARGET3}/login ${TARGET4}/lb.conf ${TARGET4}/limits"

# Create a blank entry in the log file or continue on to the next line.
echo "" >> ${LOGFILE}
echo "Installation began at;" >> ${LOGFILE}
date >> ${LOGFILE}
echo "" >> ${LOGFILE}
echo "Files begin backed up:" >> ${LOGFILE}
echo "======================" >> ${LOGFILE}

for i in ${FILELIST}
do
	echo "${i}" >> ${LOGFILE}
	if test ! -d ${i}
	then
		/bin/rm -f ${i}.old
		if test -f ${i}; then
			${ECHO} " ${i}${ENDER}"
			mv ${i} ${i}.old
		fi
	fi
done
echo ""

# 
# Actually install the files! :)
#

echo "" >> ${LOGFILE}
echo "Files being installed:" >> ${LOGFILE}
echo "======================" >> ${LOGFILE}

echo ""
${ECHO} "Installing program files... ${ENDER}"
if test -f ${CDIR}/agetty
then
	echo "agetty to ${TARGET}" >> ${LOGFILE}
	${ECHO} "agetty${ENDER}"
	${INSTALL_PRG} ${CDIR}/agetty ${TARGET}/agetty
else
	echo "Error; ${CDIR}/agetty could not be found" >> ${LOGFILE}
	echo "Error; '${CDIR}/agetty' could not be found"
	exit 2
fi

if test -f ${CDIR}/telnetd
then
	echo "telnetd to ${TARGET2}" >> ${LOGFILE}
	${ECHO} " telnetd${ENDER}"
	${INSTALL_PRG} ${CDIR}/telnetd ${TARGET2}/in.telnetd
else
	echo "Error; ${CDIR}/telnetd could not be found" >> ${LOGFILE}
	echo "Error; '${CDIR}/telnetd' could not be found"
	exit 2
fi

if test -f ${CDIR}/lightbar
then
	echo "login to ${TARGET3}" >> ${LOGFILE}
	echo " login"
	${INSTALL_PRG} ${CDIR}/lightbar ${TARGET3}/login
else
	echo "Error; ${CDIR}/lightbar could not be found" >> ${LOGFILE}
	echo "Error; '${CDIR}/lightbar' could not be found"
	exit 2
fi

${ECHO} "Installing component files... ${ENDER}"

if test -f ${CDIR}/config/limits
then
	echo "limits (configuration) to ${TARGET4}" >> ${LOGFILE}
	cp ${CDIR}/config/limits ${TARGET4}
	${ECHO} "limits${ENDER}"
else
	echo "Error; ${CDIR}/config/limits could not be found" >> ${LOGFILE}
	echo "Error; '${CDIR}/config/limits' could not be found"
	echo "Please note you may experiance problems!"
	touch ${TARGET4}/limits
fi

if test -f ${CDIR}/config/log.conf
then
	${ECHO} " log.conf${ENDER}"
	cp ${CDIR}/config/log.conf ${TARGET4}
else
	echo "Error; ${CDIR}/config/log.conf could not be found" >> ${LOGFILE}
	echo "Error; remote logging will not work without this installed!"
fi

if test -f ${CDIR}/config/lb.conf
then
	echo "lb.conf (configuration) to ${TARGET4}" >> ${LOGFILE}
	${ECHO} " lb.conf${ENDER}"
	cp ${CDIR}/config/lb.conf ${TARGET4}
else
	echo "Error; ${CDIR}/config/lb.conf could not be found" >> ${LOGFILE}
	echo "Error; '${CDIR}/config/lb.conf' could not be found"
	echo "Please note you may experiance problems!"
fi

if test -f ${CDIR}/badlog
then
	echo "badlog to /bin" >> ${LOGFILE}
	${ECHO} " badlog${ENDER}"
	${INSTALL_PRG} ${CDIR}/badlog /bin
else
	echo "Error; ${CDIR}/badlog could not be found" >> ${LOGFILE}
	echo "Error; '${CDIR}/badlog' could not be found"
	echo "You should examine the system once the installation"
	echo "is finished."
fi

if test -f ${CDIR}/in.lbd
then
	echo "in.lbd to /usr/sbin" >> ${LOGFILE}
	${ECHO} " in.lbd${ENDER}"
	${INSTALL_PRG} ${CDIR}/in.lbd /usr/sbin
else
	echo "Error; ${CDIR}/in.lbd could not be found" >> ${LOGFILE}
	echo "Error; remote logging will not work without this installed!"
fi

if test -f /etc/motd
then
	echo "/etc/motd to /etc/motd.old" >> ${LOGFILE}
	echo " motd"
	cp -a /etc/motd /etc/motd.old
	echo "${RELEASE_STRINGS}" > /etc/motd
else
	echo "${RELEASE_STRINGS}" > /etc/motd
fi


echo "Installation finished at; ">> ${LOGFILE}
date >> ${LOGFILE}

echo ""
echo "All necessary files have been installed."
echo "Your old files have been saved with .old appended to their filename."
echo "Please read 'doc/lightbar.manual' for more information and to go further."
echo "http://www.gnu.net/lightbar"
echo ""
# EOF
