/*
 ** Main defintions for lightbar.
 ** read 'copyright' for more information on distributing this.
 ** (GNU/GPL/BSD License)
 **
 ** 
 */

#define	RELEASE	"1.11"
#define SUBRELEASE	"0"

#include "config.h"
#include <syslog.h>
#if defined ( sun )
#include <utmpx.h>
#define _PATH_BSHELL "/bin/sh"
#define _PATH_NOLOGIN "/etc/nologin"
#define _PATH_DEFPATH "/bin:/usr/bin:/usr/local/bin:."
#define _PATH_DEFPATH_ROOT "/bin:/sbin:/usr/bin:/usr/sbin:/usr/local/bin:/usr/local/sbin:."
#define _PATH_UTMP UTMP_FILE
#define UT_LINESIZE 12
#define UT_HOSTSIZE 16
#define UT_NAMESIZE 8
#else
#include <utmp.h>
#endif

/*
 ** ======================================================================
 **					Global Definitions
 ** ======================================================================
 */

#define	__LOG_ERR	LOG_NOTICE	// Report Syslog to "NOTICE"
#define	MAXENV	64			// Maximum environment table size
#define STRFCPY(A,B)	strncpy((A), (B), sizeof(A)), *((A)+sizeof(A)-1) = '\0';
#define	TTY	"/dev/tty"		// TTY definition.

#ifdef SYSLOGD
extern	int	allow_severity;

#	define SEVERITY	LOG_INFO
#	define SEGFLT "achk! signal 11 recieved! (core dumped)\n"
#	define LOGIN "user '%s' logged in on '%s'\n"
#	define BAD_LOGIN "authentication failed for user '%s' on '%s'\n"
#	define NO_HOME "no home directory exists for user '%s'\n"
#	define NO_TTY "cannot change tty modes on, '%s' for user '%s'\n"
#	define BADUID "setuid() failed for user '%s'\n"
#	define BADGUID "setgid() failed for user '%s' with group '%d'\n"
#endif


/*
 ** ======================================================================
 **				Global Definitions Types Structures
 ** ======================================================================
 */

#ifdef ENB_LAST
struct	lastlog {
	long	ll_time;
	char	ll_line[UT_LINESIZE];
	char	ll_host[UT_HOSTSIZE];
};
#endif

typedef void	SIGNAL_TYPE;

#ifdef BTMP
	struct btmp
	{
	   int bt_pid;
	   char bt_line[15];
	   char bt_user[10];
	   char bt_rhost[30];
	   char bt_ruser[10];
	   char bt_time[26];
	};
#endif

struct status {
	int lb_conf;
	int issue;
	int shadow;
	int normal;
};
