/*  Gringotts - a small utility to safe-keep sensitive data
 *  (c) 2002, Germano Rizzo <mano@pluto.linux.it>
 *
 *  grg_utils.h - header file for grg_utils.c
 *  Author: Germano Rizzo
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef GRG_UTILS_H
#define GRG_UTILS_H

//Duplicates a byte sequence into a new one
inline unsigned char *grg_strdup (unsigned char *src, unsigned long len);

//Concatenates three byte sequences
inline unsigned char *grg_strconcat (unsigned char *src1,
				     unsigned char *src2,
				     unsigned char *src3,
				     unsigned long len1, unsigned long len2,
				     unsigned long len3);

//Converts a long into four bytes
unsigned char *grg_long2char (unsigned long seed);

//Reverts grg_long2char(), converting back into a long
unsigned long grg_char2long (unsigned char *seed);

//Generates a random sequence of bytes.
unsigned char *grg_rnd_seq (unsigned int size);

//Returns a random byte.
unsigned char grg_rnd_chr ();

//Frees a sequence of bytes, overwriting it with random data
void grg_free (unsigned char *pntr, long dim);

//Initialize the random subsystem
void grg_randomize ();

//Finalize the random subsystem
void grg_derandomize ();

//Checks if a NULL-terminated string ands with another one
unsigned int grg_string_endswith (unsigned char *haystack,
				  unsigned char *needle);

#endif
