/*  Gringotts - a small utility to safe-keep sensitive data
 *  (c) 2002, Germano Rizzo <mano@pluto.linux.it>
 *
 *  grg_print.c - various logging functions
 *  Author: Germano Rizzo
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <glib.h>

#include "grg_defs.h"
#include "grg_utils.h"

/**
 * UTF2ISO:
 * @string: the string to convert
 *
 * Converts an UTF-8 encoded string to the locale encoding
 *
 * Returns: the converted string
 */
inline gchar *UTF2ISO(const gchar * string)
{
    return g_locale_from_utf8(string, -1, NULL, NULL, NULL);
}

/**
 * grg_print:
 * @msg: the UTF-8 encoded message to print
 *
 * Prints a message on the stdout.
 * WARNING: don't put in the string characters (like %, ...) that
 *          could be interpreted as format strings
 */
void grg_print(gchar * msg)
{
    gchar *msg_ISO = UTF2ISO(msg);
    g_print("%s", msg_ISO);
    grg_free(msg_ISO, -1);
}

/**
 * grg_print_info:
 * @msg: the UTF-8 encoded message to print
 *
 * Prints a message on the stdout as an information.
 * WARNING: don't put in the string characters (like %, ...) that
 *          could be interpreted as format strings
 */
/*
void
grg_print_info (gchar * msg)
{
	gchar *msg_ISO = UTF2ISO (msg);
	g_message (msg_ISO);
	g_free (msg_ISO);
}
*/

/**
 * grg_print_warn:
 * @msg: the UTF-8 encoded message to print
 *
 * Prints a message on the stdout as a warning.
 * WARNING: don't put in the string characters (like %, ...) that
 *          could be interpreted as format strings
 */
void grg_print_warn(gchar * msg)
{
    gchar *msg_ISO = UTF2ISO(msg);
    g_warning("%s", msg_ISO);
    grg_free(msg_ISO, -1);
}

/**
 * grg_print_err:
 * @msg: the UTF-8 encoded message to print
 *
 * Prints a message on the stdout as an error.
 * WARNING: don't put in the string characters (like %, ...) that
 *          could be interpreted as format strings
 */
void
grg_print_err (gchar * msg)
{
	gchar *msg_ISO = UTF2ISO (msg);
	g_error ("%s", msg_ISO);
	grg_free (msg_ISO, -1);
}
