/*  Gringotts - a small utility to safe-keep sensitive data
 *  (c) 2002, Germano Rizzo <mano@pluto.linux.it>
 *
 *  grg_crypt.h - header file for grg_crypt.c
 *  Author: Germano Rizzo
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef GRG_CRYPT_H
#define GRG_CRYPT_H

//error codes in writing
#define GRG_WRITE_COMP_ERR				-2
#define GRG_WRITE_ENC_INIT_ERR			-4
#define GRG_WRITE_FILE_ERR				-6
#define GRG_WRITE_TOO_BIG_ERR			-8

//error codes in reading
#define GRG_READ_FILE_ERR				-1
#define GRG_READ_MAGIC_ERR				-3
#define GRG_READ_CRC_ERR				-5
#define GRG_READ_PWD_ERR				-7
#define GRG_READ_ENC_INIT_ERR			-9
//NB: this one is managed OUTSIDE grg_crypt
#define GRG_READ_INVALID_CHARSET_ERR	-11
#define GRG_READ_TOO_BIG_ERR			-13

//file format specs; do not touch these
#define	GRG_FLAG				"GRG"

#define GRG_FLAG_LEN			3
#define GRG_FILE_VERSION_LEN	1
#define GRG_CRC_LEN				4
#define GRG_DATA_DIM_LEN		4
#define GRG_ALGO_LEN			1
#define GRG_OVERHEAD			GRG_FLAG_LEN+GRG_FILE_VERSION_LEN+GRG_CRC_LEN*2+GRG_ALGO_LEN+GRG_DATA_DIM_LEN

#define GRG_KEY_SIZE			32	//256 bit

//Stores data in a Gringotts file
int grg_save_crypted (unsigned char *origData, unsigned char *pwd,
		      unsigned char *fpath);

//Loads the encrypted data stored in a Gringotts file.
int grg_load_crypted (unsigned char **origData, unsigned char *pwd,
		      const unsigned char *fpath, unsigned int only_validity);

#endif
