/*
 *
 */

#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <pcap-int.h>
#include "miscinet.h"
#include "pkt.h"
#include "lay_ip.h"
#include "lay_arp.h"
#include "lay_ether.h"

char			*prefixes_str = NULL;
char			*ipsrc = NULL;
char			*ipdst = NULL;
t_boolean		remote = FALSE;
t_boolean		resolve = TRUE;

t_opt			main_opts[] = 
{
  {"-p",	(t_opt_proc)opt_str,		(off_t)&prefixes_str,
   "prefixes","comma separated list of subnet prefixes",0},
  {"-src",	(t_opt_proc)opt_str,		(off_t)&ipsrc,
   "ipsrc",NULL,0},
  {"-dst",	(t_opt_proc)opt_str,		(off_t)&ipdst,
   "ipdst",NULL,0},
  {"-r",	(t_opt_proc)opt_true,		(off_t)&remote,
   NULL,"give remote instead of local",0},
  {"-n",	(t_opt_proc)opt_false,		(off_t)&resolve,
   NULL,"don't resolve ip addresses",0}
};

char			echo_request[] = "\
4500 0054 7c5e 0000 ff01 0fee ffff ffff\
ffff ffff 0800 dd03 0159 0000 34a5 4fbe\
000c aa30 0809 0a0b 0c0d 0e0f 1011 1213\
1415 1617 1819 1a1b 1c1d 1e1f 2021 2223\
2425 2627 2829 2a2b 2c2d 2e2f 3031 3233\
3435 3637\
";

VOID_FUNC		myexit(exitstatus)
int			exitstatus;
{
  fprintf(stderr,"exiting with code %d\n",exitstatus);
  exit(exitstatus);
}

VOID_FUNC		usage(VOID_DECL)
{
  opt_usage(stderr,main_opts,ARRAY_COUNT(main_opts),TRUE);
  myexit(1);
}

VOID_FUNC		check_options(VOID_DECL)
{
  if (!prefixes_str)
    {
      err_print(ERR_NEEDMORE,"need -p");
      myexit(1);
    }
  if (!ipsrc)
    {
      err_print(ERR_NEEDMORE,"need -src");
      myexit(1);
    }
  if (!ipdst)
    {
      err_print(ERR_NEEDMORE,"need -dst");
      myexit(1);
    }
}

VOID_FUNC		doit(VOID_DECL)
{
  t_status		status;
  t_pkt			*echo_request_pkt;
  char			str[STR_BUFSIZ];
  t_vec			*prefixes_names;
  t_vec			*prefixes;
    
  check_options();
  if ((echo_request_pkt = pkt_from_xdata(echo_request,
					 ip_msg,
					 alloc_malloc,
					 free_free,
					 &status)) == NULL)
    {
      err_print(-status,"pkt_from_xdata");
      myexit(1);
    }
  if ((status = pkt_set_field_from_str(echo_request_pkt,
				       "ip.Src",
				       ipsrc)) < 0)
    {
      err_print(-status,"%s",ipsrc);
      myexit(1);
    }
  if ((status = pkt_set_field_from_str(echo_request_pkt,
				       "ip.Dst",
				       ipdst)) < 0)
    {
      err_print(-status,"%s",ipdst);
      myexit(1);
    }
  if ((prefixes_names = VEC_NEW(&status)) == NULL)
    {
      err_print(-status,"VEC_NEW");
      myexit(1);
    }
  if ((status = vec_str_split(prefixes_names,prefixes_str,',')) < 0)
    {
      err_print(-status,"vec_str_split");
      myexit(1);
    }
  if ((prefixes = VEC_NEW(&status)) == NULL)
    {
      err_print(-status,"VEC_NEW");
      myexit(1);
    }
  VEC_FOR(prefixes_names,char *prefix)
    {
      t_subnet		subnet;
      t_subnet		*s;

      if ((status = subnet_from_str(prefix,&subnet)) < 0)
	{
	  err_print(-status,"bad subnet definition %s",prefix);
	  myexit(1);
	}
      if ((s = prefixes->alloc_proc(sizeof (t_subnet),"s",&status)) == NULL)
	{
	  err_print(-status,"allocing s");
	  myexit(1);
	}
      bcopy((char *)(&subnet),(char *)s,sizeof (t_subnet));
      if ((status = vec_add(prefixes,s)) < 0)
	{
	  err_print(-status,"vec_add");
	  myexit(1);
	}
    }
  VEC_ENDFOR;
  str[0] = 0;
  if ((status = local_to_str(echo_request_pkt,
			     prefixes,
			     str,
			     sizeof (str),
			     remote,
			     resolve)) < 0)
    {
      err_print(-status,"local_to_str");
      myexit(1);
    }
  printf("%s\n",str);
  myexit(0);
}

int			main(argc,argv)
int			argc;
char			**argv;
{
  t_opt_context		oc;
  t_boolean		trargsbuf[256];
  t_boolean		troptsbuf[256];
  t_status              status;

  assert(opt_check(main_opts,ARRAY_COUNT(main_opts)) == 0);
  a_debug_init();
  oc.tr_args = trargsbuf;
  oc.nb_tr_args = sizeof (trargsbuf);
  oc.tr_opts = troptsbuf;
  oc.nb_tr_opts = sizeof (troptsbuf);
  oc.argc = &argc;
  oc.argv = argv;
  oc.opts = main_opts;
  oc.nb_opts = ARRAY_COUNT(main_opts);
  oc.base_addr = NULL;
  if ((status = opt_get(&oc)) < 0)
    {
      err_print(-status,"couldn't get options");
      usage();
    }
  if (argc != 1)
    {
      usage();
    }
  doit();
}
