/*
 *
 */

#include <stdio.h>
#include <ctype.h>
#include "a.h"

int		total_entries = 0;

t_vec		*vec;

int			myexit(status)
int			status;
{
#ifdef DEBUG_MALLOC
  debug_malloc_status(0);
  debug_malloc_destroy();
#endif  
  exit(status);
}

VOID_FUNC		finish(VOID_DECL)
{
  printf("%d entries\n",total_entries);
  vec_str_delete(vec);
  myexit(0);
}

RETSIGTYPE	sigint(int ignored)
{
  signal(SIGINT,SIG_DFL);
  finish();
}

int		parse(vec,buf,len)
t_vec		*vec;
char		*buf;
int		len;
{
  static char	text[BUFSIZ + 1];
  static int	pos = 0;
  int		i;

  i = 0;
  while (i < len)
    {
      if (isalnum(buf[i]))
	{
	  if (pos < BUFSIZ)
	    text[pos++] = buf[i];
	  else
	    {
	      return (-1);
	    }
	}
      else
	{
	  t_status	status;

	  text[pos] = 0;
	  pos = 0;
#ifdef NOTDEF
	  fprintf(stderr,"adding `%s'\n",text);
#endif
	  if ((status = vec_str_add(vec,text)) < 0)
	    {
	      fprintf(stderr,"vec_str_add: %s\n",err_msg(-status));
	      return (-1);
	    }
	  total_entries++;
	}
      i++;
    }
}

VOID_FUNC		doit(VOID_DECL)
{
  int			fd;
  t_status		status;

  fd = 0;
  if ((vec = vec_new(VEC_BASE,
		     FALSE,
		     alloc_algorithm_power2,
		     alloc_malloc,
		     free_free,
		     &status)) == NULL)
    {
      fprintf(stderr,"vec_new: %s\n",err_msg(-status));
      myexit(1);
    }
  signal(SIGINT,sigint);
  while (1)
    {
      char	buf[BUFSIZ];
      int	cc;

      if ((cc = read(fd,buf,BUFSIZ)) < 0)
	{
	  myexit(1);
	}
      if (cc == 0)
	break ;
      if (parse(vec,buf,cc) < 0)
	{
	  myexit(1);
	}
    }
  finish();
}

int		main(argc,argv)
int		argc;
char		**argv;
{
  more_verbose = TRUE;
#ifdef DEBUG_MALLOC
  debug_malloc_init();
#endif
  doit();
}
