/*
 *
 */

#include <stdio.h>
#include <ctype.h>
#include <values.h>
#include "a.h"

t_boolean	show_dict = FALSE;
t_boolean	show_repart = FALSE;
int		hbase = HASH_BASE;
int		until = MAXINT;
char		*lookup = NULL;
t_boolean	hdragon = FALSE;
t_boolean	hpublic = FALSE;
t_boolean	hgst = FALSE;

int		total_entries = 0;
int		total_keys = 0;

char		*key_mh = "(null)";
int		nb_mh = 0;

t_dict		*dict;

int			myexit(status)
int			status;
{
#ifdef DEBUG_MALLOC
  debug_malloc_status(0);
  debug_malloc_destroy();
#endif
  alloc_algorithm_status();
  exit(status);
}

int			cb_max_hits(he,unused)
t_hash_elt		*he;
VOID_PTR		unused;
{
  if ((int)(he->value) > nb_mh)
    {
      key_mh = he->key;
      nb_mh = (int)(he->value);
    }
  return (0);
}

VOID_FUNC		finish(VOID_DECL)
{
  printf("%d entries, %d keys\n",total_entries,total_keys);
  if (show_dict)
    {
      dict_show_sorted(dict);
    }
  if (show_repart)
    {
      hash_show_repartition(dict->ht);
    }
  if (lookup)
    {
      t_hash_elt		*he;
      
      if (he = dict_get(dict,lookup))
	printf("`%s': %d\n",he->key,(int)(he->value));	  
      else
	printf("not found\n");
    }
  dict_walk(dict,(t_dict_walk_proc)cb_max_hits,NULL);
  printf("max hits: `%s': %d\n",key_mh,nb_mh);
  dict_delete(dict);
  myexit(0);
}

RETSIGTYPE	sigint(int ignored)
{
  signal(SIGINT,SIG_DFL);
  finish();
}

int		parse(dict,buf,len)
t_dict		*dict;
char		*buf;
int		len;
{
  static char	text[BUFSIZ + 1];
  static int	pos = 0;
  int		i;

  i = 0;
  while (i < len)
    {
      if (isalnum(buf[i]))
	{
	  if (pos < BUFSIZ)
	    text[pos++] = buf[i];
	  else
	    {
	      return (-1);
	    }
	}
      else
	{
	  t_hash_elt	*he;
	  int		count;

	  text[pos] = 0;
	  pos = 0;
	  if ((he = dict_get(dict,text)) != NULL)
	    {
	      count = (int)(he->value) + 1;
	      he->value = (VOID_PTR)count;
	    }
	  else
	    {
	      count = 1;
	      total_keys++;
	      if (total_keys >= until)
		finish();
#ifdef NOTDEF
	      fprintf(stderr,"%s\n",text);
#endif
	      if (dict_add(dict,text,(VOID_PTR)1) < 0)
		{
		  return (-1);
		}
	    }
	  total_entries++;
	}
      i++;
    }
}

t_dict_hcode_proc	get_hcode_proc(VOID_DECL)
{
  if (hdragon)
    return (dict_hcode_dragon);
  if (hpublic)
    return (dict_hcode_public);
  if (hgst)
    return (dict_hcode_gst);
  return (dict_hcode_public);
}

t_alloc_algorithm_proc	get_alloc_algorithm_proc(VOID_DECL)
{
  /*return (alloc_algorithm_exact);*/
  return (alloc_algorithm_power2);
}

VOID_FUNC		doit(VOID_DECL)
{
  int			fd;
  t_status		status;

  fd = 0;
  if ((dict = dict_new(hbase,
		       VEC_BASE,
		       get_hcode_proc(),
		       get_alloc_algorithm_proc(),
		       alloc_malloc,
		       free_free,
		       &status)) == NULL)
    {
      fprintf(stderr,"dict_new: %s\n",err_msg(-status));
      myexit(1);
    }
  signal(SIGINT,sigint);
  while (1)
    {
      char	buf[BUFSIZ];
      int	cc;

      if ((cc = read(fd,buf,BUFSIZ)) < 0)
	{
	  myexit(1);
	}
      if (cc == 0)
	break ;
      if (parse(dict,buf,cc) < 0)
	{
	  myexit(1);
	}
    }
  finish();
}

int		main(argc,argv)
int		argc;
char		**argv;
{
  more_verbose = TRUE;
#ifdef DEBUG_MALLOC
  debug_malloc_init();
#endif
  doit();
}
