/*
 *
 */

#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <pcap-int.h>
#include "miscinet.h"

char			*ip1 = NULL;
char			*ip2 = NULL;
t_boolean		resolve = TRUE;

t_opt			main_opts[] = 
{
  {"-ip1",	(t_opt_proc)opt_str,		(off_t)&ip1,
   "ip1",NULL,0},
  {"-ip2",	(t_opt_proc)opt_str,		(off_t)&ip2,
   "ip2",NULL,0},
  {"-n",	(t_opt_proc)opt_false,		(off_t)&resolve,
   NULL,"don't resolve ip addresses",0}
};

VOID_FUNC		myexit(exitstatus)
int			exitstatus;
{
  fprintf(stderr,"exiting with code %d\n",exitstatus);
  exit(exitstatus);
}

VOID_FUNC		usage(VOID_DECL)
{
  opt_usage(stderr,main_opts,ARRAY_COUNT(main_opts),TRUE);
  myexit(1);
}

VOID_FUNC		check_options(VOID_DECL)
{
  if (!ip1)
    {
      err_print(ERR_NEEDMORE,"need -ip1");
      myexit(1);
    }
  if (!ip2)
    {
      err_print(ERR_NEEDMORE,"need -ip2");
      myexit(1);
    }
}

VOID_FUNC		doit(VOID_DECL)
{
  t_status		status;
  struct in_addr	inaddr1;
  struct in_addr	inaddr2;
    
  check_options();
  if ((status = inaddr_from_str(ip1,&inaddr1,resolve)) < 0)
    {
      err_print(-status,"inaddr_from_str");
      myexit(1);
    }
  if ((status = inaddr_from_str(ip2,&inaddr2,resolve)) < 0)
    {
      err_print(-status,"inaddr_from_str");
      myexit(1);
    }
  printf("%d\n",inaddr_cmp(&inaddr1,&inaddr2));
  myexit(0);
}

int			main(argc,argv)
int			argc;
char			**argv;
{
  t_opt_context		oc;
  t_boolean		trargsbuf[256];
  t_boolean		troptsbuf[256];
  t_status              status;

  assert(opt_check(main_opts,ARRAY_COUNT(main_opts)) == 0);
  a_debug_init();
  oc.tr_args = trargsbuf;
  oc.nb_tr_args = sizeof (trargsbuf);
  oc.tr_opts = troptsbuf;
  oc.nb_tr_opts = sizeof (troptsbuf);
  oc.argc = &argc;
  oc.argv = argv;
  oc.opts = main_opts;
  oc.nb_opts = ARRAY_COUNT(main_opts);
  oc.base_addr = NULL;
  if ((status = opt_get(&oc)) < 0)
    {
      err_print(-status,"couldn't get options");
      usage();
    }
  if (argc != 1)
    {
      usage();
    }
  doit();
}
