/*
 *
 */

#include <values.h>
#include <stdio.h>
#include <fcntl.h>
#include "exp_class_base.h"
#include "exp_class_int.h"
#include "exp_class_str.h"

t_object_manager	*om;
int			after = 0;
int			void_oid = -1;
int			int_oid = -1;
int			str_oid = -1;

VOID_FUNC	myexit(status)
int		status;
{
  debug_malloc_status(0);
  debug_malloc_destroy();
  alloc_algorithm_status();
  exit(status);
}

t_status		func_echo(token,node,result)
t_token			*token;
t_node			*node;
VOID_PTR		*result;
{
  t_status		status;
  t_vec			*vec;
  static t_object	ostatus;

  printf("data=%d\n",token->token_data);
  ostatus.oid = void_oid;
  (*result) = &ostatus;
  if (!node)
    return (0);
  if ((vec = EXP_VEC_NEW(&status)) == NULL)
    return (status);
  if ((status = exp_func_node_to_vec(node,vec)) < 0)
    {
      vec_delete(vec);
      return (status);
    }
  vec_reverse(vec);
  VEC_FOR(vec,t_object *o)
    {
      object_show(om,o);
    }
  VEC_ENDFOR;
  vec_delete(vec);
  return (0);
}

t_status		func_atoi(token,node,result)
t_token			*token;
t_node			*node;
t_object		**result;
{
  t_status		status;
  t_vec			*vec;
  t_object		*arg1;

  if (((*result) = object_new(om,
			      int_oid,
			      &status)) == NULL)
    return (status);
  if (!node)
    return (0);
  if ((vec = EXP_VEC_NEW(&status)) == NULL)
    return (status);
  if ((status = exp_func_node_to_vec(node,vec)) < 0)
    {
      vec_delete(vec);
      return (status);
    }
  vec_reverse(vec);
  if (VEC_COUNT(vec) != 1)
    {
      vec_delete(vec);
      return (-ERR_BADARGS);
    }
  arg1 = (t_object *)(VEC_AT(vec,0));
  if (arg1->oid != str_oid)
    {
      vec_delete(vec);
      return (-ERR_BADARGTYPE);
    }
  (*result)->value = (VOID_PTR)atoi(arg1->value);
  vec_delete(vec);
  return (0);
}

VOID_FUNC		doit(VOID_DECL)
{
  t_compil		*compil;
  t_status		status;
  t_class_manager	*cm;
  int			id;
  t_class		*class_base;

  id = -1;
  if ((compil = compil_new(&status)) == NULL)
    {
      err_print(-status,"compil_new");
      myexit(1);
    }
  if ((om = object_manager_new(compil,&status)) == NULL)
    {
      err_print(-status,"object_manager_new");
      myexit(1);
    }
  if ((cm = class_manager_new(om,&status)) == NULL)
    {
      err_print(-status,"class_manager_new");
      myexit(1);
    }
  if ((status = class_manager_register(cm,&class_base_def)) < 0)
    {
      err_print(-status,"class_manager_register: base");
      myexit(1);
    }
  if ((status = class_manager_register(cm,&class_int_def)) < 0)
    {
      err_print(-status,"class_manager_register: int");
      myexit(1);
    }
  if ((status = class_manager_register(cm,&class_str_def)) < 0)
    {
      err_print(-status,"class_manager_register: str");
      myexit(1);
    }
  if ((status = class_manager(cm)) < 0)
    {
      err_print(-status,"class_manager");
      myexit(1);
    }
  if ((class_base = class_get_from_name(cm,CLASS_BASE_STR,&status)) == NULL)
    {
      err_print(-status,"class_get_from_name");
      myexit(1);
    } 
  if ((status = exp_register_func(class_base->data,
				  "echo",
				  func_echo,
				  (VOID_PTR)42)) < 0)
    {
      err_print(-status,"exp_register_func");
      myexit(1);
    }
  if ((status = exp_register_func(class_base->data,
				  "atoi",
				  (t_eval_func_proc)func_atoi,
				  (VOID_PTR)42)) < 0)
    {
      err_print(-status,"exp_register_func");
      myexit(1);
    }
  if ((void_oid = object_id_get_from_name(om,OBJECT_VOID_STR)) < 0)
    {
      err_print(-void_oid,"object_id_get_from_name");
      myexit(1);
    }
  if ((int_oid = object_id_get_from_name(om,OBJECT_INT_STR)) < 0)
    {
      err_print(-int_oid,"object_id_get_from_name");
      myexit(1);
    }
  if ((str_oid = object_id_get_from_name(om,OBJECT_STR_STR)) < 0)
    {
      err_print(-str_oid,"object_id_get_from_name");
      myexit(1);
    }
  while (1)
    {
      char		buf[BUFSIZ];
      int		cc;
      t_node		*node;
      VOID_PTR		result;
      
      id++;
#ifdef DEBUG
      if (more_verbose)
	{
	  fprintf(stderr,"id=%d\n",id);
	  debug_malloc_status(after);
	}
#endif
      if ((cc = read(0,buf,sizeof (buf))) < 0)
	{
	  err_print(ERR_READ,"read");
	  myexit(1);
	}
      if (cc == 0)
	{
	  class_manager_tilde(cm);
	  class_manager_delete(cm);
	  object_manager_delete(om);
	  compil_delete(compil);
	  myexit(0);
	}
      compil_set_buf(compil,buf,cc);
      if ((status = compile(compil,&node)) < 0)
	{
	  err_print(-status,"compile");
	  class_manager_pool_destroy(cm);
	  compil_reset(compil);
	  compil_pool_destroy(compil);
	  continue ;
	}
      if (compil->paren != 0)
	{
	  err_print(ERR_PAREN,"compile");
	  class_manager_pool_destroy(cm);
	  compil_reset(compil);
	  compil_pool_destroy(compil);
	  continue ;
	}
      if (compil->scan->text[0] != 0)
	{
	  err_print(ERR_SYNTAX,"compile");
	  class_manager_pool_destroy(cm);
	  compil_reset(compil);
	  compil_pool_destroy(compil);
	  continue ;
	}
      if (node == NULL)
	{
	  fprintf(stderr,"(null)\n");
	  class_manager_pool_destroy(cm);
	  compil_reset(compil);
	  compil_pool_destroy(compil);
	  continue ;
	}
      if (more_verbose)
	{
	  printf("show: ");
	  show_node(stdout,node,TRUE);
	  printf("\n");
	}
      printf("node: ");
      show_node(stdout,node,TRUE);
      printf("\n");
      printf("result: ");
      if ((status = eval_node(node,&result)) < 0)
	{
	  err_print(-status,"eval_node");
	  delete_node(node,TRUE);
	  class_manager_pool_empty(cm);
	  object_manager_destroy_objects(om);
	  compil_reset(compil);
	  compil_pool_empty(compil);
	  continue ;
	}
      object_show(om,result);
      delete_node(node,TRUE);
      class_manager_pool_empty(cm);
      object_manager_destroy_objects(om);
      compil_reset(compil);
      compil_pool_empty(compil);
    }
}

int		main(argc,argv)
int		argc;
char		**argv;
{
  char		*str;
  
  if (str = getenv("BC_AFTER"))
    after = atoi(str);
  debug_malloc_init();
  a_debug_init();
  exp_debug_init();
  doit();
  exit(0);
}
