/*
 * This file is a part of the gnetsentry project.
 * Copyright (C) 1998 Martin Gall
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
/*
 *
 */

#include <values.h>
#include <stdio.h>
#include <fcntl.h>
#include "exp_class_base.h"
#include "exp_class_int.h"
#include "exp_class_str.h"
#include "ns_exp.h"
#include "ns_db.h"
#include "cmd_keep.h"

t_status		func_echo(token,node,result)
t_token			*token;
t_node			*node;
t_object		**result;
{
  t_status		status;
  t_vec			*vec;
  static t_object	ostatus;
  t_ns_exp		*ns_exp;

  ns_exp = (t_ns_exp *)(token->token_data);
  ostatus.oid = ns_exp->void_oid;
  (*result) = &ostatus;
  if (!node)
    return (0);
  if ((vec = NS_VEC_NEW(&status)) == NULL)
    return (status);
  if ((status = exp_func_node_to_vec(node,vec)) < 0)
    {
      vec_delete(vec);
      return (status);
    }
  vec_reverse(vec);
  VEC_FOR(vec,t_object *o)
    {
      object_show(ns_exp->om,o);
    }
  VEC_ENDFOR;
  vec_delete(vec);
  return (0);
}

t_status		func_keepdict_count(token,node,result)
t_token			*token;
t_node			*node;
t_object		**result;
{
  t_status		status;
  t_vec			*vec;
  t_ns_exp		*ns_exp;
  t_hash_elt		*he;
  t_object		*arg1;

  ns_exp = (t_ns_exp *)(token->token_data);
  if (((*result) = object_new(ns_exp->om,
			      ns_exp->int_oid,
			      &status)) == NULL)
    return (status);
  if (!node)
    return (-ERR_NEEDMORE);
  if ((vec = NS_VEC_NEW(&status)) == NULL)
    return (status);
  if ((status = exp_func_node_to_vec(node,vec)) < 0)
    {
      vec_delete(vec);
      return (status);
    }
  vec_reverse(vec);
  if (VEC_COUNT(vec) != 1)
    {
      vec_delete(vec);
      return (-ERR_BADARGS);
    }
  arg1 = VEC_AT(vec,0);
  if (arg1->oid != ns_exp->str_oid)
    {
      vec_delete(vec);
      return (-ERR_BADARGTYPE);
    }
  if (he = dict_get(keepdict,arg1->value))
    {
      t_vec		*subvec;

      subvec = (t_vec *)(he->value);
      (*result)->value = (VOID_PTR)(VEC_COUNT(subvec));
    }
  else
    (*result)->value = (VOID_PTR)0;
  vec_delete(vec);
  return (0);
}

t_status		func_format(token,node,result)
t_token			*token;
t_node			*node;
t_object		**result;
{
  t_status		status;
  t_vec			*vec;
  t_ns_exp		*ns_exp;
  t_object		*arg1;
  char			str[BUFSIZ];
  t_pkt			pkt;

  ns_exp = (t_ns_exp *)(token->token_data);
  if (!node)
    return (-ERR_NEEDMORE);
  if ((vec = NS_VEC_NEW(&status)) == NULL)
    return (status);
  if ((status = exp_func_node_to_vec(node,vec)) < 0)
    goto end;
  vec_reverse(vec);
  if (VEC_COUNT(vec) != 1)
    {
      status = -ERR_BADARGS;
      goto end;
    }
  arg1 = VEC_AT(vec,0);
  if (arg1->oid != ns_exp->str_oid)
    {
      status = -ERR_BADARGTYPE;
      goto end;
    }
  str[0] = 0;
  if ((status = pkt_get(ns_exp->rule->current_pkt_info.buf,
			ns_exp->rule->current_pkt_info.len,
			ns_exp->rule->current_pkt_info.caplen,
			ns_exp->rule->current_pkt_info.ts,
			ns_exp->rule->gc->pcap,
			&pkt)) < 0)
    goto end;
  if ((status = pkt_format(&pkt,
			   arg1->value,
			   ns_exp->rule->gc->prefixes,
			   str,
			   sizeof (str))) < 0)
    goto end;
  {
    char		*value;

    if ((value = strdup_alloc(str,
			      NS_ALLOC_PROC,
			      "value",
			      &status)) == NULL)
      goto end;
    if (((*result) = object_new(ns_exp->om,
				ns_exp->str_oid,
				&status)) == NULL)
      {
	NS_FREE_PROC(value,"value");
	goto end;
      }
    (*result)->value = value;
  }
  status = 0;
end:
  vec_delete(vec);
  return (status);
}

t_status		func_db_get(token,node,result)
t_token			*token;
t_node			*node;
t_object		**result;
{
  t_status		status;
  t_vec			*vec;
  t_ns_exp		*ns_exp;
  t_object		*arg1;
  t_object		*arg2;
  t_object		*arg3;
  
  ns_exp = (t_ns_exp *)(token->token_data);
  if (!node)
    return (-ERR_NEEDMORE);
  if ((vec = NS_VEC_NEW(&status)) == NULL)
    return (status);
  if ((status = exp_func_node_to_vec(node,vec)) < 0)
    goto end;
  vec_reverse(vec);
  if (VEC_COUNT(vec) != 3)
    {
      status = -ERR_BADARGS;
      goto end;
    }
  arg1 = VEC_AT(vec,0);
  if (arg1->oid != ns_exp->str_oid)
    {
      status = -ERR_BADARGTYPE;
      goto end;
    }
  arg2 = VEC_AT(vec,1);
  if (arg2->oid != ns_exp->str_oid)
    {
      status = -ERR_BADARGTYPE;
      goto end;
    }
  arg3 = VEC_AT(vec,2);
  if (arg3->oid != ns_exp->int_oid)
    {
      status = -ERR_BADARGTYPE;
      goto end;
    }
  {
    char		*value;

    if ((value = ns_db_get(arg1->value,
			   arg2->value,
			   (int)(arg3->value),
			   &status)) == NULL)
      goto end;
    if ((value = strdup_alloc(value,
			      NS_ALLOC_PROC,
			      "value",
			      &status)) == NULL)
      goto end;
    if (((*result) = object_new(ns_exp->om,
				ns_exp->str_oid,
				&status)) == NULL)
      {
	NS_FREE_PROC(value,"value");
	goto end;
      }
    (*result)->value = value;
  }
  status = 0;
end:
  vec_delete(vec);
  return (status);
}

VOID_FUNC		ns_exp_init(ns_exp)
t_ns_exp		*ns_exp;	
{
  t_status		status;
  t_class		*class_base;
  
  if ((ns_exp->compil = compil_new(&status)) == NULL)
    {
      err_print(-status,"compil_new");
      myexit(1);
    }
  if ((ns_exp->om = object_manager_new(ns_exp->compil,&status)) == NULL)
    {
      err_print(-status,"object_manager_new");
      myexit(1);
    }
  if ((ns_exp->cm = class_manager_new(ns_exp->om,&status)) == NULL)
    {
      err_print(-status,"class_manager_new");
      myexit(1);
    }
  if ((status = class_manager_register(ns_exp->cm,&class_base_def)) < 0)
    {
      err_print(-status,"class_manager_register: base");
      myexit(1);
    }
  if ((status = class_manager_register(ns_exp->cm,&class_int_def)) < 0)
    {
      err_print(-status,"class_manager_register: int");
      myexit(1);
    }
  if ((status = class_manager_register(ns_exp->cm,&class_str_def)) < 0)
    {
      err_print(-status,"class_manager_register: str");
      myexit(1);
    }
  if ((status = class_manager(ns_exp->cm)) < 0)
    {
      err_print(-status,"class_manager");
      myexit(1);
    }
  if ((class_base = class_get_from_name(ns_exp->cm,
					CLASS_BASE_STR,
					&status)) == NULL)
    {
      err_print(-status,"class_get_from_name");
      myexit(1);
    } 
  if ((status = exp_register_func(class_base->data,
				  "echo",
				  (t_eval_func_proc)func_echo,
				  ns_exp)) < 0)
    {
      err_print(-status,"exp_register_func");
      myexit(1);
    }
  if ((status = exp_register_func(class_base->data,
				  "keepdict_count",
				  (t_eval_func_proc)func_keepdict_count,
				  ns_exp)) < 0)
    {
      err_print(-status,"exp_register_func");
      myexit(1);
    }
  if ((status = exp_register_func(class_base->data,
				  "format",
				  (t_eval_func_proc)func_format,
				  ns_exp)) < 0)
    {
      err_print(-status,"exp_register_func");
      myexit(1);
    }
  if ((status = exp_register_func(class_base->data,
				  "db_get",
				  (t_eval_func_proc)func_db_get,
				  ns_exp)) < 0)
    {
      err_print(-status,"exp_register_func");
      myexit(1);
    }
  if ((ns_exp->void_oid = object_id_get_from_name(ns_exp->om,
						  OBJECT_VOID_STR)) < 0)
    {
      err_print(-ns_exp->void_oid,"object_id_get_from_name");
      myexit(1);
    }
  if ((ns_exp->int_oid = object_id_get_from_name(ns_exp->om,
						 OBJECT_INT_STR)) < 0)
    {
      err_print(-ns_exp->int_oid,"object_id_get_from_name");
      myexit(1);
    }
  if ((ns_exp->str_oid = object_id_get_from_name(ns_exp->om,
						 OBJECT_STR_STR)) < 0)
    {
      err_print(-ns_exp->str_oid,"object_id_get_from_name");
      myexit(1);
    }
}

VOID_FUNC		ns_exp_destroy(ns_exp)
t_ns_exp		*ns_exp;
{
  class_manager_tilde(ns_exp->cm);
  class_manager_delete(ns_exp->cm);
  object_manager_delete(ns_exp->om);
  compil_delete(ns_exp->compil);
}

#ifdef DEBUG
VOID_FUNC		ns_exp_show(ns_exp)
t_ns_exp		*ns_exp;
{
  fprintf(stderr,"ns_exp:\n");
  fprintf(stderr,"\tom=0x%p\n",ns_exp->om);
  fprintf(stderr,"\tcm=0x%p\n",ns_exp->cm);
  fprintf(stderr,"\tcompil=0x%p\n",ns_exp->compil);
  fprintf(stderr,"\tvoid_oid=%d\n",ns_exp->void_oid);
  fprintf(stderr,"\tint_oid=%d\n",ns_exp->int_oid);
  fprintf(stderr,"\tstr_oid=%d\n",ns_exp->str_oid);
}
#endif
