/*
 * This file is a part of the gnetsentry project.
 * Copyright (C) 1998 Martin Gall
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
/*
 *
 */

#ifndef NETSENTRY_H
#define NETSENTRY_H	1

#include <pcap.h>
#include "a.h"
#include "layer.h"
#include "pkt.h"
#include "fcache.h"
#include "ns_exp.h"

#define NS_ALLOC_PROC		alloc_malloc
#define NS_FREE_PROC		free_free

#define NS_VEC_NEW(statusp)	vec_new(VEC_BASE,\
					FALSE,\
					alloc_algorithm_power2,\
					NS_ALLOC_PROC,\
					NS_FREE_PROC,\
					(statusp))

#define NS_DICT_NEW(statusp)	dict_new(HASH_BASE,\
					 VEC_BASE,\
					 dict_hcode_public,\
					 alloc_algorithm_power2,\
					 NS_ALLOC_PROC,\
					 NS_FREE_PROC,\
					 (statusp))

struct s_global_config;

typedef struct			s_pkt_info
{
  char				*buf;
  int				len;
  int				caplen;
  struct timeval		*ts;
} t_pkt_info;

typedef struct			s_rule
{
  char				*name;
  char				*filter;
  struct bpf_program		bp;
  t_vec				*cmds;
  t_vec				*compiled_cmds;
  int				maxfails;
  int				count;
  int				fails;
  t_boolean			cont;
  t_boolean			cont_is_defined;
  int				maxkeep;
  struct s_global_config	*gc;
  char				*exp;
  t_ns_exp			ns_exp;
  t_node			*node;
  t_pkt_info			current_pkt_info;
} t_rule;

typedef struct			s_global_config
{
  t_dict			*vars;
  pcap_t			*pcap;
  t_rule			*default_rule;
  t_vec				*rules;
  t_vec				*prefixes;
} t_global_config;

extern t_boolean		verbose;

#include "cf.h"

#endif

