/*
 * This file is a part of the gnetsentry project.
 * Copyright (C) 1998 Martin Gall
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
/*
 *
 */

#include "netsentry.h"

FILE			*file_cache_open(fc,fname,status)
t_file_cache		*fc;
char			*fname;
t_status		*status;
{
  t_hash_elt		*he;
  
  if (he = dict_get(fc->dict,fname))
    return ((FILE *)(he->value));
  else
    {
      FILE		*f;
      
      if ((f = fc->fopen_proc(fname)) == NULL)
	{
	  (*status) = -ERR_OPEN;
	  return (NULL);
	}
      if (((*status) = dict_add(fc->dict,fname,(VOID_PTR)f)) < 0)
	{
	  fc->fclose_proc(f);
	  return (NULL);
	}
      return (f);
    }
}

t_status		file_cache_close_cb(he,fc)
t_hash_elt		*he;
t_file_cache		*fc;
{
  FILE			*f;

  f = (FILE *)(he->value);
  fc->fclose_proc(f);
  return (0);
}

t_status		file_cache_close(fc)
t_file_cache		*fc;
{
  return (dict_walk(fc->dict,
		    (t_dict_walk_proc)file_cache_close_cb,
		    fc));
}

t_status		file_cache_flush_cb(he,fc)
t_hash_elt		*he;
t_file_cache		*fc;
{
  FILE			*f;

  f = (FILE *)(he->value);
  fflush(f);
  return (0);
}

t_status		file_cache_flush(fc)
t_file_cache		*fc;
{
  return (dict_walk(fc->dict,
		    (t_dict_walk_proc)file_cache_flush_cb,
		    fc));
}
