/*
 * This file is a part of the gnetsentry project.
 * Copyright (C) 1998 Martin Gall
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
/*
 *
 */

#include "netsentry.h"

t_dict			*keepdict = NULL;
int			nbcmdkeepcalls = 0;
int			nbkeptpkts = 0;

t_status		cmd_keep(args,buf,len,caplen,ts,pcap,rule,data)
t_vec			*args;
char			*buf;
int			caplen;
int			len;
struct timeval		*ts;
pcap_t			*pcap;
t_rule			*rule;
VOID_PTR		data;	
{
  t_status		status;
  char			key[STR_BUFSIZ];
  t_pkt			pkt;
  t_pkt			*npkt;
  FILE			*f;
  t_hash_elt		*he;
  t_vec			*vec;
  
  nbcmdkeepcalls++;
  key[0] = 0;
  if ((status = pkt_get(buf,len,caplen,ts,pcap,&pkt)) < 0)
    return (status);
  if ((status = pkt_format(&pkt,
			   VEC_AT(args,1),
			   rule->gc->prefixes,
			   key,
			   sizeof (key))) < 0)
    return (status);
  if (he = dict_get(keepdict,key))
    vec = (t_vec *)(he->value);
  else
    {
      if ((vec = NS_VEC_NEW(&status)) == NULL)
	return (status);
      if ((status = dict_add(keepdict,key,vec)) < 0)
	return (status);
    }
  if ((npkt = pkt_dup(&pkt,NS_ALLOC_PROC,NS_FREE_PROC,&status)) == NULL)
    return (status);
  if (VEC_COUNT(vec) < rule->maxkeep)
    {
      if ((status = vec_add(vec,npkt)) < 0)
	return (status);
    }
  else
    return (-ERR_TOOMUCHDATA);
  nbkeptpkts++;
  return (0);
}

t_status		cmd_keep_init(args,cc)
t_vec			*args;
t_compiled_cmd		*cc;
{
  if (VEC_COUNT(args) != 2)
    {
      err_print(ERR_TOOMANY,"syntax: keep format_key");
      return (-1);
    }
  cc->cmd_proc = cmd_keep;
  return (0);
}

VOID_FUNC		cmd_keep_info(VOID_DECL)
{
  fprintf(stderr,"cmd_keep was called %d time(s)\n",nbcmdkeepcalls);
  fprintf(stderr,"keepdict %d elt(s)\n",dict_count(keepdict));
  fprintf(stderr,"kept %d pkt(s)\n",nbkeptpkts);
}

t_status		free_vec_of_pkts(he,unused)
t_hash_elt		*he;
VOID_PTR		unused;
{
  t_vec			*vec;

  vec = (t_vec *)(he->value);
  VEC_FOR(vec,t_pkt *pkt)
    {
      NS_FREE_PROC(pkt->buf,"pkt->buf");
      NS_FREE_PROC(pkt,"pkt");
    }
  VEC_ENDFOR;
  vec_delete(vec);
  return (0);
}

VOID_FUNC		free_keepdict(VOID_DECL)
{
  dict_walk(keepdict,
	    (t_dict_walk_proc)free_vec_of_pkts,
	    NULL);
  dict_delete(keepdict);
}
