/*
 * This file is a part of the gnetsentry project.
 * Copyright (C) 1998 Martin Gall
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
/*
 *
 */

#include "netsentry.h"
#include "cmd_exec.h"

int		exec_vec_from(pkt,prefixes,vec,frompos)
t_pkt		*pkt;
t_vec		*prefixes;
t_vec		*vec;
int		frompos;
{
  int		status;
  pid_t		pid;
  int		w;
  char		**argv;
  size_t	size;
  int		i;
  int		j;
  char		arg[STR_BUFSIZ];

  size = (VEC_COUNT(vec)  - frompos + 1) * sizeof (char *);
  if ((argv = NS_ALLOC_PROC(size,"argv",&status)) == NULL)
    return (status);
  i = 0;
  VEC_FOR_FROM(vec,frompos,char *str)
    {
      arg[0] = 0;
      if ((status = pkt_format(pkt,
			       str,
			       prefixes,
			       arg,
			       sizeof (arg))) < 0)
	return (status);
      if ((argv[i++] = strdup_alloc(arg,
				    NS_ALLOC_PROC,
				    "argv[i]",
				    &status)) == NULL)
	return (status);
    }
  VEC_ENDFOR;
  argv[i] = NULL;
  if ((pid = fork()) == 0)
    {
      execvp(argv[0],argv);
      err_print(ERR_SYSCALL,"can't execvp %s",argv[0]);
      exit(1);
    }
#ifdef NOTDEF
  signal(SIGINT,SIG_IGN);
  signal(SIGQUIT,SIG_IGN);
#endif
  while ((w = wait(&status)) != pid && w != -1)
    ;
  if (w == -1)
    status = -1;
#ifdef NOTDEF
  signal(SIGINT,SIG_DFL);
  signal(SIGQUIT,SIG_DFL);
#endif
  j = 0;
  while (j < i)
    {
      NS_FREE_PROC(argv[j],"argv[j]");
      j++;
    } 
  NS_FREE_PROC(argv,"argv");
  return (status);
}

t_status		cmd_exec(args,buf,len,caplen,ts,pcap,rule,data)
t_vec			*args;
char			*buf;
int			caplen;
int			len;
struct timeval		*ts;
pcap_t			*pcap;
t_rule			*rule;
VOID_PTR		data;
{
  t_pkt			pkt;
  t_status		status;

  if ((status = pkt_get(buf,len,caplen,ts,pcap,&pkt)) < 0)
    return (status);
  return (exec_vec_from(&pkt,rule->gc->prefixes,args,1));
}

t_status		cmd_exec_init(args,cc)
t_vec			*args;
t_compiled_cmd		*cc;
{
  t_status		status;

  if (VEC_COUNT(args) < 2)
    {
      err_print(ERR_NEEDMORE,
		"syntax: exec format_arg0 format_arg1 ... format_argn");
      return (-1);
    }
  cc->cmd_proc = cmd_exec;
  return (0);
}
