/*
 * This file is a part of the gnetsentry project.
 * Copyright (C) 1998 Martin Gall
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
/*
 *
 */

#include <fcntl.h>
#include "netsentry.h"

extern t_file_cache	file_cache_rplus;

t_status		cmd_count(args,buf,len,caplen,ts,pcap,rule,data)
t_vec			*args;
char			*buf;
int			caplen;
int			len;
struct timeval		*ts;
pcap_t			*pcap;
t_rule			*rule;
VOID_PTR		data;
{
  t_status		status;
  FILE			*f;
  int			count;
  int			total_caplen;
  int			total_len;

  if ((f = file_cache_open(&file_cache_rplus,
			   VEC_AT(args,1),
			   &status)) == NULL)
    return (status);
  rewind(f);
  if (fscanf(f,"%d %d %d",&count,&total_caplen,&total_len) != 3)
    return (-ERR_BADFMT);
  count++;
  total_caplen += caplen;
  total_len += len;
#ifdef NOTDEF
  fprintf(stderr,"%d %d %d\n",count,total_caplen,total_len);
#endif
  rewind(f);
  if (fprintf(f,"%d %d %d\n",count,total_caplen,total_len) < 0)
    return (-ERR_WRITE);
  return (0);
}

t_status		cmd_count_init(args,cc)
t_vec			*args;
t_compiled_cmd		*cc;
{
  FILE			*f;
  t_status		status;
  t_boolean		initialize;

  if (VEC_COUNT(args) != 2)
    {
      err_print(ERR_NEEDMORE,"syntax: count file");
      return (-1);
    }
  initialize = FALSE;
retry:
  if ((f = file_cache_open(&file_cache_rplus,
			   VEC_AT(args,1),
			   &status)) == NULL)
    {
      int		fd;

      if (initialize || status != -ERR_OPEN)
	{
	  err_print(-status,"opening %s",VEC_AT(args,1));
	  return (-1);
	}
      if ((fd = open(VEC_AT(args,1),O_RDWR|O_CREAT,0644)) < 0)
	{
	  err_print(ERR_OPEN,"creating %s",VEC_AT(args,1));
	  return (-1);
	}
      initialize = TRUE;
      goto retry;
    }
  if (initialize)
    if (fprintf(f,"0 0 0\n") < 0)
      {
	return (-1);
      }
  cc->cmd_proc = cmd_count;
  return (0);
}
