#! /bin/sh

#
#
#

cf=./mk.conf
tmpfile=/tmp/mk.$$
bindir=.
mylibpcap=libpcap-0.2.1

ask() # var,help,mandatory
{
	oldval=`eval echo \$\{$1\}`
	echo -n $2 \[$oldval\]"? "
	read ans
	if [ "$ans" = "" ]
	then
		if [ "$oldval" = "" ]
		then
			if [ "$3" = "true" ]
			then
				echo $1 is mandatory
				myexit 1
			fi
		else
			eval $1="$oldval"
		fi
	else
		eval $1="$ans"
		egrep -v "^$1=" $cf > $tmpfile
		echo $1="$ans" >> $tmpfile
		cp $tmpfile $cf
		rm -f $tmpfile
	fi
}

if [ ! -f $cf ]
then
	echo > $cf
	echo use_my_libpcap=y >> $cf
	echo pcap_include="`pwd`/$mylibpcap" >> $cf
	echo pcap_library="`pwd`/$mylibpcap" >> $cf
fi

. $cf

ask use_my_libpcap "Use my libpcap (y/n)" true
ask pcap_include "Libpcap include" true
ask pcap_library "Libpcap library" true

if [ "$use_my_libpcap" = "y" ]
then
    cd $mylibpcap
    ./configure
    make
    cd ..
fi

./configure \
	--with-debug \
	--with-debug-malloc \
	--with-pcap \
	--with-pcap-include=$pcap_include \
	--with-pcap-library=$pcap_library
exit 0
