
# line 2 "grammar.y"
/*
 * Copyright (c) 1988, 1989, 1990, 1991, 1992, 1993, 1994, 1995, 1996
 *	The Regents of the University of California.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that: (1) source code distributions
 * retain the above copyright notice and this paragraph in its entirety, (2)
 * distributions including binary code include the above copyright notice and
 * this paragraph in its entirety in the documentation or other materials
 * provided with the distribution, and (3) all advertising materials mentioning
 * features or use of this software display the following acknowledgement:
 * ``This product includes software developed by the University of California,
 * Lawrence Berkeley Laboratory and its contributors.'' Neither the name of
 * the University nor the names of its contributors may be used to endorse
 * or promote products derived from this software without specific prior
 * written permission.
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 *
 */
#ifndef lint
static char rcsid[] =
    "@(#) $Header: grammar.y,v 1.54 96/07/17 00:11:34 leres Exp $ (LBL)";
#endif

#include <sys/types.h>
#include <sys/time.h>
#include <sys/socket.h>

#if __STDC__
struct mbuf;
struct rtentry;
#endif

#include <net/if.h>

#include <netinet/in.h>
#include <netinet/if_ether.h>

#include <stdio.h>

#include "pcap-int.h"

#include "gencode.h"
#include <pcap-namedb.h>

#include "gnuc.h"
#ifdef HAVE_OS_PROTO_H
#include "os-proto.h"
#endif

#define QSET(q, p, d, a) (q).proto = (p),\
			 (q).dir = (d),\
			 (q).addr = (a)

int n_errors = 0;

static struct qual qerr = { Q_UNDEF, Q_UNDEF, Q_UNDEF, Q_UNDEF };

static void
yyerror(char *msg)
{
	++n_errors;
	bpf_error(msg);
	/* NOTREACHED */
}

/*#ifndef YYBISON*/
int yyparse(void);

int
pcap_parse()
{
	return (yyparse());
}
/*#endif*/


# line 82 "grammar.y"
typedef union  {
	int i;
	bpf_u_int32 h;
	u_char *e;
	char *s;
	struct stmt *stmt;
	struct arth *a;
	struct {
		struct qual q;
		struct block *b;
	} blk;
	struct block *rblk;
} YYSTYPE;
# define DST 257
# define SRC 258
# define HOST 259
# define GATEWAY 260
# define NET 261
# define MASK 262
# define PORT 263
# define LESS 264
# define GREATER 265
# define PROTO 266
# define BYTE 267
# define ARP 268
# define RARP 269
# define IP 270
# define TCP 271
# define UDP 272
# define ICMP 273
# define IGMP 274
# define IGRP 275
# define ATALK 276
# define DECNET 277
# define LAT 278
# define SCA 279
# define MOPRC 280
# define MOPDL 281
# define TK_BROADCAST 282
# define TK_MULTICAST 283
# define NUM 284
# define INBOUND 285
# define OUTBOUND 286
# define LINK 287
# define GEQ 288
# define LEQ 289
# define NEQ 290
# define ID 291
# define EID 292
# define HID 293
# define LSH 294
# define RSH 295
# define LEN 296
# define OR 297
# define AND 298
# define UMINUS 299
#define yyclearin yychar = -1
#define yyerrok yyerrflag = 0
extern int yychar;
extern int yyerrflag;
#ifndef YYMAXDEPTH
#define YYMAXDEPTH 150
#endif
YYSTYPE yylval, yyval;
typedef int yytabelem;
# define YYERRCODE 256

# line 281 "grammar.y"

static yytabelem yyexca[] ={
-1, 1,
	0, -1,
	-2, 0,
-1, 2,
	0, 2,
	-2, 41,
-1, 9,
	0, 36,
	297, 36,
	298, 36,
	41, 36,
	-2, 40,
-1, 94,
	0, 12,
	297, 12,
	298, 12,
	41, 12,
	-2, 80,
-1, 132,
	297, 25,
	298, 25,
	-2, 80,
	};
# define YYNPROD 102
# define YYLAST 420
static yytabelem yyact[]={

    12,    43,    42,    61,    59,    14,    60,    14,    62,   123,
   124,   138,    38,   121,   122,    80,    79,    81,    84,    82,
   148,    83,   145,   106,    75,   137,    87,    86,    85,    63,
    12,   144,   143,    61,    59,   103,    60,    14,    62,   142,
    77,    78,    38,    81,   141,    82,    41,    83,    40,   140,
   149,    56,    63,   108,    74,    31,    61,    59,    63,    60,
    46,    62,    61,    59,    54,    60,    14,    62,    63,    61,
   133,    38,    61,    59,    62,    60,    12,    62,    89,   107,
   126,     8,     4,    14,   139,     8,    48,     8,    30,    44,
    71,    69,    67,   105,    11,    53,    47,    55,     3,     1,
     2,    45,   128,   130,   129,    52,    58,    57,     6,   100,
   125,    76,     6,    73,     6,    64,    13,     7,   101,    95,
    95,     5,    98,    91,    96,     0,     0,   102,   120,    94,
    94,    48,     0,     0,    92,    97,     0,    99,    64,    61,
    59,    47,    60,     0,    62,    54,    93,    93,   135,     0,
   134,    54,     0,     0,    64,     0,   100,     0,     0,     0,
     0,     0,     0,     0,     0,     0,   127,     0,     0,     0,
     0,     0,    95,     0,     8,     0,    44,     0,    55,     0,
     0,   102,    94,     0,   132,     0,     0,     0,     0,     0,
     0,   136,     0,     0,     0,     0,     0,     0,     0,    93,
     0,    93,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,    48,    48,     0,     0,     0,     0,     0,
     0,     0,     0,    47,    47,     0,     0,     0,   146,   147,
     0,    32,    33,     0,    34,    17,    18,    16,    19,    20,
    21,    22,    23,    24,    25,    26,    27,    29,    28,    37,
   104,    37,    35,    36,    15,    65,    66,     0,    49,    51,
    50,    32,    33,    39,    34,    17,    18,    16,    19,    20,
    21,    22,    23,    24,    25,    26,    27,    29,    28,    43,
    42,    37,    35,    36,    15,    65,    66,     0,     0,    10,
     0,     0,     0,    39,    17,    18,    16,    19,    20,    21,
    22,    23,    24,    25,    26,    27,    29,    28,    65,    66,
    37,     0,     0,    15,    65,    66,     0,     0,    68,    70,
    72,     0,    39,    90,    65,    66,     9,    37,    88,     0,
     9,     0,     9,     0,    49,    51,    50,     0,     0,     0,
     0,     0,     0,     0,     0,     0,   109,   110,   111,   112,
   113,   114,   115,   116,   117,   118,   119,     0,     0,     0,
     0,     0,     0,     0,     9,     9,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,   131,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     9,     0,     9 };
static yytabelem yypact[]={

 -1000, -1000,    -3,  -296, -1000, -1000,    -3,    43,    -3,   -40,
    30, -1000, -1000,  -242, -1000, -1000, -1000, -1000, -1000, -1000,
 -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000,
 -1000, -1000,  -256,  -257,  -258, -1000, -1000, -1000,    26, -1000,
   -33,   -33, -1000, -1000, -1000, -1000, -1000, -1000,    43, -1000,
   -12, -1000,    43,   -18,    38,    12,    26,    26,    26,    26,
    26,    26,    26,    26,    26,    26,    26, -1000, -1000, -1000,
 -1000, -1000, -1000,  -216, -1000, -1000, -1000, -1000, -1000,  -284,
  -288, -1000, -1000, -1000, -1000, -1000, -1000,    42, -1000,    26,
   -40, -1000, -1000,   -33, -1000,   -33, -1000, -1000,    29,    12,
 -1000,  -296,   -35,  -259,  -282, -1000, -1000, -1000, -1000,    -9,
    14,    14,    27,    27, -1000, -1000,   -39,    20,    97,    97,
 -1000,  -213,  -218,  -226,  -227,  -262, -1000, -1000, -1000, -1000,
 -1000,    14,    12, -1000,    43,    43,    12, -1000, -1000, -1000,
  -264, -1000, -1000, -1000, -1000, -1000, -1000, -1000,   -43, -1000 };
static yytabelem yypgo[]={

     0,    95,    93,    60,   122,    82,   121,   118,   117,   116,
   113,    54,   111,   289,    55,   110,   323,    88,   107,   106,
    48,    46,    78,   105,   100,    99,    94 };
static yytabelem yyr1[]={

     0,    25,    25,    24,     1,     1,     1,     1,     1,    20,
    21,     2,     2,     2,     3,     3,     3,     3,     3,     3,
    23,    22,     4,     4,     4,     7,     7,     5,     5,     8,
     8,     8,     8,     8,     6,     6,     6,     6,     6,     6,
     9,     9,    10,    10,    10,    10,    10,    10,    11,    11,
    11,    12,    16,    16,    16,    16,    16,    16,    16,    16,
    16,    16,    16,    16,    16,    16,    16,    26,    26,    26,
    26,    26,    26,    26,    18,    18,    18,    19,    19,    19,
    13,    13,    14,    14,    14,    14,    14,    14,    14,    14,
    14,    14,    14,    14,    14,    15,    15,    15,    15,    15,
    17,    17 };
static yytabelem yyr2[]={

     0,     5,     2,     1,     2,     7,     7,     7,     7,     3,
     3,     2,     3,     7,     3,     7,     7,     3,     3,     5,
     3,     3,     2,     7,     7,     3,     2,     2,     5,     7,
     5,     5,     5,     5,     5,     7,     3,     7,     7,     3,
     2,     1,     3,     3,     7,     7,     7,     7,     3,     3,
     3,     3,     3,     3,     3,     3,     3,     3,     3,     3,
     3,     3,     3,     3,     3,     3,     3,     5,     5,     5,
     5,     9,     3,     3,     3,     3,     3,     3,     3,     3,
     3,     2,     9,    13,     7,     7,     7,     7,     7,     7,
     7,     7,     5,     7,     3,     3,     3,     3,     3,     3,
     2,     7 };
static yytabelem yychk[]={

 -1000,   -25,   -24,    -1,    -5,    -6,   -23,    -8,   -22,   -16,
   -13,   -26,    33,    -9,    40,   287,   270,   268,   269,   271,
   272,   273,   274,   275,   276,   277,   278,   279,   281,   280,
   -17,   -14,   264,   265,   267,   285,   286,   284,    45,   296,
   -20,   -21,   298,   297,    -5,    -2,    -3,   -17,   -22,   291,
   293,   292,   -23,    -1,   -14,   -17,    91,   -18,   -19,    43,
    45,    42,    47,    38,   124,   294,   295,    62,   288,    61,
   289,    60,   290,   -10,   -11,   266,   -12,   282,   283,   258,
   257,   259,   261,   263,   260,   284,   284,   284,   -13,   -22,
   -16,    -5,    -2,   -23,   -17,   -22,    -5,    -2,    -4,   -17,
    -3,    -7,   -22,    47,   262,    -2,    41,    41,    41,   -13,
   -13,   -13,   -13,   -13,   -13,   -13,   -13,   -13,   -13,   -13,
   -11,   297,   298,   297,   298,   -15,    38,   124,    60,    62,
    61,   -13,   -17,    41,   -20,   -21,   -17,   284,   293,    93,
    58,   257,   257,   258,   258,   284,    -2,    -2,   284,    93 };
static yytabelem yydef[]={

     3,    -2,    -2,     1,     4,    27,    41,     0,    41,    -2,
     0,    39,    20,     0,    21,    52,    53,    54,    55,    56,
    57,    58,    59,    60,    61,    62,    63,    64,    65,    66,
    80,    81,     0,     0,     0,    72,    73,   100,     0,    94,
    41,    41,     9,    10,    28,    34,    11,    12,     0,    14,
    17,    18,     0,     0,    81,    80,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,    74,    75,    76,
    77,    78,    79,    30,    31,    32,    33,    67,    68,    42,
    43,    48,    49,    50,    51,    69,    70,     0,    92,     0,
     0,     5,     6,    41,    -2,    41,     7,     8,    26,    25,
    22,     0,     0,     0,     0,    19,    35,    93,   101,     0,
    37,    38,    84,    85,    86,    87,    88,    89,    90,    91,
    29,     0,     0,     0,     0,     0,    95,    96,    97,    98,
    99,     0,    -2,    13,     0,     0,     0,    15,    16,    82,
     0,    44,    46,    45,    47,    71,    23,    24,     0,    83 };
typedef struct { char *t_name; int t_val; } yytoktype;
#ifndef YYDEBUG
#	define YYDEBUG	0	/* don't allow debugging */
#endif

#if YYDEBUG

yytoktype yytoks[] =
{
	"DST",	257,
	"SRC",	258,
	"HOST",	259,
	"GATEWAY",	260,
	"NET",	261,
	"MASK",	262,
	"PORT",	263,
	"LESS",	264,
	"GREATER",	265,
	"PROTO",	266,
	"BYTE",	267,
	"ARP",	268,
	"RARP",	269,
	"IP",	270,
	"TCP",	271,
	"UDP",	272,
	"ICMP",	273,
	"IGMP",	274,
	"IGRP",	275,
	"ATALK",	276,
	"DECNET",	277,
	"LAT",	278,
	"SCA",	279,
	"MOPRC",	280,
	"MOPDL",	281,
	"TK_BROADCAST",	282,
	"TK_MULTICAST",	283,
	"NUM",	284,
	"INBOUND",	285,
	"OUTBOUND",	286,
	"LINK",	287,
	"GEQ",	288,
	"LEQ",	289,
	"NEQ",	290,
	"ID",	291,
	"EID",	292,
	"HID",	293,
	"LSH",	294,
	"RSH",	295,
	"LEN",	296,
	"OR",	297,
	"AND",	298,
	"!",	33,
	"|",	124,
	"&",	38,
	"+",	43,
	"-",	45,
	"*",	42,
	"/",	47,
	"UMINUS",	299,
	"-unknown-",	-1	/* ends search */
};

char * yyreds[] =
{
	"-no such reduction-",
      "prog : null expr",
      "prog : null",
      "null : /* empty */",
      "expr : term",
      "expr : expr and term",
      "expr : expr and id",
      "expr : expr or term",
      "expr : expr or id",
      "and : AND",
      "or : OR",
      "id : nid",
      "id : pnum",
      "id : paren pid ')'",
      "nid : ID",
      "nid : HID '/' NUM",
      "nid : HID MASK HID",
      "nid : HID",
      "nid : EID",
      "nid : not id",
      "not : '!'",
      "paren : '('",
      "pid : nid",
      "pid : qid and id",
      "pid : qid or id",
      "qid : pnum",
      "qid : pid",
      "term : rterm",
      "term : not term",
      "head : pqual dqual aqual",
      "head : pqual dqual",
      "head : pqual aqual",
      "head : pqual PROTO",
      "head : pqual ndaqual",
      "rterm : head id",
      "rterm : paren expr ')'",
      "rterm : pname",
      "rterm : arth relop arth",
      "rterm : arth irelop arth",
      "rterm : other",
      "pqual : pname",
      "pqual : /* empty */",
      "dqual : SRC",
      "dqual : DST",
      "dqual : SRC OR DST",
      "dqual : DST OR SRC",
      "dqual : SRC AND DST",
      "dqual : DST AND SRC",
      "aqual : HOST",
      "aqual : NET",
      "aqual : PORT",
      "ndaqual : GATEWAY",
      "pname : LINK",
      "pname : IP",
      "pname : ARP",
      "pname : RARP",
      "pname : TCP",
      "pname : UDP",
      "pname : ICMP",
      "pname : IGMP",
      "pname : IGRP",
      "pname : ATALK",
      "pname : DECNET",
      "pname : LAT",
      "pname : SCA",
      "pname : MOPDL",
      "pname : MOPRC",
      "other : pqual TK_BROADCAST",
      "other : pqual TK_MULTICAST",
      "other : LESS NUM",
      "other : GREATER NUM",
      "other : BYTE NUM byteop NUM",
      "other : INBOUND",
      "other : OUTBOUND",
      "relop : '>'",
      "relop : GEQ",
      "relop : '='",
      "irelop : LEQ",
      "irelop : '<'",
      "irelop : NEQ",
      "arth : pnum",
      "arth : narth",
      "narth : pname '[' arth ']'",
      "narth : pname '[' arth ':' NUM ']'",
      "narth : arth '+' arth",
      "narth : arth '-' arth",
      "narth : arth '*' arth",
      "narth : arth '/' arth",
      "narth : arth '&' arth",
      "narth : arth '|' arth",
      "narth : arth LSH arth",
      "narth : arth RSH arth",
      "narth : '-' arth",
      "narth : paren narth ')'",
      "narth : LEN",
      "byteop : '&'",
      "byteop : '|'",
      "byteop : '<'",
      "byteop : '>'",
      "byteop : '='",
      "pnum : NUM",
      "pnum : paren pnum ')'",
};
#endif /* YYDEBUG */
/*
 * (c) Copyright 1990, OPEN SOFTWARE FOUNDATION, INC.
 * ALL RIGHTS RESERVED
 */
/*
 * OSF/1 Release 1.0
 */
/* @(#)yaccpar	1.3  com/cmd/lang/yacc,3.1, 9/7/89 18:46:37 */
/*
** Skeleton parser driver for yacc output
*/

/*
** yacc user known macros and defines
*/
#ifdef YYSPLIT
#   define YYERROR	return(-2)
#else
#   define YYERROR	goto yyerrlab
#endif

#define YYACCEPT	return(0)
#define YYABORT		return(1)
#define YYBACKUP( newtoken, newvalue )\
{\
	if ( yychar >= 0 || ( yyr2[ yytmp ] >> 1 ) != 1 )\
	{\
		yyerror( "syntax error - cannot backup" );\
		goto yyerrlab;\
	}\
	yychar = newtoken;\
	yystate = *yyps;\
	yylval = newvalue;\
	goto yynewstate;\
}
#define YYRECOVERING()	(!!yyerrflag)
#ifndef YYDEBUG
#	define YYDEBUG	1	/* make debugging available */
#endif

/*
** user known globals
*/
int yydebug;			/* set to 1 to get debugging */

/*
** driver internal defines
*/
#define YYFLAG		(-1000)

#ifdef YYSPLIT
#   define YYSCODE { \
			extern int (*yyf[])(); \
			register int yyret; \
			if (yyf[yytmp]) \
			    if ((yyret=(*yyf[yytmp])()) == -2) \
				    goto yyerrlab; \
				else if (yyret>=0) return(yyret); \
		   }
#endif

/*
** global variables used by the parser
*/
YYSTYPE yyv[ YYMAXDEPTH ];	/* value stack */
int yys[ YYMAXDEPTH ];		/* state stack */

YYSTYPE *yypv;			/* top of value stack */
YYSTYPE *yypvt;			/* top of value stack for $vars */
int *yyps;			/* top of state stack */

int yystate;			/* current state */
int yytmp;			/* extra var (lasts between blocks) */

int yynerrs;			/* number of errors */
int yyerrflag;			/* error recovery flag */
int yychar;			/* current input token number */



/*
** yyparse - return 0 if worked, 1 if syntax error not recovered from
*/
int
yyparse()
{
	/*
	** Initialize externals - yyparse may be called more than once
	*/
	yypv = &yyv[-1];
	yyps = &yys[-1];
	yystate = 0;
	yytmp = 0;
	yynerrs = 0;
	yyerrflag = 0;
	yychar = -1;

	goto yystack;
	{
		register YYSTYPE *yy_pv;	/* top of value stack */
		register int *yy_ps;		/* top of state stack */
		register int yy_state;		/* current state */
		register int  yy_n;		/* internal state number info */

		/*
		** get globals into registers.
		** branch to here only if YYBACKUP was called.
		*/
	yynewstate:
		yy_pv = yypv;
		yy_ps = yyps;
		yy_state = yystate;
		goto yy_newstate;

		/*
		** get globals into registers.
		** either we just started, or we just finished a reduction
		*/
	yystack:
		yy_pv = yypv;
		yy_ps = yyps;
		yy_state = yystate;

		/*
		** top of for (;;) loop while no reductions done
		*/
	yy_stack:
		/*
		** put a state and value onto the stacks
		*/
#if YYDEBUG
		/*
		** if debugging, look up token value in list of value vs.
		** name pairs.  0 and negative (-1) are special values.
		** Note: linear search is used since time is not a real
		** consideration while debugging.
		*/
		if ( yydebug )
		{
			register int yy_i;

			printf( "State %d, token ", yy_state );
			if ( yychar == 0 )
				printf( "end-of-file\n" );
			else if ( yychar < 0 )
				printf( "-none-\n" );
			else
			{
				for ( yy_i = 0; yytoks[yy_i].t_val >= 0;
					yy_i++ )
				{
					if ( yytoks[yy_i].t_val == yychar )
						break;
				}
				printf( "%s\n", yytoks[yy_i].t_name );
			}
		}
#endif /* YYDEBUG */
		if ( ++yy_ps >= &yys[ YYMAXDEPTH ] )	/* room on stack? */
		{
			yyerror( "yacc stack overflow" );
			YYABORT;
		}
		*yy_ps = yy_state;
		*++yy_pv = yyval;

		/*
		** we have a new state - find out what to do
		*/
	yy_newstate:
		if ( ( yy_n = yypact[ yy_state ] ) <= YYFLAG )
			goto yydefault;		/* simple state */
#if YYDEBUG
		/*
		** if debugging, need to mark whether new token grabbed
		*/
		yytmp = yychar < 0;
#endif
		if ( ( yychar < 0 ) && ( ( yychar = yylex() ) < 0 ) )
			yychar = 0;		/* reached EOF */
#if YYDEBUG
		if ( yydebug && yytmp )
		{
			register int yy_i;

			printf( "Received token " );
			if ( yychar == 0 )
				printf( "end-of-file\n" );
			else if ( yychar < 0 )
				printf( "-none-\n" );
			else
			{
				for ( yy_i = 0; yytoks[yy_i].t_val >= 0;
					yy_i++ )
				{
					if ( yytoks[yy_i].t_val == yychar )
						break;
				}
				printf( "%s\n", yytoks[yy_i].t_name );
			}
		}
#endif /* YYDEBUG */
		if ( ( ( yy_n += yychar ) < 0 ) || ( yy_n >= YYLAST ) )
			goto yydefault;
		if ( yychk[ yy_n = yyact[ yy_n ] ] == yychar )	/*valid shift*/
		{
			yychar = -1;
			yyval = yylval;
			yy_state = yy_n;
			if ( yyerrflag > 0 )
				yyerrflag--;
			goto yy_stack;
		}

	yydefault:
		if ( ( yy_n = yydef[ yy_state ] ) == -2 )
		{
#if YYDEBUG
			yytmp = yychar < 0;
#endif
			if ( ( yychar < 0 ) && ( ( yychar = yylex() ) < 0 ) )
				yychar = 0;		/* reached EOF */
#if YYDEBUG
			if ( yydebug && yytmp )
			{
				register int yy_i;

				printf( "Received token " );
				if ( yychar == 0 )
					printf( "end-of-file\n" );
				else if ( yychar < 0 )
					printf( "-none-\n" );
				else
				{
					for ( yy_i = 0;
						yytoks[yy_i].t_val >= 0;
						yy_i++ )
					{
						if ( yytoks[yy_i].t_val
							== yychar )
						{
							break;
						}
					}
					printf( "%s\n", yytoks[yy_i].t_name );
				}
			}
#endif /* YYDEBUG */
			/*
			** look through exception table
			*/
			{
				register int *yyxi = yyexca;

				while ( ( *yyxi != -1 ) ||
					( yyxi[1] != yy_state ) )
				{
					yyxi += 2;
				}
				while ( ( *(yyxi += 2) >= 0 ) &&
					( *yyxi != yychar ) )
					;
				if ( ( yy_n = yyxi[1] ) < 0 )
					YYACCEPT;
			}
		}

		/*
		** check for syntax error
		*/
		if ( yy_n == 0 )	/* have an error */
		{
			/* no worry about speed here! */
			switch ( yyerrflag )
			{
			case 0:		/* new error */
				yyerror( "syntax error" );
				goto skip_init;
			yyerrlab:
				/*
				** get globals into registers.
				** we have a user generated syntax type error
				*/
				yy_pv = yypv;
				yy_ps = yyps;
				yy_state = yystate;
				yynerrs++;
			skip_init:
			case 1:
			case 2:		/* incompletely recovered error */
					/* try again... */
				yyerrflag = 3;
				/*
				** find state where "error" is a legal
				** shift action
				*/
				while ( yy_ps >= yys )
				{
					yy_n = yypact[ *yy_ps ] + YYERRCODE;
					if ( yy_n >= 0 && yy_n < YYLAST &&
						yychk[yyact[yy_n]] == YYERRCODE)					{
						/*
						** simulate shift of "error"
						*/
						yy_state = yyact[ yy_n ];
						goto yy_stack;
					}
					/*
					** current state has no shift on
					** "error", pop stack
					*/
#if YYDEBUG
#	define _POP_ "Error recovery pops state %d, uncovers state %d\n"
					if ( yydebug )
						printf( _POP_, *yy_ps,
							yy_ps[-1] );
#	undef _POP_
#endif
					yy_ps--;
					yy_pv--;
				}
				/*
				** there is no state on stack with "error" as
				** a valid shift.  give up.
				*/
				YYABORT;
			case 3:		/* no shift yet; eat a token */
#if YYDEBUG
				/*
				** if debugging, look up token in list of
				** pairs.  0 and negative shouldn't occur,
				** but since timing doesn't matter when
				** debugging, it doesn't hurt to leave the
				** tests here.
				*/
				if ( yydebug )
				{
					register int yy_i;

					printf( "Error recovery discards " );
					if ( yychar == 0 )
						printf( "token end-of-file\n" );
					else if ( yychar < 0 )
						printf( "token -none-\n" );
					else
					{
						for ( yy_i = 0;
							yytoks[yy_i].t_val >= 0;
							yy_i++ )
						{
							if ( yytoks[yy_i].t_val
								== yychar )
							{
								break;
							}
						}
						printf( "token %s\n",
							yytoks[yy_i].t_name );
					}
				}
#endif /* YYDEBUG */
				if ( yychar == 0 )	/* reached EOF. quit */
					YYABORT;
				yychar = -1;
				goto yy_newstate;
			}
		}/* end if ( yy_n == 0 ) */
		/*
		** reduction by production yy_n
		** put stack tops, etc. so things right after switch
		*/
#if YYDEBUG
		/*
		** if debugging, print the string that is the user's
		** specification of the reduction which is just about
		** to be done.
		*/
		if ( yydebug )
			printf( "Reduce by (%d) \"%s\"\n",
				yy_n, yyreds[ yy_n ] );
#endif
		yytmp = yy_n;			/* value to switch over */
		yypvt = yy_pv;			/* $vars top of value stack */
		/*
		** Look in goto table for next state
		** Sorry about using yy_state here as temporary
		** register variable, but why not, if it works...
		** If yyr2[ yy_n ] doesn't have the low order bit
		** set, then there is no action to be done for
		** this reduction.  So, no saving & unsaving of
		** registers done.  The only difference between the
		** code just after the if and the body of the if is
		** the goto yy_stack in the body.  This way the test
		** can be made before the choice of what to do is needed.
		*/
		{
			/* length of production doubled with extra bit */
			register int yy_len = yyr2[ yy_n ];

			if ( !( yy_len & 01 ) )
			{
				yy_len >>= 1;
				yyval = ( yy_pv -= yy_len )[1];	/* $$ = $1 */
				yy_state = yypgo[ yy_n = yyr1[ yy_n ] ] +
					*( yy_ps -= yy_len ) + 1;
				if ( yy_state >= YYLAST ||
					yychk[ yy_state =
					yyact[ yy_state ] ] != -yy_n )
				{
					yy_state = yyact[ yypgo[ yy_n ] ];
				}
				goto yy_stack;
			}
			yy_len >>= 1;
			yyval = ( yy_pv -= yy_len )[1];	/* $$ = $1 */
			yy_state = yypgo[ yy_n = yyr1[ yy_n ] ] +
				*( yy_ps -= yy_len ) + 1;
			if ( yy_state >= YYLAST ||
				yychk[ yy_state = yyact[ yy_state ] ] != -yy_n )
			{
				yy_state = yyact[ yypgo[ yy_n ] ];
			}
		}
					/* save until reenter driver code */
		yystate = yy_state;
		yyps = yy_ps;
		yypv = yy_pv;
	}
	/*
	** code supplied by user is placed in this switch
	*/

		switch(yytmp){

case 1:
# line 131 "grammar.y"
{
	finish_parse(yypvt[-0].blk.b);
} /*NOTREACHED*/ break;
case 3:
# line 136 "grammar.y"
{ yyval.blk.q = qerr; } /*NOTREACHED*/ break;
case 5:
# line 139 "grammar.y"
{ gen_and(yypvt[-2].blk.b, yypvt[-0].blk.b); yyval.blk = yypvt[-0].blk; } /*NOTREACHED*/ break;
case 6:
# line 140 "grammar.y"
{ gen_and(yypvt[-2].blk.b, yypvt[-0].blk.b); yyval.blk = yypvt[-0].blk; } /*NOTREACHED*/ break;
case 7:
# line 141 "grammar.y"
{ gen_or(yypvt[-2].blk.b, yypvt[-0].blk.b); yyval.blk = yypvt[-0].blk; } /*NOTREACHED*/ break;
case 8:
# line 142 "grammar.y"
{ gen_or(yypvt[-2].blk.b, yypvt[-0].blk.b); yyval.blk = yypvt[-0].blk; } /*NOTREACHED*/ break;
case 9:
# line 144 "grammar.y"
{ yyval.blk = yypvt[-1].blk; } /*NOTREACHED*/ break;
case 10:
# line 146 "grammar.y"
{ yyval.blk = yypvt[-1].blk; } /*NOTREACHED*/ break;
case 12:
# line 149 "grammar.y"
{ yyval.blk.b = gen_ncode(NULL, (bpf_u_int32)yypvt[-0].i,
						   yyval.blk.q = yypvt[-1].blk.q); } /*NOTREACHED*/ break;
case 13:
# line 151 "grammar.y"
{ yyval.blk = yypvt[-1].blk; } /*NOTREACHED*/ break;
case 14:
# line 153 "grammar.y"
{ yyval.blk.b = gen_scode(yypvt[-0].s, yyval.blk.q = yypvt[-1].blk.q); } /*NOTREACHED*/ break;
case 15:
# line 154 "grammar.y"
{ yyval.blk.b = gen_mcode(yypvt[-2].s, NULL, yypvt[-0].i,
				    yyval.blk.q = yypvt[-3].blk.q); } /*NOTREACHED*/ break;
case 16:
# line 156 "grammar.y"
{ yyval.blk.b = gen_mcode(yypvt[-2].s, yypvt[-0].s, 0,
				    yyval.blk.q = yypvt[-3].blk.q); } /*NOTREACHED*/ break;
case 17:
# line 158 "grammar.y"
{
				  /* Decide how to parse HID based on proto */
				  yyval.blk.q = yypvt[-1].blk.q;
				  switch (yyval.blk.q.proto) {
				  case Q_DECNET:
					yyval.blk.b = gen_ncode(yypvt[-0].s, 0, yyval.blk.q);
					break;
				  default:
					yyval.blk.b = gen_ncode(yypvt[-0].s, 0, yyval.blk.q);
					break;
				  }
				} /*NOTREACHED*/ break;
case 18:
# line 170 "grammar.y"
{ yyval.blk.b = gen_ecode(yypvt[-0].e, yyval.blk.q = yypvt[-1].blk.q); } /*NOTREACHED*/ break;
case 19:
# line 171 "grammar.y"
{ gen_not(yypvt[-0].blk.b); yyval.blk = yypvt[-0].blk; } /*NOTREACHED*/ break;
case 20:
# line 173 "grammar.y"
{ yyval.blk = yypvt[-1].blk; } /*NOTREACHED*/ break;
case 21:
# line 175 "grammar.y"
{ yyval.blk = yypvt[-1].blk; } /*NOTREACHED*/ break;
case 23:
# line 178 "grammar.y"
{ gen_and(yypvt[-2].blk.b, yypvt[-0].blk.b); yyval.blk = yypvt[-0].blk; } /*NOTREACHED*/ break;
case 24:
# line 179 "grammar.y"
{ gen_or(yypvt[-2].blk.b, yypvt[-0].blk.b); yyval.blk = yypvt[-0].blk; } /*NOTREACHED*/ break;
case 25:
# line 181 "grammar.y"
{ yyval.blk.b = gen_ncode(NULL, (bpf_u_int32)yypvt[-0].i,
						   yyval.blk.q = yypvt[-1].blk.q); } /*NOTREACHED*/ break;
case 28:
# line 186 "grammar.y"
{ gen_not(yypvt[-0].blk.b); yyval.blk = yypvt[-0].blk; } /*NOTREACHED*/ break;
case 29:
# line 188 "grammar.y"
{ QSET(yyval.blk.q, yypvt[-2].i, yypvt[-1].i, yypvt[-0].i); } /*NOTREACHED*/ break;
case 30:
# line 189 "grammar.y"
{ QSET(yyval.blk.q, yypvt[-1].i, yypvt[-0].i, Q_DEFAULT); } /*NOTREACHED*/ break;
case 31:
# line 190 "grammar.y"
{ QSET(yyval.blk.q, yypvt[-1].i, Q_DEFAULT, yypvt[-0].i); } /*NOTREACHED*/ break;
case 32:
# line 191 "grammar.y"
{ QSET(yyval.blk.q, yypvt[-1].i, Q_DEFAULT, Q_PROTO); } /*NOTREACHED*/ break;
case 33:
# line 192 "grammar.y"
{ QSET(yyval.blk.q, yypvt[-1].i, Q_DEFAULT, yypvt[-0].i); } /*NOTREACHED*/ break;
case 34:
# line 194 "grammar.y"
{ yyval.blk = yypvt[-0].blk; } /*NOTREACHED*/ break;
case 35:
# line 195 "grammar.y"
{ yyval.blk.b = yypvt[-1].blk.b; yyval.blk.q = yypvt[-2].blk.q; } /*NOTREACHED*/ break;
case 36:
# line 196 "grammar.y"
{ yyval.blk.b = gen_proto_abbrev(yypvt[-0].i); yyval.blk.q = qerr; } /*NOTREACHED*/ break;
case 37:
# line 197 "grammar.y"
{ yyval.blk.b = gen_relation(yypvt[-1].i, yypvt[-2].a, yypvt[-0].a, 0);
				  yyval.blk.q = qerr; } /*NOTREACHED*/ break;
case 38:
# line 199 "grammar.y"
{ yyval.blk.b = gen_relation(yypvt[-1].i, yypvt[-2].a, yypvt[-0].a, 1);
				  yyval.blk.q = qerr; } /*NOTREACHED*/ break;
case 39:
# line 201 "grammar.y"
{ yyval.blk.b = yypvt[-0].rblk; yyval.blk.q = qerr; } /*NOTREACHED*/ break;
case 41:
# line 205 "grammar.y"
{ yyval.i = Q_DEFAULT; } /*NOTREACHED*/ break;
case 42:
# line 208 "grammar.y"
{ yyval.i = Q_SRC; } /*NOTREACHED*/ break;
case 43:
# line 209 "grammar.y"
{ yyval.i = Q_DST; } /*NOTREACHED*/ break;
case 44:
# line 210 "grammar.y"
{ yyval.i = Q_OR; } /*NOTREACHED*/ break;
case 45:
# line 211 "grammar.y"
{ yyval.i = Q_OR; } /*NOTREACHED*/ break;
case 46:
# line 212 "grammar.y"
{ yyval.i = Q_AND; } /*NOTREACHED*/ break;
case 47:
# line 213 "grammar.y"
{ yyval.i = Q_AND; } /*NOTREACHED*/ break;
case 48:
# line 216 "grammar.y"
{ yyval.i = Q_HOST; } /*NOTREACHED*/ break;
case 49:
# line 217 "grammar.y"
{ yyval.i = Q_NET; } /*NOTREACHED*/ break;
case 50:
# line 218 "grammar.y"
{ yyval.i = Q_PORT; } /*NOTREACHED*/ break;
case 51:
# line 221 "grammar.y"
{ yyval.i = Q_GATEWAY; } /*NOTREACHED*/ break;
case 52:
# line 223 "grammar.y"
{ yyval.i = Q_LINK; } /*NOTREACHED*/ break;
case 53:
# line 224 "grammar.y"
{ yyval.i = Q_IP; } /*NOTREACHED*/ break;
case 54:
# line 225 "grammar.y"
{ yyval.i = Q_ARP; } /*NOTREACHED*/ break;
case 55:
# line 226 "grammar.y"
{ yyval.i = Q_RARP; } /*NOTREACHED*/ break;
case 56:
# line 227 "grammar.y"
{ yyval.i = Q_TCP; } /*NOTREACHED*/ break;
case 57:
# line 228 "grammar.y"
{ yyval.i = Q_UDP; } /*NOTREACHED*/ break;
case 58:
# line 229 "grammar.y"
{ yyval.i = Q_ICMP; } /*NOTREACHED*/ break;
case 59:
# line 230 "grammar.y"
{ yyval.i = Q_IGMP; } /*NOTREACHED*/ break;
case 60:
# line 231 "grammar.y"
{ yyval.i = Q_IGRP; } /*NOTREACHED*/ break;
case 61:
# line 232 "grammar.y"
{ yyval.i = Q_ATALK; } /*NOTREACHED*/ break;
case 62:
# line 233 "grammar.y"
{ yyval.i = Q_DECNET; } /*NOTREACHED*/ break;
case 63:
# line 234 "grammar.y"
{ yyval.i = Q_LAT; } /*NOTREACHED*/ break;
case 64:
# line 235 "grammar.y"
{ yyval.i = Q_SCA; } /*NOTREACHED*/ break;
case 65:
# line 236 "grammar.y"
{ yyval.i = Q_MOPDL; } /*NOTREACHED*/ break;
case 66:
# line 237 "grammar.y"
{ yyval.i = Q_MOPRC; } /*NOTREACHED*/ break;
case 67:
# line 239 "grammar.y"
{ yyval.rblk = gen_broadcast(yypvt[-1].i); } /*NOTREACHED*/ break;
case 68:
# line 240 "grammar.y"
{ yyval.rblk = gen_multicast(yypvt[-1].i); } /*NOTREACHED*/ break;
case 69:
# line 241 "grammar.y"
{ yyval.rblk = gen_less(yypvt[-0].i); } /*NOTREACHED*/ break;
case 70:
# line 242 "grammar.y"
{ yyval.rblk = gen_greater(yypvt[-0].i); } /*NOTREACHED*/ break;
case 71:
# line 243 "grammar.y"
{ yyval.rblk = gen_byteop(yypvt[-1].i, yypvt[-2].i, yypvt[-0].i); } /*NOTREACHED*/ break;
case 72:
# line 244 "grammar.y"
{ yyval.rblk = gen_inbound(0); } /*NOTREACHED*/ break;
case 73:
# line 245 "grammar.y"
{ yyval.rblk = gen_inbound(1); } /*NOTREACHED*/ break;
case 74:
# line 247 "grammar.y"
{ yyval.i = BPF_JGT; } /*NOTREACHED*/ break;
case 75:
# line 248 "grammar.y"
{ yyval.i = BPF_JGE; } /*NOTREACHED*/ break;
case 76:
# line 249 "grammar.y"
{ yyval.i = BPF_JEQ; } /*NOTREACHED*/ break;
case 77:
# line 251 "grammar.y"
{ yyval.i = BPF_JGT; } /*NOTREACHED*/ break;
case 78:
# line 252 "grammar.y"
{ yyval.i = BPF_JGE; } /*NOTREACHED*/ break;
case 79:
# line 253 "grammar.y"
{ yyval.i = BPF_JEQ; } /*NOTREACHED*/ break;
case 80:
# line 255 "grammar.y"
{ yyval.a = gen_loadi(yypvt[-0].i); } /*NOTREACHED*/ break;
case 82:
# line 258 "grammar.y"
{ yyval.a = gen_load(yypvt[-3].i, yypvt[-1].a, 1); } /*NOTREACHED*/ break;
case 83:
# line 259 "grammar.y"
{ yyval.a = gen_load(yypvt[-5].i, yypvt[-3].a, yypvt[-1].i); } /*NOTREACHED*/ break;
case 84:
# line 260 "grammar.y"
{ yyval.a = gen_arth(BPF_ADD, yypvt[-2].a, yypvt[-0].a); } /*NOTREACHED*/ break;
case 85:
# line 261 "grammar.y"
{ yyval.a = gen_arth(BPF_SUB, yypvt[-2].a, yypvt[-0].a); } /*NOTREACHED*/ break;
case 86:
# line 262 "grammar.y"
{ yyval.a = gen_arth(BPF_MUL, yypvt[-2].a, yypvt[-0].a); } /*NOTREACHED*/ break;
case 87:
# line 263 "grammar.y"
{ yyval.a = gen_arth(BPF_DIV, yypvt[-2].a, yypvt[-0].a); } /*NOTREACHED*/ break;
case 88:
# line 264 "grammar.y"
{ yyval.a = gen_arth(BPF_AND, yypvt[-2].a, yypvt[-0].a); } /*NOTREACHED*/ break;
case 89:
# line 265 "grammar.y"
{ yyval.a = gen_arth(BPF_OR, yypvt[-2].a, yypvt[-0].a); } /*NOTREACHED*/ break;
case 90:
# line 266 "grammar.y"
{ yyval.a = gen_arth(BPF_LSH, yypvt[-2].a, yypvt[-0].a); } /*NOTREACHED*/ break;
case 91:
# line 267 "grammar.y"
{ yyval.a = gen_arth(BPF_RSH, yypvt[-2].a, yypvt[-0].a); } /*NOTREACHED*/ break;
case 92:
# line 268 "grammar.y"
{ yyval.a = gen_neg(yypvt[-0].a); } /*NOTREACHED*/ break;
case 93:
# line 269 "grammar.y"
{ yyval.a = yypvt[-1].a; } /*NOTREACHED*/ break;
case 94:
# line 270 "grammar.y"
{ yyval.a = gen_loadlen(); } /*NOTREACHED*/ break;
case 95:
# line 272 "grammar.y"
{ yyval.i = '&'; } /*NOTREACHED*/ break;
case 96:
# line 273 "grammar.y"
{ yyval.i = '|'; } /*NOTREACHED*/ break;
case 97:
# line 274 "grammar.y"
{ yyval.i = '<'; } /*NOTREACHED*/ break;
case 98:
# line 275 "grammar.y"
{ yyval.i = '>'; } /*NOTREACHED*/ break;
case 99:
# line 276 "grammar.y"
{ yyval.i = '='; } /*NOTREACHED*/ break;
case 101:
# line 279 "grammar.y"
{ yyval.i = yypvt[-1].i; } /*NOTREACHED*/ break;
}


	goto yystack;		/* reset registers in driver code */
}
