/*
 * This file is a part of the gnetsentry project.
 * Copyright (C) 1998 Martin Gall
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
/*
 *
 */

#include "a.h"
#include "typ_msg.h"
#include "layeri.h"
#include "typ_iptos.h"

t_assoc			iptos_assocs[] = 
{
  {"lowdelay",		(VOID_PTR)IPTOS_LOWDELAY},
  {"throughput",	(VOID_PTR)IPTOS_THROUGHPUT},
  {"reliability",	(VOID_PTR)IPTOS_RELIABILITY},
  {NULL,		NULL}
};

t_status		iptos_msg(msg,arg1,arg2)
int			msg;
VOID_PTR		arg1;
VOID_PTR		arg2;
{
  switch (msg)
    {
    case TYP_NAME:
      {
	TYP_NAME_ARGS(unused,name);
	
	(*name) = "iptos";
	return (0);
      }
    case TYP_EXTRACT:
      {
	TYP_EXTRACT_ARGS(ed,bs);
	unsigned char	iptos;
	t_assoc		*assoc;

	if (ed->b.len < sizeof (iptos))
	  return (-ERR_TRUNC);
	bcopy(ed->b.buf,(char *)(&iptos),sizeof (iptos));
	if ((assoc = assoc_str_int_from_right(iptos_assocs,iptos)) == NULL)
	  return (ucharint_msg(msg,arg1,arg2));
	else
	  return (str_cat_str(bs->str,bs->max_len,assoc->left));
      }
    }
  return (-ERR_NOMETHOD);
}	
