/*
 * This file is a part of the gnetsentry project.
 * Copyright (C) 1998 Martin Gall
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
/*
 *
 */

#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include "a.h"
#include "typ_msg.h"
#include "layeri.h"

t_status		inaddr_msg(msg,arg1,arg2)
int			msg;
VOID_PTR		arg1;
VOID_PTR		arg2;
{
  switch (msg)
    {
    case TYP_NAME:
      {
	TYP_NAME_ARGS(unused,name);
		
	(*name) = "inaddr";
	return (0);
      }
    case TYP_EXTRACT:
      {
	TYP_EXTRACT_ARGS(ed,bs);
	struct in_addr	inaddr;

	if (ed->b.len < sizeof (inaddr))
	  return (-ERR_TRUNC);
	bcopy(ed->b.buf,(char *)(&inaddr),sizeof (struct in_addr));
	return (inaddr_to_str(&inaddr,bs->str,bs->max_len,FALSE));
      }
    case TYP_INSERT:
      {
	TYP_INSERT_ARGS(ed,str);
	struct in_addr	inaddr;
	t_status	status;	

	if (ed->b.len < sizeof (inaddr))
	  return (-ERR_TRUNC);
	if ((status = inaddr_from_str(str,&inaddr,FALSE)) < 0)
	  return (status);
	bcopy((char *)(&inaddr),ed->b.buf,sizeof (struct in_addr));
	return (0);
      }
    }
  return (-ERR_NOMETHOD);
}	

t_status		inaddr_resolved_msg(msg,arg1,arg2)
int			msg;
VOID_PTR		arg1;
VOID_PTR		arg2;
{
  switch (msg)
    {
    case TYP_NAME:
      {
	TYP_NAME_ARGS(unused,name);
		
	(*name) = "inaddr_resolved";
	return (0);
      }
    case TYP_EXTRACT:
      {
	TYP_EXTRACT_ARGS(ed,bs);
	struct in_addr	inaddr;

	if (ed->b.len < sizeof (inaddr))
	  return (-ERR_TRUNC);
	bcopy(ed->b.buf,(char *)(&inaddr),sizeof (struct in_addr));
	return (inaddr_to_str(&inaddr,bs->str,bs->max_len,TRUE));
      }
    case TYP_INSERT:
      {
	TYP_INSERT_ARGS(ed,str);
	struct in_addr	inaddr;
	t_status	status;	

	if (ed->b.len < sizeof (inaddr))
	  return (-ERR_TRUNC);
	if ((status = inaddr_from_str(str,&inaddr,TRUE)) < 0)
	  return (status);
	bcopy((char *)(&inaddr),ed->b.buf,sizeof (struct in_addr));
	return (0);
      }
    }
  return (-ERR_NOMETHOD);
}	
