/*
 * This file is a part of the gnetsentry project.
 * Copyright (C) 1998 Martin Gall
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
/*
 *
 */

#include "a.h"
#include "typ_msg.h"
#include "layeri.h"
#include "typ_icmptype.h"

t_assoc				icmptype_assocs[] =
{
  {"echo_reply",		(VOID_PTR)ICMP_ECHOREPLY},
  {"unreachable",		(VOID_PTR)ICMP_UNREACH},
  {"source_quench",		(VOID_PTR)ICMP_SOURCEQUENCH},
  {"redirect",			(VOID_PTR)ICMP_REDIRECT},
  {"echo_request",		(VOID_PTR)ICMP_ECHO},
  {"router_advertisement",	(VOID_PTR)9},
  {"router_selection",		(VOID_PTR)10},
  {"time_exceed",		(VOID_PTR)ICMP_TIMXCEED},
  {"param_problem",		(VOID_PTR)ICMP_PARAMPROB},
  {"timestamp",			(VOID_PTR)ICMP_TSTAMP},
  {"timestamp_reply",		(VOID_PTR)ICMP_TSTAMPREPLY},
  {"info_request",		(VOID_PTR)ICMP_IREQ},
  {"info_reply",		(VOID_PTR)ICMP_IREQREPLY},
  {"mask_request",		(VOID_PTR)ICMP_MASKREQ},
  {"mask_reply",		(VOID_PTR)ICMP_MASKREPLY},
  {NULL,			NULL},
};

t_status		icmptype_msg(msg,arg1,arg2)
int			msg;
VOID_PTR		arg1;
VOID_PTR		arg2;
{
  switch (msg)
    {
    case TYP_NAME:
      {
	TYP_NAME_ARGS(unused,name);
	
	(*name) = "icmptype";
	return (0);
      }
    case TYP_EXTRACT:
      {
	TYP_EXTRACT_ARGS(ed,bs);
	unsigned short	icmptype;
	t_assoc		*assoc;

	if (ed->b.len < sizeof (icmptype))
	  return (-ERR_TRUNC);
	bcopy(ed->b.buf,(char *)(&icmptype),sizeof (icmptype));
	if ((assoc = assoc_str_int_from_right(icmptype_assocs,
					      icmptype)) == NULL)
	  return (nushort_msg(msg,arg1,arg2));
	else
	  return (str_cat_str(bs->str,bs->max_len,assoc->left));
      }
    }
  return (-ERR_NOMETHOD);
}	
