/*
 * This file is a part of the gnetsentry project.
 * Copyright (C) 1998 Martin Gall
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
/*
 *
 */

#include "a.h"
#include "lay_ether.h"
#include "typ_msg.h"
#include "typ_ethaddr.h"
#include "layeri.h"

t_status			etheraddr_from_str(ea,str)
t_ether_addr			*ea;
char				*str;
{
  int				nmatch;
  unsigned int			o[6];
  int				i;
  
  nmatch = 0;
  if (index(str,'-'))
    nmatch = sscanf(str,"%x-%x-%x-%x-%x-%x",
		    &(o[0]),&(o[1]),&(o[2]),&(o[3]),&(o[4]),&(o[5]));
  else
    if (index(str,':'))
      nmatch = sscanf(str,"%x:%x:%x:%x:%x:%x",
		      &(o[0]),&(o[1]),&(o[2]),&(o[3]),&(o[4]),&(o[5]));
  if (nmatch != sizeof (t_ether_addr))
    return (-ERR_BADFMT);
  i = 0;
  while (i < sizeof (t_ether_addr))
    {
      ea->o[i] = o[i];
      i++;
    }
  return (0);
}

t_status			etheraddr_to_str(ea,str,max_len)
t_ether_addr			*ea;
char				*str;
int				max_len;
{
  unsigned char			o[6];
  int				i;
  t_status			status;

  i = 0;
  while (i < sizeof (t_ether_addr))
    {
      o[i] = ea->o[i];
      i++;
    }
  return (str_cat_fmt_va(str,max_len,
			 "%02x:%02x:%02x:%02x:%02x:%02x",
			 (unsigned char)o[0],
			 (unsigned char)o[1],
			 (unsigned char)o[2],
			 (unsigned char)o[3],			 
			 (unsigned char)o[4],
			 (unsigned char)o[5]));
}

t_status		etheraddr_msg(msg,arg1,arg2)
int			msg;
VOID_PTR		arg1;
VOID_PTR		arg2;
{
  switch (msg)
    {
    case TYP_NAME:
      {
	TYP_NAME_ARGS(unused,name);
	
	(*name) = "etheraddr";
	return (0);
      }
    case TYP_EXTRACT:
      {
	TYP_EXTRACT_ARGS(ed,bs);
	t_ether_addr	etheraddr;

	if (ed->b.len < sizeof (etheraddr))
	  return (-ERR_TRUNC);
	bcopy(ed->b.buf,(char *)(&etheraddr),sizeof (etheraddr));
	return (etheraddr_to_str(&etheraddr,bs->str,bs->max_len));
      }
    case TYP_INSERT:
      {
	TYP_INSERT_ARGS(ed,str);
	t_ether_addr	etheraddr;
	t_status	status;	

	if (ed->b.len < sizeof (etheraddr))
	  return (-ERR_TRUNC);
	if ((status = etheraddr_from_str(&etheraddr,str)) < 0)
	  return (status);
	bcopy((char *)(&etheraddr),ed->b.buf,sizeof (t_ether_addr));
	return (0);
      }
    }
  return (-ERR_NOMETHOD);
}	
