/*
 * This file is a part of the gnetsentry project.
 * Copyright (C) 1998 Martin Gall
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
/*
 *
 */

#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include "miscsock.h"

/* AF_INET: HOST[:PORT[:PROTO]], I.E.: SATURN:TELNET:TCP */
t_status		sock_str_to_sin(str,sin,len,resolve)
char			*str;
struct sockaddr_in	*sin;
int			*len;
t_boolean		resolve;
{
  char			*tmp;
  char			*tmp2;
  char			*host;
  char			*port;
  char			*proto;
  t_status		status;
  struct in_addr	inaddr;

  if ((tmp = index(str,':')) == NULL)
    {
      host = str;
      port = "0";
      proto = "tcp";
    }
  else
    {
      *tmp++ = 0;
      if ((tmp2 = index(tmp,':')) == NULL)
	{
	  proto = "tcp";
	  host = str;
	  port = tmp;
	}
      else
	{
	  *tmp2++ = 0;
	  host = str;
	  port = tmp;
	  proto = tmp2;
	}
    }
  sin->sin_family = AF_INET;
  sin->sin_port = htons(port_from_str(port,proto,resolve));
  if ((status = inaddr_from_str(str,&inaddr,resolve)) < 0)
    return (status);
  bcopy((char *)(&inaddr),(char *)(&(sin->sin_addr)),sizeof (inaddr));
  (*len) = sizeof (struct sockaddr_in);
  return (0);
}

t_status		sock_str_to_sa(family,str,sa,len,resolve)
int			family;
char			*str;
struct sockaddr		*sa;
int			*len;
t_boolean		resolve;
{
  if (family == AF_INET)
    return (sock_str_to_sin(str,
			    (struct sockaddr_in *)sa,
			    len,
			    resolve));
  return (-ERR_NI);
}	

t_status		sock_sin_to_str(sin,str,max_len,resolve)
struct sockaddr_in	*sin;
char			*str;
int			max_len;
t_boolean		resolve;
{
  t_status		status;

  if ((status = inaddr_to_str(&(sin->sin_addr),str,max_len,resolve)) < 0)
    return (status);
  if ((status = str_cat_char(str,max_len,':')) < 0)
    return (status);
  if (port_to_str(ntohs(sin->sin_port),"tcp",str,max_len,resolve) < 0)
    return (status);
  return (0);
}

t_status		sock_sa_to_str(sa,str,max_len,resolve)
struct sockaddr		*sa;
char			*str;
int			max_len;
t_boolean		resolve;
{
  if (sa->sa_family == AF_INET)
    return (sock_sin_to_str((struct sockaddr_in *)sa,str,max_len,resolve));
  return (-ERR_NI);
}
