/*
 * This file is a part of the gnetsentry project.
 * Copyright (C) 1998 Martin Gall
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
/*
 *
 */

#include "layer.h"
#include "lay_msg.h"

char			*lay_msg_list[] =
{
  "Message 0",					/* 0	*/
  "Undefined message",				/* 1	*/
  "Name yourself",				/* 2	*/
  "Get offset to sub layer",			/* 3	*/
  "Get sub layer",				/* 4	*/
  "Checksum",					/* 5	*/
  "Get field",					/* 6	*/
  "Set field",					/* 7	*/
}; 

t_status		lay_msg(mp,msg,arg1,arg2)
t_msg_proc		mp;
int			msg;
VOID_PTR		arg1;
VOID_PTR		arg2;
{
#ifdef DEBUG
  if (LAYER_VERB(VERB_LAY_MSG))
    {
      t_status		status;
      char		*name;
      
      status = mp(LAY_NAME,
		  NULL,
		  &name);
      assert(status == 0);
      status = mp(msg,arg1,arg2);
      err_print(-status,"lay: %s::%s(%p,%p) = ",
		name,
		lay_msg_list[msg],
		arg1,
		arg2);
      return (status);
    }
  else
#endif
    return (mp(msg,arg1,arg2));
}
