/*
 * This file is a part of the gnetsentry project.
 * Copyright (C) 1998 Martin Gall
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
/*
 *
 */

#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include "layer.h"
#include "layeri.h"
#include "miscinet.h"
#include "lay_ip.h"
#include "lay_icmp.h"
#include "lay_udp.h"
#include "lay_tcp.h"
#include "lay_data.h"
#include "typ_char.h"
#include "typ_short.h"
#include "typ_inaddr.h"
#include "typ_ipproto.h"
#include "typ_iptos.h"

/* I'M SURE YOU'LL FIND A BEST WAY TO PERFORM A PORTABLE CHECKSUM! */
unsigned short		in_cksum(buf,nwords)
unsigned short		*buf;
int			nwords;
{
   unsigned long	sum;
   
   sum = 0;
   while (nwords > 0)
     {
       sum += htons(*buf++);
       nwords--;
     }
   sum = (sum >> 16) + (sum & 0xffff);
   sum += (sum >> 16);
   return ((unsigned short)(~sum));
}

VOID_FUNC		ip_compute_sum(ip)
t_ip			*ip;
{
   ip->ip_sum = 0;
   ip->ip_sum = htons(in_cksum((unsigned short *)ip,IP_HLEN >> 1));  
}

VOID_FUNC		ip_set_v(ip,v)
t_ip			*ip;
int			v;
{
#ifndef HAVE_BITFIELDS
  int			c;

  c = v;
  c <<= 4;
  ip->ip_vhl &= 0x0f;
  ip->ip_vhl |= c;
#else
  ip->ip_v = v;
#endif
}

int			ip_get_v(ip)
t_ip			*ip;
{
#ifndef HAVE_BITFIELDS
  char			c;
  
  c = ip->ip_vhl;
# ifndef WORDS_BIGENDIAN
  c >>= 4;
# endif
  return (c);
#else
  return (ip->ip_v);
#endif
}

VOID_FUNC		ip_set_hl(ip,hl)
t_ip			*ip;
int			hl;
{
#ifndef HAVE_BITFIELDS
  int			c;

  c = hl;
  ip->ip_vhl &= 0xf0;
  ip->ip_vhl |= c;
#else
  ip->ip_hl = hl;
#endif
}

int			ip_get_hl(ip)
t_ip			*ip;
{
#ifndef HAVE_BITFIELDS
  int			c;
  
  c = ip->ip_vhl;
  c &= 0x0f;
  return (c);
#else
  return (ip->ip_hl);
#endif
}

VOID_FUNC		ip_set_tos(ip,tos)
t_ip			*ip;
int			tos;
{
  ip->ip_tos = (u_char)tos;
}

int			ip_get_tos(ip)
t_ip			*ip;
{
  return (ip->ip_tos);
}

int			ip_get_len(ip)
t_ip			*ip;
{
  return (ntohs(ip->ip_len));
}

#ifndef WITH_DATA_INTEGRITY
VOID_FUNC		ip_set_len(ip,len)
t_ip			*ip;
int			len;
{
  ip->ip_len = (htons(len));
}
#endif

VOID_FUNC		ip_set_id(ip,id)
t_ip			*ip;
int			id;
{
  ip->ip_id = htons((u_short)id);
}

int			ip_get_id(ip)
t_ip			*ip;
{
  return (ntohs(ip->ip_id));
}

VOID_FUNC		ip_set_off(ip,off)
t_ip			*ip;
int			off;
{
  ip->ip_off = htons((u_short)off);
}

int			ip_get_off(ip)
t_ip			*ip;
{
  return (ntohs(ip->ip_off));
}

VOID_FUNC		ip_set_ttl(ip,ttl)
t_ip			*ip;
int			ttl;
{
  ip->ip_ttl = (u_char)ttl;
}

int			ip_get_ttl(ip)
t_ip			*ip;
{
  return (ip->ip_ttl);
}

VOID_FUNC		ip_set_p(ip,p)
t_ip			*ip;
int			p;
{
  ip->ip_p = (u_char)p;
}

int			ip_get_p(ip)
t_ip			*ip;
{
  return (ip->ip_p);
}

VOID_FUNC		ip_set_sum(ip,sum)
t_ip			*ip;
int			sum;
{
  ip->ip_sum = htons((u_short)(sum));
}

int			ip_get_sum(ip)
t_ip			*ip;
{
  return (ntohs(ip->ip_sum));
}

VOID_FUNC		ip_set_src(ip,src)
t_ip			*ip;
t_in_addr		*src;
{
  bcopy((char *)src,(char *)(&(ip->ip_src)),sizeof (struct in_addr));
}

VOID_FUNC		ip_get_src(ip,src)
t_ip			*ip;
t_in_addr		*src;
{
  bcopy((char *)(&(ip->ip_src)),(char *)src,sizeof (struct in_addr));
}

VOID_FUNC		ip_set_dst(ip,dst)
t_ip			*ip;
t_in_addr		*dst;
{
  bcopy((char *)dst,(char *)(&(ip->ip_dst)),sizeof (struct in_addr));
}

VOID_FUNC		ip_get_dst(ip,dst)
t_ip			*ip;
t_in_addr		*dst;
{
  bcopy((char *)(&(ip->ip_dst)),(char *)dst,sizeof (struct in_addr));
}

t_status		ip_off(buf,len,off)
char			*buf;
int			len;
off_t			*off;
{
  t_ip			*ip;

  ip = (t_ip *)buf;
  LAYER_IP_CHECK(ip,buf,len);
  (*off) = ip_get_hl(ip) * 4;
  return (0);
}

t_status		ip_sub(buf,len,sub_mp)
char			*buf;
int			len;
t_msg_proc		*sub_mp;
{
  t_ip			*ip;

  ip = (t_ip *)buf;
  LAYER_IP_CHECK(ip,buf,len);
  switch (ip_get_p(ip))
    {
    case IP_PROTO_ICMP:
      (*sub_mp) = &icmp_msg;
      return (0);
    case IP_PROTO_UDP:
      (*sub_mp) = &udp_msg;
      return (0);
    case IP_PROTO_TCP:
      (*sub_mp) = &tcp_msg;
      return (0);
    }
  (*sub_mp) = &data_msg;
  return (0);
}

t_status		ip_sum(buf,len,up_buf,up_len)
char			*buf;
int			len;
char			*up_buf;
int			up_len;
{
  t_ip			*ip;

  ip = (t_ip *)buf;
  LAYER_IP_CHECK(ip,buf,len);
  ip_compute_sum(ip);
  return (0);
}

t_field				ip_fields[] = 
{
  {"hl",	0,			charbit_msg,	(VOID_PTR)CHARBIT_0F},
  {"v",		0,			charbit_msg,	(VOID_PTR)CHARBIT_F0},
  {"tos",	OFFSET(t_ip *,ip_tos),	ucharint_msg,		NULL},
  {"Tos",	OFFSET(t_ip *,ip_tos),	iptos_msg,		NULL},
  {"len",	OFFSET(t_ip *,ip_len),	nushort_msg,		NULL},
  {"id",	OFFSET(t_ip *,ip_id),	nushort_msg,		NULL},
  {"off",	OFFSET(t_ip *,ip_off),	nushort_msg,		NULL},
  {"ttl",	OFFSET(t_ip *,ip_ttl),	ucharint_msg,		NULL},
  {"p",		OFFSET(t_ip *,ip_p),	ucharint_msg,		NULL},
  {"P",		OFFSET(t_ip *,ip_p),	ipproto_msg,		NULL},
  {"sum",	OFFSET(t_ip *,ip_sum),	nushort_msg,		NULL},
  {"src",	OFFSET(t_ip *,ip_src),	inaddr_msg,		NULL},
  {"Src",	OFFSET(t_ip *,ip_src),	inaddr_resolved_msg,	NULL},
  {"dst",	OFFSET(t_ip *,ip_dst),	inaddr_msg,		NULL},
  {"Dst",	OFFSET(t_ip *,ip_dst),	inaddr_resolved_msg,	NULL}
};

t_status			ip_msg(msg,arg1,arg2)
int				msg;
VOID_PTR			arg1;
VOID_PTR			arg2;
{
  t_status			status;

  switch (msg)
    {
    case LAY_NAME:
      {
	LAY_NAME_ARGS(unused,name);
	
	(*name) = "ip";
	return (0);
      }
    case LAY_OFF:
      {
	LAY_OFF_ARGS(b,off);
	
	return (ip_off(b->buf,b->len,off));
      }
    case LAY_SUB:
      {
	LAY_SUB_ARGS(b,mp);
	
	return (ip_sub(b->buf,b->len,mp));
      }
    case LAY_SUM:
      {
	LAY_SUM_ARGS(sd,unused);
	
	return (ip_sum(sd->b.buf,
		       sd->b.len,
		       sd->up.buf,
		       sd->up.len));
      }
    case LAY_GET_FIELD:
      {
	LAY_GET_FIELD_ARGS(gfd,bs);
	int			i;
	t_field			*field;

	field = NULL;
	i = 0;
	while (i < ARRAY_COUNT(ip_fields))
	  {
	    if (!strcmp(ip_fields[i].name,gfd->field))
	      field = ip_fields + i; 
	    i++;
	  }
	if (!field)
	  return (-ERR_NOENT);
	return (get_field_to_str(gfd->b.buf,
				 gfd->b.len,
				 field,
				 bs->str,
				 bs->max_len));
      }
    case LAY_SET_FIELD:
      {
	LAY_SET_FIELD_ARGS(gfd,str);
	int			i;
	t_field			*field;

	field = NULL;
	i = 0;
	while (i < ARRAY_COUNT(ip_fields))
	  {
	    if (!strcmp(ip_fields[i].name,gfd->field))
	      field = ip_fields + i; 
	    i++;
	  }
	if (!field)
	  return (-ERR_NOENT);
	return (set_field_from_str(gfd->b.buf,
				   gfd->b.len,
				   field,
				   str));
      }
    }
  return (-ERR_NOMETHOD);
}
