/*
 * This file is a part of the gnetsentry project.
 * Copyright (C) 1998 Martin Gall
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
/*
 *
 */

#include "layeri.h"
#include "lay_icmp.h"
#include "lay_ip.h"
#include "lay_data.h"
#include "typ_short.h"
#include "typ_icmptype.h"

int		icmp_compute_sum(ip,icmp)
t_ip		*ip;
t_icmp		*icmp;
{
  int		datalen;

  icmp->icmp_cksum = 0;
  datalen = ip_get_len(ip) - IP_HLEN;
  icmp->icmp_cksum = htons(in_cksum((unsigned short *)icmp,datalen >> 1));
}

VOID_FUNC	icmp_set_proto(ip)
t_ip		*ip;
{
  ip_set_p(ip,IP_PROTO_ICMP);
}

VOID_FUNC	icmp_set_type(icmp,type)
t_icmp		*icmp;
int		type;
{
  icmp->icmp_type = type;
}

int		icmp_get_type(icmp)
t_icmp		*icmp;
{
  return (icmp->icmp_type);
}

VOID_FUNC	icmp_set_code(icmp,code)
t_icmp		*icmp;
int		code;
{
  icmp->icmp_code = code;
}

int		icmp_get_code(icmp)
t_icmp		*icmp;
{
  return (icmp->icmp_code);
}

VOID_FUNC	icmp_set_cksum(icmp,sum)
t_icmp		*icmp;
int		sum;
{
  icmp->icmp_cksum = htons(sum);
}

int		icmp_get_cksum(icmp)
t_icmp		*icmp;
{
  return (ntohs(icmp->icmp_cksum));
}	

int		icmp_sub(buf,len,sub_mp)
char		*buf;
int		len;
t_msg_proc	*sub_mp;
{
  (*sub_mp) = &data_msg;
  return (0);
}

int		icmp_sum(buf,len,up_buf,up_len)
char		*buf;
int		len;
char		*up_buf;
int		up_len;
{
  t_icmp	*icmp;
  t_ip		*ip;

  LAYER_ICMP_CHECK(icmp,buf,len);
  LAYER_IP_CHECK(ip,up_buf,up_len);
  icmp_compute_sum(ip,icmp);
  return (0);
}

t_field				icmp_fields[] = 
{
  {"type",	OFFSET(t_icmp *,icmp_type),	nushort_msg,		NULL},
  {"Type",	OFFSET(t_icmp *,icmp_type),	icmptype_msg,		NULL},
  {"code",	OFFSET(t_icmp *,icmp_code),	nushort_msg,		NULL},
  {"cksum",	OFFSET(t_icmp *,icmp_cksum),	nushort_msg,		NULL},
};

t_status			icmp_msg(msg,arg1,arg2)
int				msg;
VOID_PTR			arg1;
VOID_PTR			arg2;
{
  switch (msg)
    {
    case LAY_NAME:
      {
	LAY_NAME_ARGS(unused,name);
	
	(*name) = "icmp";
	return (0);
      }
    case LAY_OFF:
      {
	LAY_OFF_ARGS(b,off);
	
	(*off) = ICMP_HLEN;
	return (0);
      }
    case LAY_SUB:
      {
	LAY_SUB_ARGS(b,mp);
	
	return (icmp_sub(b->buf,b->len,mp));
      }
    case LAY_SUM:
      {
	LAY_SUM_ARGS(sd,unused);
	
	return (icmp_sum(sd->b.buf,
			 sd->b.len,
			 sd->up.buf,
			 sd->up.len));
      }
    case LAY_GET_FIELD:
      {
	LAY_GET_FIELD_ARGS(gfd,bs);
	int			i;
	t_field			*field;
	
	field = NULL;
	i = 0;
	while (i < ARRAY_COUNT(icmp_fields))
	  {
	    if (!strcmp(icmp_fields[i].name,gfd->field))
	      field = icmp_fields + i; 
	    i++;
	  }
	if (!field)
	  return (-ERR_NOENT);
	return (get_field_to_str(gfd->b.buf,
				 gfd->b.len,
				 field,
				 bs->str,
				 bs->max_len));
      }
    case LAY_SET_FIELD:
      {
	LAY_SET_FIELD_ARGS(gfd,str);
	int			i;
	t_field			*field;
	
	field = NULL;
	i = 0;
	while (i < ARRAY_COUNT(icmp_fields))
	  {
	    if (!strcmp(icmp_fields[i].name,gfd->field))
	      field = icmp_fields + i; 
	    i++;
	  }
	if (!field)
	  return (-ERR_NOENT);
	return (set_field_from_str(gfd->b.buf,
				   gfd->b.len,
				   field,
				   str));
      }
    }
  return (-ERR_NOMETHOD);
}
