/*
 * This file is a part of the gnetsentry project.
 * Copyright (C) 1998 Martin Gall
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
/*
 *
 */

#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include "miscinet.h"
#include "layeri.h"
#include "lay_arpethip.h"
#include "lay_ether.h"
#include "lay_ip.h"
#include "typ_inaddr.h"
#include "typ_ethaddr.h"

VOID_FUNC		arpethip_set_sha(aei,mba_sha)
t_arpethiphdr		*aei;	
t_ether_addr		*mba_sha;
{
  bcopy((char *)mba_sha,(char *)(&(aei->aei_sha)),
	sizeof (t_ether_addr));
}

VOID_FUNC		arpethip_get_sha(aei,mba_sha)
t_arpethiphdr		*aei;
t_ether_addr		*mba_sha;
{
  bcopy((char *)(&(aei->aei_sha)),(char *)mba_sha,
	sizeof (t_ether_addr));
}

VOID_FUNC		arpethip_set_tha(aei,mba_tha)
t_arpethiphdr		*aei;	
t_ether_addr		*mba_tha;
{
  bcopy((char *)mba_tha,(char *)(&(aei->aei_tha)),
	sizeof (t_ether_addr));
}

VOID_FUNC		arpethip_get_tha(aei,mba_tha)
t_arpethiphdr		*aei;
t_ether_addr		*mba_tha;
{
  bcopy((char *)(&(aei->aei_tha)),(char *)mba_tha,
	sizeof (t_ether_addr));
}

VOID_FUNC		arpethip_set_tpa(aei,mba_tpa)
t_arpethiphdr		*aei;	
t_in_addr		*mba_tpa;
{
  bcopy((char *)mba_tpa,(char *)(&(aei->aei_tpa)),
	sizeof (struct in_addr));
}

VOID_FUNC		arpethip_get_tpa(aei,mba_tpa)
t_arpethiphdr		*aei;
t_in_addr		*mba_tpa;
{
  bcopy((char *)(&(aei->aei_tpa)),(char *)mba_tpa,
	sizeof (struct in_addr));
}

VOID_FUNC		arpethip_set_spa(aei,mba_spa)
t_arpethiphdr		*aei;	
t_in_addr		*mba_spa;
{
  bcopy((char *)mba_spa,(char *)(&(aei->aei_spa)),
	sizeof (struct in_addr));
}

VOID_FUNC		arpethip_get_spa(aei,mba_spa)
t_arpethiphdr		*aei;
t_in_addr		*mba_spa;
{
  bcopy((char *)(&(aei->aei_spa)),(char *)mba_spa,
	sizeof (struct in_addr));
}

t_field				arpethip_fields[] = 
{
  {"sha",	OFFSET(t_arpethiphdr *,aei_sha),etheraddr_msg,		NULL},
  {"spa",	OFFSET(t_arpethiphdr *,aei_spa),inaddr_msg,		NULL},
  {"Spa",	OFFSET(t_arpethiphdr *,aei_spa),inaddr_resolved_msg,	NULL},
  {"tha",	OFFSET(t_arpethiphdr *,aei_tha),etheraddr_msg,		NULL},
  {"tpa",	OFFSET(t_arpethiphdr *,aei_tpa),inaddr_msg,		NULL},
  {"Tpa",	OFFSET(t_arpethiphdr *,aei_tpa),inaddr_resolved_msg,	NULL},
};

t_status			arpethip_msg(msg,arg1,arg2)
int				msg;
VOID_PTR			arg1;
VOID_PTR			arg2;
{
  switch (msg)
    {
    case LAY_NAME:
      {
	LAY_NAME_ARGS(unused,name);
	
	(*name) = "arpethip";
	return (0);
      }
    case LAY_GET_FIELD:
      {
	LAY_GET_FIELD_ARGS(gfd,bs);
	int			i;
	t_field			*field;
	
	field = NULL;
	i = 0;
	while (i < ARRAY_COUNT(arpethip_fields))
	  {
	    if (!strcmp(arpethip_fields[i].name,gfd->field))
	      field = arpethip_fields + i; 
	    i++;
	  }
	if (!field)
	  return (-ERR_NOENT);
	return (get_field_to_str(gfd->b.buf,
				 gfd->b.len,
				 field,
				 bs->str,
				 bs->max_len));
      }
    case LAY_SET_FIELD:
      {
	LAY_SET_FIELD_ARGS(gfd,str);
	int			i;
	t_field			*field;
	
	field = NULL;
	i = 0;
	while (i < ARRAY_COUNT(arpethip_fields))
	  {
	    if (!strcmp(arpethip_fields[i].name,gfd->field))
	      field = arpethip_fields + i; 
	    i++;
	  }
	if (!field)
	  return (-ERR_NOENT);
	return (set_field_from_str(gfd->b.buf,
				   gfd->b.len,
				   field,
				   str));
      }
    }
  return (-ERR_NOMETHOD);
}
