/*
 * This file is a part of the gnetsentry project.
 * Copyright (C) 1998 Martin Gall
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
/*
 *
 */

#ifndef MISCINET_H
#define MISCINET_H	1

#include "a.h"

/*
 * include advice :
 #include <sys/types.h>
 #include <sys/socket.h>
 #include <netinet/in.h>
 */

typedef struct		s_subnet
{
  struct in_addr	addr;
  struct in_addr	mask;
  struct in_addr	cable;	
  struct in_addr	broadcast;
} t_subnet;

#define SUBNET_ADDR		0
#define SUBNET_CABLE		1
#define SUBNET_BROADCAST	2

typedef t_status	(*t_subnet_walk_proc) P((struct in_addr *ip_addr,
						 int flag,
						 VOID_PTR data));

/* PROTO miscinet.c */
/* miscinet.c */
int port_from_str P((char *str, char *proto, t_boolean resolve));
t_status port_to_str P((int port, char *proto, char *str, int max_len, t_boolean resolve));
int proto_from_str P((char *str, t_boolean resolve));
t_status proto_to_str P((int proto, char *str, int max_len, t_boolean resolve));
t_status inaddr_from_str P((char *str, struct in_addr *mba_inaddr, t_boolean resolve));
t_status inaddr_to_str P((struct in_addr *mba_inaddr, char *str, int max_len, t_boolean resolve));
int in_class_default_nshift P((struct in_addr *addr));
t_status subnet_from_str P((char *str, t_subnet *subnet));
t_boolean is_subnet_member P((struct in_addr *inaddr, t_subnet *subnet));
void subnet_show P((t_subnet *subnet));
int subnet_walk P((t_subnet *subnet, t_subnet_walk_proc proc, void *data));
int inaddr_cmp P((struct in_addr *addr1, struct in_addr *addr2));
#endif
