/*
 * This file is a part of the gnetsentry project.
 * Copyright (C) 1998 Martin Gall
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
/*
 *
 */

#ifndef LAYER_H
#define LAYER_H	1

#include "a.h"
#include "lay_msg.h"
#include "typ_msg.h"

typedef struct		s_field
{
  char			*name;
  off_t			offset;
  t_msg_proc		mp;
  VOID_PTR		data;
} t_field;

#define LAYER_ALLOC_PROC	alloc_malloc
#define LAYER_FREE_PROC		free_free

#define LAYER_VEC_NEW(statusp)	vec_new(VEC_BASE,\
					FALSE,\
					alloc_algorithm_power2,\
					LAYER_ALLOC_PROC,\
					LAYER_FREE_PROC,\
					(statusp))

#define LAYER_DICT_NEW(statusp)	dict_new(HASH_BASE,\
					 VEC_BASE,\
					 dict_hcode_public,\
					 alloc_algorithm_power2,\
					 LAYER_ALLOC_PROC,\
					 LAYER_FREE_PROC,\
					 (statusp))

#ifdef DEBUG
extern t_mask			layer_verb_level;

# define VERB_LAY_MSG		(1L<<0)
# define VERB_TYP_MSG		(1L<<1)

# define LAYER_VERB(level)	((layer_verb_level != 0L)?\
				 (level) & layer_verb_level:FALSE) 
#endif

/* PROTO layer.c */
/* layer.c */
t_status get_field_to_str P((char *buf, int len, t_field *field, char *str, int max_len));
t_status set_field_from_str P((char *buf, int len, t_field *field, char *str));
#endif
